<?php
/**
* @version	$Id: category_items_config.php 13289 2010-03-23 20:59:40Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config =	Array (
					'Prefix'			=>	'ci',
					'ItemClass'			=>	Array('class'=>'CategoryItems_DBItem','file'=>'category_items_dbitem.php','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'CategoryItemsEventHander','file'=>'category_items_event_handler.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'CategoryItemsTagProcessor','file'=>'category_items_tag_processor.php','build_event'=>'OnBuild'),
					'AutoLoad'			=>	true,

					'QueryString'		=>	Array(
												1	=>	'id',
												2	=>	'page',
												3	=>	'event',
											),
					'IDField'			=>	'CategoryId',	// in this case idfield doesn't exit in destination table
					'StatusField'		=>	Array('PrimaryCat'),	// field, that is affected by Approve/Decline events

					'TableName'		=>	TABLE_PREFIX.'CategoryItems',
					'ParentTableKey'=>	'ResourceId',
					'ForeignKey'	=>	'ItemResourceId',
//					'ParentPrefix'	=>	'p',
					'AutoDelete'	=>	true,
					'AutoClone'		=>	false,

					'CalculatedFields' => Array(
												'' => Array (
															'DummyId'		=>	'IF(ISNULL(c.CategoryId),0,c.CategoryId)',
															'CategoryStatus'=>	'c.Status',
												)
										),
					'ListSQLs'			=>	Array(	''=>'	SELECT %1$s.* %2$s
															FROM %1$s
															LEFT JOIN '.TABLE_PREFIX.'Category AS c ON c.CategoryId = %1$s.CategoryId',
																		), // key - special, value - list select sql
					'ItemSQLs'			=>	Array(	''=>'SELECT * FROM %s',
																		),
					'ListSortings'	=> 	Array(
																'' => Array(
																	'Sorting' => Array('CategoryName' => 'asc'),
																)
															),
					'Fields'			=>	Array(
											    	'DummyId' => Array(),
													'CategoryId' => Array('type'=>'int','not_null'=>1,'default'=>0),
												    'ItemResourceId' => Array('type' => 'int', 'not_null' => 1, 'default' => 0),
												    'PrimaryCat' => Array('type' => 'int', 'not_null' => 1, 'default' => 0),
												    'ItemPrefix' => Array('type' => 'string','not_null'=>1,'default'=>''),
												    'Filename' => Array('type' => 'string','not_null'=>1,'default'=>''),
											),

					'VirtualFields'	=> 	Array (
												'CategoryName'		=>	Array(),
												'DummyId' 			=>	Array(),
												'CategoryStatus'	=>	Array(),
										),

					'Grids' => Array (
						'Default' => Array (
							'Icons' => Array (
								'default' => 'icon16_item.png',
								0 => 'icon16_item.png',
								1 => 'icon16_primary.png',
							),

							'Fields' => Array (
								'CategoryName' => Array( 'title'=>'la_col_Category', 'data_block' => 'grid_checkbox_category_td'),
							),
						),
					),
	);