function SimpleGrid($id_prefix, $field_mask, $show_order) {
	this.ItemIDs = new Array ();
	this.NextNumber = 0;
	this.IDPrefix = $id_prefix;
	this.FieldMask = $field_mask;
	this.Container = this.getControl('container');
	this.ShowOrder = $show_order;
}

SimpleGrid.prototype.registerRecord = function ($id) {
	var $prev_id = this.lastID();
	if ($prev_id !== false) {
		this.getControl('button_' + $prev_id).value = '-';
	}

	$id = parseInt($id);
	this.ItemIDs.push($id);

	if ($id < 0 && Math.abs($id) > Math.abs(this.NextNumber)) {
		this.NextNumber = $id;
	}

	if (this.ShowOrder) {
		this.getControl('number_'+$id).innerHTML = this.ItemIDs.length;
	}

	this.processRecordDependancies($id);
}

SimpleGrid.prototype.renumberRecords = function () {
	if (!this.ShowOrder) {
		return ;
	}

	var $i = 0;
	while ($i < this.ItemIDs.length) {
		this.getControl('number_' + this.ItemIDs[$i]).innerHTML = $i + 1;
		$i++;
	}
}

SimpleGrid.prototype.nextNumber = function () {
	return --this.NextNumber;
}

SimpleGrid.prototype.lastID = function () {
	return this.ItemIDs.length ? this.ItemIDs.slice(this.ItemIDs.length - 1)[0] : false;
}

SimpleGrid.prototype.toggleRecord = function ($item_id) {
	if (this.lastID() == $item_id) {
		this.addRecord();
	}
	else {
		this.removeRecord($item_id);
	}
}

SimpleGrid.prototype.getControl = function ($name) {
	return document.getElementById(this.IDPrefix + '_' + $name);
}

SimpleGrid.prototype.getField = function ($id, $field_name, $prepend, $append) {
	$prepend = isset($prepend) ? $prepend + '_' : '';
	$append = isset($append) ? '_' + $append : '';

	return document.getElementById($prepend + this.FieldMask.replace('#FIELD#', $field_name).replace('#ID#', $id) + $append);
}

SimpleGrid.prototype.markError = function ($item_id, $field_name, $error_found) {
	if (!isset($error_found)) {
		$error_found = true;
	}

	var $field = this.getField($item_id, $field_name);
	if ($error_found) {
		$field.style.backgroundColor = '#EF2C2C';

		// TODO: duplicate focus events possible on one element, fix this later
		addEvent($field, 'focus',
			function($e) {
				if (!$e) {
					$e = window.event;
				}

      			var $element = document.all ? $e.srcElement : $e.currentTarget;
				$element.style.backgroundColor = '';
			}

		);
	}
	else {
		$field.style.backgroundColor = '';
	}
}

SimpleGrid.prototype.validateRecord = function ($item_id) {
	return true;
}

SimpleGrid.prototype.validate = function () {
	var $i = 0;
	var $is_valid = true;
	while ($i < this.ItemIDs.length) {
		if (!this.validateRecord(this.ItemIDs[$i])) {
			$is_valid = false;
		}
		$i++;
	}

	return $is_valid;
}

SimpleGrid.prototype.addRecord = function () {
	var new_item_number = this.nextNumber();

	var $item_mask = this.getControl('mask').value;
	var $result_html = $item_mask.replace(/#NUMBER#/g, new_item_number);

	var $div = document.createElement('DIV');
	$div.id = this.IDPrefix + '_' + new_item_number;
	this.getControl('container').appendChild($div);
	$div.innerHTML = $result_html;

	var $js_mask = this.getControl('js_mask').value;
	var result_js = $js_mask.replace(/#NUMBER#/g, new_item_number);
	eval(result_js);
}

SimpleGrid.prototype.removeRecord = function ($number) {
	this.getControl('container').removeChild( this.getControl($number) );
	var $index = array_search($number, this.ItemIDs);
	this.ItemIDs.splice($index, 1);
	this.renumberRecords();
	this.updateTotals();
}

SimpleGrid.prototype.updateTotals = function () {
	// prototype
}

SimpleGrid.prototype.processRecordDependancies = function ($id) {
	// prototype
}
