<?php
/**
* @version	$Id: event_handler.php 12734 2009-10-20 19:28:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	/**
	 * Note:
	 *   1. When adressing variables from submit containing
	 *	 	Prefix_Special as part of their name use
	 *	 	$event->getPrefixSpecial(true) instead of
	 *	 	$event->Prefix_Special as usual. This is due PHP
	 *	 	is converting "." symbols in variable names during
	 *	 	submit info "_". $event->getPrefixSpecial optional
	 *	 	1st parameter returns correct corrent Prefix_Special
	 *	 	for variables beeing submitted such way (e.g. variable
	 *	 	name that will be converted by PHP: "users.read_only_id"
	 *	 	will be submitted as "users_read_only_id".
	 *
	 *	 2.	When using $this->Application->LinkVar on variables submitted
	 *		from the form which contains $Prefix_Special then note 1st item.
	 * 		Example: LinkVar($event->getPrefixSpecial(true).'_varname', $event->Prefix_Special.'_varname')
	 *
	 */

	/**
	 * Default event handler. Mostly abstract class
	 *
	 */
	class kEventHandler extends kBase {

		/**
		 * In case if event should be handled with mehod,
		 * which name differs from event name, then it
		 * should be specified here.
		 * key - event name, value - event method
		 *
		 * @var Array
		 * @access protected
		 */
		var $eventMethods = Array();

		/**
		 * Defines mapping vs event names and permission names
		 *
		 * @var Array
		 */
		var $permMapping = Array();

		/**
		 * Define alternative event processing method names
		 *
		 * @see $eventMethods
		 * @access protected
		 */
		function mapEvents()
		{

		}

		/**
		 * Allows to override standart permission mapping
		 *
		 */
		function mapPermissions()
		{

		}

		function getPrefixSpecial()
		{
			trigger_error('Usage of getPrefixSpecial() this method is forbidden in kEventHandler class children. Use $event->getPrefixSpecial(true); instead', E_USER_ERROR);
		}

		/**
		 * Set's prefix and special
		 *
		 * @param string $prefix
		 * @param string $special
		 * @access public
		 */
		function Init($prefix, $special)
		{
			parent::Init($prefix, $special);

			$this->mapEvents();
			$this->mapPermissions();
		}

		/**
		 * Process Event
		 *
		 * @param kEvent $event
		 * @access public
		 */
		function processEvent(&$event)
		{
			$event_name = $event->Name;

			if ( array_key_exists($event_name, $this->eventMethods) ) {
				$event_name = $this->eventMethods[$event_name];
			}

			if (method_exists($this, $event_name)) {
				$this->$event_name($event);
			}
			else {
				trigger_error('event <b>' . $event->Name . '</b> not implemented in class <b>' . get_class($this) . '</b>', E_USER_ERROR);
			}
		}

		/**
		 * Sample dummy event
		 *
		 * @param kEvent $event
		 * @access protected
		 */
		function OnBuild(&$event)
		{
			/*echo 'building: <br>';
			print_pre($event);*/
		}

		/**
		 * Returns to previous template in opener stack
		 *
		 * @param kEvent $event
		 */
		function OnGoBack(&$event)
		{
			$url = $this->Application->RecallVar('export_finish_url');
			if ($url) {
				$this->Application->Redirect('external:' . $url);
			}

			$event->SetRedirectParam('opener', 'u');
		}

		/**
		 * Apply some special processing to
		 * object beeing recalled before using
		 * it in other events that call prepareObject
		 *
		 * @param Object $object
		 * @param kEvent $event
		 * @access protected
		 */
		function prepareObject(&$object, &$event)
		{
			// processing here
		}

		/**
		 * Creates new event as child of
		 * event passed as $event param
		 *
		 * @param kEvent $event
		 * @access protected
		 */
		function &inheritEvent(&$event, $name = null)
		{
			$child_event = new kEvent();
			$child_event->MasterEvent =& $event;
			$child_event->Prefix = $event->Prefix;
			$child_event->Special = $event->Special;
			$child_event->Prefix_Special = $event->Prefix_Special;
			$child_event->Name = $name;

			return $child_event;
		}

		/**
		 * Checks permissions of user
		 *
		 * @param kEvent $event
		 */
		function CheckPermission(&$event)
		{
			$perm_helper =& $this->Application->recallObject('PermissionsHelper');

			return $perm_helper->CheckEventPermission($event, $this->permMapping);
		}

		/**
		 * Occurs, when config was parsed, allows to change config data dynamically
		 *
		 * @param kEvent $event
		 */
		function OnAfterConfigRead(&$event)
		{
			// readonly, for hooking only!
		}

	}