<?php
/**
* @version	$Id: visits_event_handler.php 12734 2009-10-20 19:28:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class VisitsEventHandler extends kDBEventHandler {

		/**
		 * Allows to override standart permission mapping
		 *
		 */
		function mapPermissions()
		{
			parent::mapPermissions();
			$permissions = Array(
				'OnItemBuild' => Array('self' => true),
			);

			$this->permMapping = array_merge($this->permMapping, $permissions);
		}

		/**
		 * Registers user visit to site
		 *
		 * @param kEvent $event
		 */
		function OnRegisterVisit(&$event)
		{
			if ($this->Application->isAdmin || !$this->Application->ConfigValue('UseVisitorTracking')) {
				// admin logins are not registred in visits list
				return true;
			}

			if ($this->Application->RecallVar('visit_id')) {
				return true;
			}

			$object =& $event->getObject( Array('skip_autoload' => true) );
			$object->SetDBField('VisitDate_date', adodb_mktime() );
			$object->SetDBField('VisitDate_time', adodb_mktime() );
			$object->SetDBField('Referer', getArrayValue($_SERVER, 'HTTP_REFERER') );
			$object->SetDBField('IPAddress', $_SERVER['REMOTE_ADDR'] );

			if ($object->Create()) {
				$this->Application->StoreVar('visit_id', $object->GetID() );
				$this->Application->SetVar('visits_id', $object->GetID() );
			}
		}

		/**
		 * Apply any custom changes to list's sql query
		 *
		 * @param kEvent $event
		 * @access protected
		 * @see OnListBuild
		 */
		function SetCustomQuery(&$event)
		{
			$object =& $event->getObject();

			$types = $event->getEventParam('types');
			if($types == 'myvisitors')
			{

				$user_id = $this->Application->RecallVar('user_id');
				$object->addFilter('myitems_user1','au.PortalUserId = '.$user_id);
				$object->addFilter('myitems_user2','au.PortalUserId >0');
				//$object->AddGroupByField('VisitDate');
				$object->AddGroupByField('%1$s.VisitId');

			}

			if($types == 'myvisitororders' && $event->Special == 'incommerce')
			{
				$user_id = $this->Application->RecallVar('user_id');
				$object->addFilter('myitems_orders','ord.OrderId IS NOT NULL');
				$object->addFilter('myitems_user1','au.PortalUserId = '.$user_id);
				$object->addFilter('myitems_user2','au.PortalUserId >0');
				$object->addFilter('myitems_orders_processed','ord.Status = 4');
			}
		}

		/**
		 * Apply some special processing to
		 * object beeing recalled before using
		 * it in other events that call prepareObject
		 *
		 * @param kBase $object
		 * @param kEvent $event
		 * @access protected
		 */
		function prepareObject(&$object, &$event)
		{
			$types = $event->getEventParam('types');
			if(method_exists($object, 'AddGroupByField'))
			{
				if( ($types == 'myvisitors' || !$types) && $object->Special == 'incommerce')
				{
					$object->addCalculatedField('OrderTotalAmountSum', 'SUM(IF(ord.Status = 4, ord.SubTotal+ord.ShippingCost+ord.VAT, 0))');
					$object->addCalculatedField('OrderAffiliateCommissionSum', 'SUM( IF(ord.Status = 4,ord.AffiliateCommission,0))');
					$object->addCalculatedField('OrderCountByVisit', 'SUM( IF(ord.Status = 4, 1, 0) )');
				}

				if (!$types){
						$object->AddGroupByField('%1$s.VisitId');
				}
			}
		}

		/**
		 * [HOOK] Updates user_id in current visit
		 *
		 * @param kEvent $event
		 */
		function OnUserLogin(&$event)
		{
			if ($event->MasterEvent->status == erSUCCESS) {
				$user_id = $this->Application->RecallVar('user_id');
				if ($user_id > 0) {
					// for real users only, not root,guest
					$this->Application->setVisitField('PortalUserId', $user_id);
				}
			}
		}

	}