<?php
/**
* @version	$Id: multilang_formatter.php 13290 2010-03-23 21:01:39Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

class kMultiLanguage extends kFormatter
{

	/**
	 * Returns ML field equivalent to field name specifed
	 *
	 * @param string $field_name
	 * @param bool $from_primary use primary/current language for name custruction
	 * @return string
	 */
	function LangFieldName($field_name, $from_primary = false)
	{
		if (preg_match('/^l[0-9]+_/', $field_name)) return $field_name;
		$lang = $from_primary ? $this->Application->GetDefaultLanguageId() : $this->Application->GetVar('m_lang');
		if (!$lang || ($lang == 'default')) {
			$lang = $this->Application->GetDefaultLanguageId();
		}

		return 'l'.$lang.'_'.$field_name;
	}

	function PrepareOptions($field_name, &$field_options, &$object)
	{
		if (getArrayValue($object->Fields, $field_name, 'master_field')) return;

		$lang_field_name = $this->LangFieldName($field_name);

		//substitude title field
		$title_field = $this->Application->getUnitOption($object->Prefix, 'TitleField');
		if ($title_field == $field_name) {
			$this->Application->setUnitOption($object->Prefix, 'TitleField', $lang_field_name);
		}

		//substitude fields
		$fields = $this->Application->getUnitOption($object->Prefix, 'Fields');
		if ( isset($fields[$field_name]) ) {

			$fields[$lang_field_name] = $fields[$field_name];
			$fields[$lang_field_name]['master_field'] = $field_name;
			$fields[$lang_field_name]['error_field'] = $field_name;
			$object->Fields[$lang_field_name] = $fields[$lang_field_name];
			$fields[$field_name]['required'] = false;
			$object->Fields[$field_name]['required'] = false;
			$object->VirtualFields[$field_name] = $object->Fields[$field_name];
		}
		$this->Application->setUnitOption($object->Prefix, 'Fields', $fields);

		//substitude virtual fields
		$virtual_fields = $this->Application->getUnitOption($object->Prefix, 'VirtualFields');
		if ( isset($virtual_fields[$field_name]) ) {
			$virtual_fields[$lang_field_name] = $virtual_fields[$field_name];
			$virtual_fields[$lang_field_name]['master_field'] = $field_name;
			$object->VirtualFields[$lang_field_name] = $virtual_fields[$lang_field_name];
			$virtual_fields[$field_name]['required'] = false;
			$object->VirtualFields[$field_name]['required'] = false;
		}
		$this->Application->setUnitOption($object->Prefix, 'VirtualFields', $virtual_fields);

		//substitude grid fields
		$grids = $this->Application->getUnitOption($object->Prefix, 'Grids', Array());
		foreach ($grids as $name => $grid) {
			if ( getArrayValue($grid, 'Fields', $field_name) ) {
				// used by column picker to track column position
				$grids[$name]['Fields'][$field_name]['formatter_renamed'] = true;

				if (!array_key_exists('format', $grids[$name]['Fields'][$field_name])) {
					// prevent displaying value from primary language
					// instead of missing value in current language
					$grids[$name]['Fields'][$field_name]['format'] = 'no_default';
				}

				array_rename_key($grids[$name]['Fields'], $field_name, $lang_field_name);
			}
			// update sort fields - used for sorting and filtering in SQLs
			foreach ($grid['Fields'] as $grid_fld_name => $fld_options) {
				if (isset($fld_options['sort_field']) && $fld_options['sort_field'] == $field_name) {
					$grids[$name]['Fields'][$grid_fld_name]['sort_field'] = $lang_field_name;
				}
			}
		}
		$this->Application->setUnitOption($object->Prefix, 'Grids', $grids);

		//substitude default sortings
		$sortings = $this->Application->getUnitOption($object->Prefix, 'ListSortings', Array());
		foreach ($sortings as $special => $the_sortings) {
			if (isset($the_sortings['ForcedSorting'])) {
				array_rename_key($sortings[$special]['ForcedSorting'], $field_name, $lang_field_name);
			}
			if (isset($the_sortings['Sorting'])) {
				array_rename_key($sortings[$special]['Sorting'], $field_name, $lang_field_name);
			}
		}
		$this->Application->setUnitOption($object->Prefix, 'ListSortings', $sortings);

		//TODO: substitude possible language-fields sortings after changing language
	}

	/*function UpdateSubFields($field, $value, &$options, &$object)
	{

	}
	*/

	/**
	 * Checks, that field value on primary language is set
	 *
	 * @param string $field
	 * @param mixed $value
	 * @param Array $options
	 * @param kDBItem $object
	 */
	function UpdateMasterFields($field, $value, &$options, &$object)
	{
		$master_field = array_key_exists('master_field', $options) ? $options['master_field'] : false;
		if (!$master_field) {
			return ;
		}

		// moved here from Parse, because at Parse time not all of the fields may be set - this is extremly actual, when working with PopulateMlFields mode
		$lang = $this->Application->GetVar('m_lang');
		$def_lang = $this->Application->GetDefaultLanguageId();

		if (!$this->Application->GetVar('allow_translation') && ($lang != $def_lang) && getArrayValue($options, 'required')) {
			$def_lang_field = 'l' . $def_lang . '_' . $master_field;
			if ( !$object->ValidateRequired($def_lang_field, $options) ) {
				$object->SetError($master_field, 'primary_lang_required');

				if (array_key_exists($def_lang_field, $object->Fields)) {
					$object->SetError($def_lang_field, 'primary_lang_required');
				}
			}
		}
	}

	function Format($value, $field_name, &$object, $format=null)
	{
		$master_field = isset($object->Fields[$field_name]['master_field']) ? $object->Fields[$field_name]['master_field'] : false;
		if (!$master_field) { // if THIS field is master it does NOT have reference to it's master_field
			$lang = $this->Application->GetVar('m_lang');
			$value = $object->GetDBField('l'.$lang.'_'.$field_name); //getting value of current language
			$master_field = $field_name; // THIS is master_field
		}
		$options = $object->GetFieldOptions($field_name);
		$format = isset($format) ? $format : ( isset($options['format']) ? $options['format'] : null);

		// use strpos, becase 2 comma-separated formats could be specified
		if ($value == '' && strpos($format, 'no_default') === false) { // try to get default language value
			$def_lang_value = $object->GetDBField('l'.$this->Application->GetDefaultLanguageId().'_'.$master_field);
			if ($def_lang_value == '') {
				return NULL;
			}

			return $this->_replaceFCKLinks($def_lang_value, $options, $format); //return value from default language
		}

		return $this->_replaceFCKLinks($value, $options, $format);
	}

	/**
	 * Performs required field check on primary language
	 *
	 * @param mixed $value
	 * @param string $field_name
	 * @param kDBItem $object
	 * @return string
	 */
	function Parse($value, $field_name, &$object)
	{
		if ($value == '') return NULL;

		return $value;
	}
}