<?php
/**
* @version	$Id: categories_config.php 13289 2010-03-23 20:59:40Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'c',
		'ItemClass' => Array ('class' => 'CategoriesItem', 'file' => 'categories_item.php', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'CategoriesEventHandler', 'file' => 'categories_event_handler.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'CategoriesTagProcessor', 'file' => 'categories_tag_processor.php', 'build_event' => 'OnBuild'),

		'RegisterClasses' => Array (
			Array ('pseudo' => 'kPermCacheUpdater', 'class' => 'kPermCacheUpdater', 'file' => 'cache_updater.php', 'build_event' => ''),
		),

		'ConfigPriority' => 0,
		'Hooks' => Array (
		   Array (
				'Mode' => hAFTER,
				'Conditional' => false,
				'HookToPrefix' => 'adm', //self
				'HookToSpecial' => '*',
				'HookToEvent' => Array('OnRebuildThemes'),
				'DoPrefix' => '',
				'DoSpecial' => '',
				'DoEvent' => 'OnAfterRebuildThemes',
			),

			Array (
				'Mode' => hBEFORE,
				'Conditional' => false,
				'HookToPrefix' => '',
				'HookToSpecial' => '*',
				'HookToEvent' => Array('OnAfterConfigRead'),
				'DoPrefix' => 'cdata',
				'DoSpecial' => '*',
				'DoEvent' => 'OnDefineCustomFields',
			),

			Array (
				'Mode' => hBEFORE,
				'Conditional' => false,
				'HookToPrefix' => 'rel',
				'HookToSpecial' => '*',
				'HookToEvent' => Array ('OnAfterConfigRead'),
				'DoPrefix' => '',
				'DoSpecial' => '*',
				'DoEvent' => 'OnCloneSubItem',
			),

			Array (
				'Mode' => hBEFORE,
				'Conditional' => false,
				'HookToPrefix' => 'img',
				'HookToSpecial' => '*',
				'HookToEvent' => Array ('OnAfterConfigRead'),
				'DoPrefix' => '',
				'DoSpecial' => '*',
				'DoEvent' => 'OnCloneSubItem',
			),
		),

		'AutoLoad' => true,
		'CatalogItem' => true,
		'AdminTemplatePath' => 'categories',
		'AdminTemplatePrefix' => 'categories_',
		'SearchConfigPostfix' => 'category',

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'event',
			4 => 'mode',
		),

		'AggregateTags' => Array (
			Array (
				'AggregateTo' => 'm',
				'AggregatedTagName' => 'CategoryLink',
				'LocalTagName' => 'CategoryLink',
			),
		),

		'IDField' => 'CategoryId',
		'StatusField' => Array ('Status'), // 'Status'
		'TitleField' => 'Name',

		'TitlePhrase' => 'la_Text_Category',
		'ItemType' => 1, // used for custom fields only

		'StatisticsInfo' => Array (
			'pending' => Array (
				'icon'		=>	'icon16_cat_pending.gif',
				'label'		=>	'la_tab_Categories',
				'js_url' 	=>	'#url#',
				'url'		=>	Array('t' => 'catalog/advanced_view', 'SetTab' => 'c', 'pass' => 'm,c.showall', 'c.showall_event' => 'OnSetFilterPattern', 'c.showall_filters' => 'show_active=0,show_pending=1,show_disabled=0,show_new=1,show_pick=1'),
				'status'	=>	STATUS_PENDING,
			),
		),

		'TableName' => TABLE_PREFIX.'Category',

		'ViewMenuPhrase' => 'la_text_Categories',
		'CatalogTabIcon' => 'icon16_sections.png',

		'TitlePresets' => Array (
			'default' => Array (
				'new_status_labels' => Array ('c' => '!la_title_Adding_Category!'),
				'edit_status_labels' => Array ('c' => '!la_title_Editing_Category!'),
				'new_titlefield' => Array ('c' => '!la_title_New_Category!'),
			),

			'category_list' => Array ('prefixes' => Array ('c_List'), 'format' => "!la_title_Categories! (#c_recordcount#)"),
			'catalog' => Array (
				'prefixes' => Array (), 'format' => "<span id='category_path'>!la_title_Categories!</span>",
				'toolbar_buttons' => Array ('select', 'cancel', 'upcat', 'homecat', 'new_cat', 'new_link', 'new_article', 'new_topic', 'new_product', 'edit', 'delete', 'new_listing', 'approve', 'decline', 'cut', 'copy', 'paste', 'move_up', 'move_down', 'tools', 'view', 'dbl-click')
			),

			'advanced_view' => Array (
				'prefixes' => Array (), 'format' => "!la_title_AdvancedView!",
				'toolbar_buttons' => Array ('select', 'cancel', 'new_cat', 'new_link', 'new_article', 'new_topic', 'new_product', 'edit', 'delete', 'new_listing', 'approve', 'decline', 'view', 'dbl-click'),
			),
			'reviews' => Array (
				'prefixes' => Array (), 'format' => "!la_title_Reviews!",
				'toolbar_buttons' => Array ('edit', 'delete', 'approve', 'decline', 'view', 'dbl-click',)
				),

			'review_edit' => Array ('prefixes' => Array (), 'format' => "!la_title_Editing_Review!"),

			'categories_edit' => Array (
				'prefixes' => Array ('c'), 'format' => "#c_status# '#c_titlefield#' - !la_title_General!",

				),

			'categories_properties' => Array (
				'prefixes' => Array ('c'), 'format' => "#c_status# '#c_titlefield#' - !la_title_Properties!",
				'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next'),
				),

			'categories_relations' => Array (
				'prefixes' => Array ('c'), 'format' => "#c_status# '#c_titlefield#' - !la_title_Relations!",
				'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next', 'new_item', 'edit', 'delete', 'approve', 'decline', 'view', 'dbl-click'),
				),

			'categories_related_searches' => Array (
				'prefixes' => Array ('c'), 'format' => "#c_status# '#c_titlefield#' - !la_title_RelatedSearches!",
				'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next', 'new_item', 'edit', 'delete', 'move_up', 'move_down', 'approve', 'decline', 'view', 'dbl-click'),
			),

			'categories_images' => Array (
				'prefixes' => Array ('c'), 'format' => "#c_status# '#c_titlefield#' - !la_title_Images!",
				'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next', 'new_item', 'edit', 'delete', 'move_up', 'move_down', 'primary_image', 'view', 'dbl-click'),
				),

			'categories_permissions' => Array (
				'prefixes' => Array ('c', 'g_List'), 'format' => "#c_status# '#c_titlefield#' - !la_title_Permissions!",
				'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next'),
				),

			'categories_custom' => Array ('prefixes' => Array ('c'), 'format' => "#c_status# '#c_titlefield#' - !la_title_Custom!"),
			'categories_update' => Array ('prefixes' => Array (), 'format' => "!la_title_UpdatingCategories!"),

			'images_edit' => Array (
				'prefixes' => Array ('c', 'c-img'),
				'new_status_labels' => Array ('c-img' => '!la_title_Adding_Image!'),
				'edit_status_labels' => Array ('c-img' => '!la_title_Editing_Image!'),
				'new_titlefield' => Array ('c-img' => ''),
				'format' => "#c_status# '#c_titlefield#' - #c-img_status# '#c-img_titlefield#'",
				'toolbar_buttons' => Array ('select', 'cancel'),
			),

			'relations_edit' => Array (
				'prefixes' => Array ('c', 'c-rel'),
				'new_status_labels' => Array ('c-rel' => "!la_title_Adding_Relationship! '!la_title_New_Relationship!'"),
				'edit_status_labels' => Array ('c-rel' => '!la_title_Editing_Relationship!'),
				'format' => "#c_status# '#c_titlefield#' - #c-rel_status#",
				'toolbar_buttons' => Array ('select', 'cancel'),
			),

			'related_searches_edit' => Array (
				'prefixes' => Array ('c', 'c-search'),
				'new_status_labels' => Array ('c-search' => "!la_title_Adding_RelatedSearch_Keyword!"),
				'edit_status_labels' => Array ('c-search' => '!la_title_Editing_RelatedSearch_Keyword!'),
				'format' => "#c_status# '#c_titlefield#' - #c-search_status#",
				'toolbar_buttons' => Array ('select', 'cancel'),
			),

			'edit_content' => Array ('format' => '!la_EditingContent!'),
			'tree_site' => Array ('format' => '!la_selecting_categories!'),
		),

		'EditTabPresets' => Array (
			'Default' => Array (
				'general' => Array ('title' => 'la_tab_General', 't' => 'categories/categories_edit', 'priority' => 1),
				'properties' => Array ('title' => 'la_tab_Properties', 't' => 'categories/categories_edit_properties', 'priority' => 2),
				'relations' => Array ('title' => 'la_tab_Relations', 't' => 'categories/categories_edit_relations', 'priority' => 3),
				'related_searches' => Array ('title' => 'la_tab_Related_Searches', 't' => 'categories/categories_edit_related_searches', 'priority' => 4),
				'images' => Array ('title' => 'la_tab_Images', 't' => 'categories/categories_edit_images', 'priority' => 5),
				'permissions' => Array ('title' => 'la_tab_Permissions', 't' => 'categories/categories_edit_permissions', 'priority' => 6),
				'custom' => Array ('title' => 'la_tab_Custom', 't' => 'categories/categories_edit_custom', 'priority' => 7),
			),
		),

		'PermItemPrefix' => 'CATEGORY',

		'PermSection' => Array ('main' => 'CATEGORY:in-portal:categories', /*'search' => 'in-portal:configuration_search',*/ 'email' => 'in-portal:configuration_email', 'custom' => 'in-portal:configuration_custom'),

		'Sections' => Array (
			'in-portal:configure_categories' => Array (
				'parent'		=>	'in-portal:website_setting_folder',
				'icon'			=>	'conf_output',
				'label'			=>	'la_tab_ConfigOutput',
				'url'			=>	Array ('t' => 'config/config_universal', 'pass_section' => true, 'pass' => 'm'),
				'permissions'	=>	Array ('view', 'edit'),
				'priority'		=>	11.1,
				'type'			=>	stTREE,
			),

			'in-portal:configuration_search' => Array (
				'parent'		=>	'in-portal:website_setting_folder',
				'icon'			=>	'conf_search',
				'label'			=>	'la_tab_ConfigSearch',
				'url'			=>	Array ('t' => 'config/config_search', 'module_key' => 'category', 'pass_section' => true, 'pass' => 'm'),
				'permissions'	=>	Array ('view', 'edit'),
				'priority'		=>	11.2,
				'type'			=>	stTREE,
			),

			'in-portal:configuration_email' => Array (
				'parent'		=>	'in-portal:website_setting_folder',
				'icon'			=>	'conf_email',
				'label'			=>	'la_tab_ConfigE-mail',
				'url'			=>	Array ('t' => 'config/config_email', 'module' => 'Core:Category', 'pass_section' => true, 'pass' => 'm'),
				'permissions'	=>	Array ('view', 'edit'),
				'priority'		=>	11.3,
				'type'			=>	stTREE,
			),

			'in-portal:configuration_custom' => Array (
				'parent'		=>	'in-portal:website_setting_folder',
				'icon'			=>	'conf_customfields',
				'label'			=>	'la_tab_ConfigCustom',
				'url'			=>	Array ('t' => 'custom_fields/custom_fields_list', 'cf_type' => 1, 'pass_section' => true, 'pass' => 'm,cf'),
				'permissions'	=>	Array ('view', 'add', 'edit', 'delete'),
				'priority'		=>	11.4,
				'type'			=>	stTREE,
			),
		),

		'FilterMenu' => Array (
			'Groups' => Array (
				Array ('mode' => 'AND', 'filters' => Array ('show_active', 'show_pending', 'show_disabled'), 'type' => WHERE_FILTER),
				Array ('mode' => 'AND', 'filters' => Array ('show_new'), 'type' => HAVING_FILTER),
				Array ('mode' => 'AND', 'filters' => Array ('show_pick'), 'type' => WHERE_FILTER),
			),
			'Filters' => Array (
				'show_active'	=>	Array ('label' =>'la_Active', 'on_sql' => '', 'off_sql' => 'Status != 1'),
				'show_pending'	=>	Array ('label' => 'la_Pending', 'on_sql' => '', 'off_sql' => 'Status != 2'),
				'show_disabled'	=>	Array ('label' => 'la_Disabled', 'on_sql' => '', 'off_sql' => 'Status != 0'),
				's1'			=>	Array (),
				'show_new'		=>	Array ('label' => 'la_Text_New', 'on_sql' => '', 'off_sql' => '`IsNew` != 1'),
				'show_pick'		=>	Array ('label' => 'la_prompt_EditorsPick', 'on_sql' => '', 'off_sql' => '`EditorsPick` != 1'),
			)
		),

		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s
					FROM %1$s
					LEFT JOIN '.TABLE_PREFIX.'Images img ON img.ResourceId = %1$s.ResourceId AND img.DefaultImg = 1
				 	LEFT JOIN '.TABLE_PREFIX.'PermCache ON '.TABLE_PREFIX.'PermCache.CategoryId = %1$s.CategoryId
				 	LEFT JOIN '.TABLE_PREFIX.'%3$sCategoryCustomData cust ON %1$s.ResourceId = cust.ResourceId'
		),

		'SubItems' => Array ('c-rel', 'c-search','c-img', 'c-cdata', 'c-perm', 'content'),

		'ListSortings' => Array (
			'' => Array (
				'Sorting' => Array ('Priority' => 'desc', 'Name' => 'asc'),
			)
		),

		'CalculatedFields' => Array (
			'' => Array (
				'CurrentSort'	=>	"REPLACE(ParentPath, CONCAT('|', ".'%1$s'.".CategoryId, '|'), '')",

				'SameImages'	=>	'img.SameImages',
				'LocalThumb'	=>	'img.LocalThumb',
				'ThumbPath'		=>	'img.ThumbPath',
				'ThumbUrl'		=>	'img.ThumbUrl',
				'LocalImage'	=>	'img.LocalImage',
				'LocalPath'		=>	'img.LocalPath',
				'FullUrl'		=>	'img.Url',
				'CreatedBySystem' => 'IF(ThemeId != 0, 1, 0)',
			)
		),

		'CacheModRewrite' => true,

		'Fields' => Array (
		    'CategoryId'				=>	Array ('type' => 'int', 'not_null' => 1,'default' => 0),
		    'Type'						=>	Array ('type' => 'int', 'not_null' => 1,'default' => 0),
		    'SymLinkCategoryId'			=>	Array ('type' => 'int', 'default' => NULL),
		    'ParentId'					=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (), 'not_null' => 1,'default' => 0, 'required' => 1),
		    'Name'						=>	Array ('type' => 'string', 'formatter' => 'kMultiLanguage', 'not_null' => 1, 'required' => 1, 'default' => ''),
		    'Filename'					=>	Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
			'AutomaticFilename'			=> 	Array (
												'type' => 'int',
												'formatter' => 'kOptionsFormatter',
												'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1,
												'default' => 1, 'not_null' => 1,
											),
		    'Description'				=>	Array ('type' => 'string', 'formatter' => 'kMultiLanguage', 'using_fck' => 1, 'default' => null),
		    'CreatedOn'					=>	Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'required' => 1, 'default' => '#NOW#'),
		    'EditorsPick'				=>  Array (
												'type' => 'int',
												'formatter' => 'kOptionsFormatter',
												'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1,
												'default' => 0, 'not_null' => 1,
											),
		    'Status'					=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Active', 2 => 'la_Pending', 0 => 'la_Disabled' ), 'use_phrases' => 1, 'not_null' => 1,'default' => 1),
		    'Priority'					=>	Array ('type' => 'int', 'not_null' => 1, 'formatter' => 'kOptionsFormatter', 'options' => Array (), 'default' => 0),
		    'MetaKeywords'				=>	Array ('type' => 'string', 'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => null),
		    'CachedDescendantCatsQty'	=>	Array ('type' => 'int', 'default' => 0),
		    'CachedNavbar'				=>	Array ('type' => 'string', 'formatter' => 'kMultiLanguage', 'default' => null),
		    'CreatedById'				=>	Array ('type' => 'int', 'formatter' => 'kLEFTFormatter', 'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'), 'options' => Array (-1 => 'root', -2 => 'Guest'),'left_sql'=>'SELECT %s FROM '.TABLE_PREFIX.'PortalUser WHERE `%s` = \'%s\'', 'left_key_field' => 'PortalUserId', 'left_title_field' => 'Login', 'not_null' => 1,'default' => 0),
		    'ResourceId'				=>	Array ('type' => 'int', 'default' => null),
		    'ParentPath'				=>	Array ('type' => 'string', 'default' => null),
		    'TreeLeft'					=>	Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'TreeRight'					=>	Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'NamedParentPath'			=>	Array ('type' => 'string', 'default' => null),
		    'MetaDescription'			=>	Array ('type' => 'string', 'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => null),
		    'HotItem'					=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (2 => 'la_Auto', 1 => 'la_Always', 0 => 'la_Never'), 'use_phrases' => 1,  'not_null' => 1, 'default' => 2),
		    'NewItem'					=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (2 => 'la_Auto', 1 => 'la_Always', 0 => 'la_Never'), 'use_phrases' => 1,  'not_null' => 1, 'default' => 2),
		    'PopItem'					=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (2 => 'la_Auto', 1 => 'la_Always', 0 => 'la_Never'), 'use_phrases' => 1,  'not_null' => 1, 'default' => 2),
		    'Modified'					=>	Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
		    'ModifiedById'				=>	Array ('type' => 'int', 'formatter' => 'kLEFTFormatter', 'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'), 'options' => Array (-1 => 'root', -2 => 'Guest'),'left_sql'=>'SELECT %s FROM '.TABLE_PREFIX.'PortalUser WHERE `%s` = \'%s\'', 'left_key_field' => 'PortalUserId', 'left_title_field' => 'Login', 'not_null' => 1,'default' => 0),
		    'CachedTemplate'			=>	Array ('type' => 'string', 'not_null' => 1, 'default' => ''),


		    // fields from Pages
		    'Template'			=>	Array (
		    	'type' => 'string',
		    	'formatter' => 'kOptionsFormatter',
		    	'options_sql' => '	SELECT	CONCAT(tf.Description, " :: ", FilePath, "/", TRIM(TRAILING ".tpl" FROM FileName) ) AS Title,
											IF(tf.TemplateAlias <> "", tf.TemplateAlias, CONCAT(FilePath, "/", TRIM(TRAILING ".tpl" FROM FileName))) AS Value
									FROM ' . TABLE_PREFIX . 'ThemeFiles AS tf
									LEFT JOIN ' . TABLE_PREFIX . 'Theme AS t ON t.ThemeId = tf.ThemeId
									WHERE (t.Enabled = 1) AND (tf.FileName NOT LIKE "%%.elm.tpl") AND (tf.FileName NOT LIKE "%%.des.tpl") AND (tf.FilePath = "/designs")
									ORDER BY tf.Description ASC, tf.FileName ASC',
				'option_key_field' => 'Value', 'option_title_field' => 'Title',
				'error_msgs' => Array (
					'no_inherit' => '!la_error_NoInheritancePossible!',
				),
				'required' => 1, 'not_null' => 1, 'default' => CATEGORY_TEMPLATE_INHERIT
			),

			'UseExternalUrl'	=>	Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter',
				'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1,
				'not_null' => 1, 'default' => 0,
			),
			'ExternalUrl'		=>	Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
			'UseMenuIconUrl'	=>	Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter',
				'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1,
				'not_null' => 1, 'default' => 0,
			),
			'MenuIconUrl'		=>	Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
			'Title'				=>	Array ('type' => 'string', 'formatter' => 'kMultiLanguage', 'default' => '', 'not_null'=>1),
			'MenuTitle'			=>	Array ('type' => 'string', 'formatter' => 'kMultiLanguage', 'not_null' => 1, 'default' => ''),
			'MetaTitle'			=>	Array ('type' => 'string', 'default' => null),
			'IndexTools'		=>	Array ('type' => 'string', 'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => null),
			'IsMenu'			=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Show', 0 => 'la_Hide'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 1),
			'IsSystem'			=>	Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_System', 0 => 'la_text_User'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 0),
			'FormId'			=>	Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array ('' => ''),
				'options_sql' => 'SELECT Title, FormId FROM '.TABLE_PREFIX.'Forms ORDER BY Title',
				'option_key_field' => 'FormId', 'option_title_field' => 'Title',
				'default' => 0
			),
			'FormSubmittedTemplate'	=>	Array ('type' => 'string', 'default' => null),
			'FriendlyURL'		=>	Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
			'ThemeId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		),

		'VirtualFields' => Array (
			'CurrentSort'	=>	Array('type' => 'string', 'default' => ''),
			'IsNew'			=>	Array('type' => 'int', 'default' => 0),
			'OldPriority'	=>	Array('type' => 'int', 'default' => 0),

			// for primary image
			'SameImages'	=>	Array('type' => 'string', 'default' => ''),
			'LocalThumb'	=>	Array('type' => 'string', 'default' => ''),
			'ThumbPath'		=>	Array('type' => 'string', 'default' => ''),
			'ThumbUrl'		=>	Array('type' => 'string', 'default' => ''),
			'LocalImage'	=>	Array('type' => 'string', 'default' => ''),
			'LocalPath'		=>	Array('type' => 'string', 'default' => ''),
			'FullUrl'		=>	Array('type' => 'string', 'default' => ''),
			'CreatedBySystem' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_System', 0 => 'la_text_User'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 0),
		),

		'Grids'	=> Array(
			'Default' => Array (
				'Icons' => Array( // 'StatusField' => Array ('IsSystem', 'Status', 'IsMenu'), // 'Status'
					'default' => 'icon_section.png',
					'1_0_0' => 'icon16_section_system.png', // system
					'1_0_1' => 'icon16_section_system.png', // system
					'1_1_1' => 'icon16_section_system.png', // system
					'0_0_0' => 'icon16_section_disabled.png', // disabled
					'0_0_1' => 'icon16_section_disabled.png', // disabled
					'0_1_0' => 'icon16_section_menuhidden.png', // hidden from menu
					'0_2_0' => 'icon16_section_pending.png', // pending
					'0_2_1' => 'icon16_section_pending.png', // pending
					'NEW' => 'icon16_section_new.png', // section is new
				),
				'Fields' => Array(
					'CategoryId' => Array( 'title'=>'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 55),
					'Name' => Array( 'title'=>'la_col_PageTitle', 'data_block' => 'page_browse_td', 'filter_block' => 'grid_like_filter', 'width' => 250),
					'Priority' => Array( 'title'=>'la_col_Priority', 'filter_block' => 'grid_options_filter', 'width' => 65),
					'Modified' => Array( 'title'=>'la_col_Modified', 'filter_block' => 'grid_date_range_filter', 'width' => 170),
					'Template' => Array( 'title'=>'la_col_TemplateType', 'filter_block' => 'grid_options_filter', 'width' => 220),
					'IsMenu' => Array( 'title'=>'la_col_InMenu', 'filter_block' => 'grid_options_filter', 'width' => 70),
					'CreatedBySystem' => Array( 'title'=>'la_col_System', 'filter_block' => 'grid_options_filter', 'width' => 100),

				),
			),

			'Radio' => Array (
				'Selector' => 'radio',
				'Icons' => Array( // 'StatusField' => Array ('IsSystem', 'Status', 'IsMenu'), // 'Status'
					'default' => 'icon_section.png',
					'1_0_0' => 'icon16_section_system.png', // system
					'1_0_1' => 'icon16_section_system.png', // system
					'1_1_1' => 'icon16_section_system.png', // system
					'0_0_0' => 'icon16_section_disabled.png', // disabled
					'0_0_1' => 'icon16_section_disabled.png', // disabled
					'0_1_0' => 'icon16_section_menuhidden.png', // hidden from menu
					'0_2_0' => 'icon16_section_pending.png', // pending
					'0_2_1' => 'icon16_section_pending.png', // pending
					'NEW' => 'icon16_section_new.png', // section is new
				),
				'Fields' => Array(
					'CategoryId' => Array( 'title'=>'la_col_Id', 'data_block' => 'grid_radio_td', 'filter_block' => 'grid_range_filter', 'width' => 55),
					'Name' => Array( 'title'=>'la_col_PageTitle', 'data_block' => 'page_browse_td', 'filter_block' => 'grid_like_filter', 'width' => 250),
					'Priority' => Array( 'title'=>'la_col_Priority', 'filter_block' => 'grid_options_filter', 'width' => 75),
					'IsMenu' => Array( 'title'=>'la_col_InMenu', 'filter_block' => 'grid_options_filter', 'width' => 70),
					'Modified' => Array( 'title'=>'la_col_Modified', 'filter_block' => 'grid_date_range_filter', 'width' => 170),
					'Template' => Array( 'title'=>'la_col_TemplateType', 'filter_block' => 'grid_options_filter', 'width' => 220),
					'CreatedBySystem' => Array( 'title'=>'la_col_System', 'filter_block' => 'grid_options_filter', 'width' => 100),

				),
			),

			'Structure' => Array (
				'Icons' => Array( // 'StatusField' => Array ('IsSystem', 'Status', 'IsMenu'), // 'Status'
					'default' => 'icon_section.png',
					'1_0_0' => 'icon16_section_system.png', // system
					'1_0_1' => 'icon16_section_system.png', // system
					'1_1_1' => 'icon16_section_system.png', // system
					'0_0_0' => 'icon16_section_disabled.png', // disabled
					'0_0_1' => 'icon16_section_disabled.png', // disabled
					'0_1_0' => 'icon16_section_menuhidden.png', // hidden from menu
					'0_2_0' => 'icon16_section_pending.png', // pending
					'0_2_1' => 'icon16_section_pending.png', // pending
					'NEW' => 'icon16_section_new.png', // section is new
				),
				'Fields' => Array(
					'CategoryId' => Array( 'title'=>'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 55),
					'Name' => Array( 'title'=>'la_col_PageTitle', 'data_block' => 'page_browse_td', 'filter_block' => 'grid_like_filter', 'width' => 250),
					'Priority' => Array( 'title'=>'la_col_Priority', 'filter_block' => 'grid_options_filter', 'width' => 75),
					'IsMenu' => Array( 'title'=>'la_col_InMenu', 'filter_block' => 'grid_options_filter', 'width' => 70),
					'Path' => Array( 'title'=>'la_col_Path', 'data_block' => 'page_entercat_td', 'filter_block' => 'grid_like_filter'),
					'Modified' => Array( 'title'=>'la_col_Modified', 'filter_block' => 'grid_date_range_filter', 'width' => 170),
					'Template' => Array( 'title'=>'la_col_TemplateType', 'filter_block' => 'grid_options_filter', 'width' => 220),
					'CreatedBySystem' => Array( 'title'=>'la_col_System', 'filter_block' => 'grid_options_filter', 'width' => 100),

				),
			),
		),

		'ConfigMapping' => Array (
			'PerPage'				=>	'Perpage_Category',
			'ShortListPerPage'		=>	'Perpage_Category_Short',
			'DefaultSorting1Field'	=>	'Category_Sortfield',
			'DefaultSorting2Field'	=>	'Category_Sortfield2',
			'DefaultSorting1Dir'	=>	'Category_Sortorder',
			'DefaultSorting2Dir'	=>	'Category_Sortorder2',
		),
	);