<?php
/**
* @version	$Id: site_config_eh.php 12734 2009-10-20 19:28:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class SiteConfigEventHandler extends kEventHandler {

		/**
		 * SiteConfigHelper instance
		 *
		 * @var SiteConfigHelper
		 */
		var $_helper = null;

		/**
		 * [HOOK] Universal hook to modify all configs
		 *
		 * @param kEvent $event
		 */
		function OnApplySiteConfigChanges(&$event)
		{
			if (!isset($this->_helper)) {
				$this->_helper =& $this->Application->recallObject('SiteConfigHelper');
			}

			$prefix_file = basename( $this->Application->UnitConfigReader->getPrefixFile($event->MasterEvent->Prefix) );

			$cut_pos = strrpos($prefix_file, '_config.php');
			$prefix_file = substr($prefix_file, 0, $cut_pos) . '_' . $event->MasterEvent->Prefix . '.php';

			if (file_exists(SYSTEM_PRESET_PATH . DIRECTORY_SEPARATOR . $prefix_file)) {
				require SYSTEM_PRESET_PATH . DIRECTORY_SEPARATOR . $prefix_file;
			}
			else {
				return ;
			}

			$change_names = Array (
				'remove_sections', 'debug_only_sections', 'remove_buttons',
				'hidden_fields', 'virtual_hidden_fields', 'debug_only_fields', 'debug_only_virtual_fields',
				'required_fields', 'virtual_required_fields', 'hide_edit_tabs', 'hide_columns'
			);

			$changes = Array ();
			foreach ($change_names as $change_name) {
				if (isset($$change_name)) {
					$changes[$change_name] = $$change_name;
				}
			}

			// apply changes
			$this->_helper->processConfigChanges($event->MasterEvent->Prefix, $changes);
		}
	}