<?php
/**
* @version	$Id: email_events_config.php 12734 2009-10-20 19:28:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'emailevents',
		'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'EmailEventsEventsHandler', 'file' => 'email_events_event_handler.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'kDBTagProcessor', 'file' => '', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'event',
			4 => 'mode',
		),

		'IDField' => 'EventId',
		'StatusField' => Array ('Enabled'),
		'TitleField' => 'Event',

		'TitlePresets' => Array (
			'default' => Array (
				'edit_status_labels' => Array ('emailevents' => '!la_title_EditingEmailEvent!'),
			),

			'email_settings_list' => Array ('prefixes'	=> Array ('emailevents.module_List'), 'format' => '!la_title_EmailSettings!'),

			'email_settings_edit' => Array (
				'prefixes' => Array ('emailevents'), 'format' => "#emailevents_status# '#emailevents_titlefield#'",
				'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
			),

			'email_send_form' => Array ('prefixes' => Array (), 'format' => '!la_title_SendEmail!'),
			'email_prepare' => Array ('prefixes' => Array (), 'format' => '!la_title_PreparingEmailsForSending!. !la_title_PleaseWait!'),
			'email_send' => Array ('prefixes' => Array (), 'format' => '!la_title_SendingPreparedEmails!. !la_title_PleaseWait!'),
			'email_send_complete' => Array ('prefixes' => Array (), 'format' => '!la_title_SendMailComplete!'),
		),

		'PermSection' => Array ('main' => 'in-portal:configure_lang'),

		'FilterMenu' => Array (
			'Groups' => Array (
				Array ('mode' => 'AND', 'filters' => Array ('show_enabled', 'show_disabled', 'show_frontonly'), 'type' => WHERE_FILTER),
			),

			'Filters' => Array (
				'show_enabled' => Array ('label' =>'la_Enabled', 'on_sql' => '', 'off_sql' => '%1$s.Enabled != 1' ),
				'show_disabled' => Array ('label' => 'la_Disabled', 'on_sql' => '', 'off_sql' => '%1$s.Enabled != 0'  ),
				'show_frontonly' => Array ('label' => 'la_Text_FrontOnly', 'on_sql' => '', 'off_sql' => '%1$s.Enabled != 2'  ),
			)
		),

		'TableName' => TABLE_PREFIX . 'Events',

		'CalculatedFields' => Array (
			'' => Array (
				'FromUser' => 'u.Login',
			)
		),

		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s
					FROM %1$s
					LEFT JOIN ' . TABLE_PREFIX . 'PortalUser u ON %1$s.FromUserId = u.PortalUserId',
		),

		'ListSortings' => Array (
			'' => Array ('Sorting' => Array ('Module' => 'asc', 'Description'	=> 'asc')),
			'module' => Array ('Sorting' => Array ('Description' => 'asc') ),
		),

		'Fields' => Array (
			'EventId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
            'Event' => Array ('type' => 'string', 'not_null' => 1, 'required' => 1, 'default' => ''),
            'ReplacementTags' => Array ('type' => 'string', 'default' => NULL),

            'Enabled' => Array (
            	'type' => 'int',
            	'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
            	'not_null' => 1, 'default' => 1
            ),

            'FrontEndOnly' => Array (
            	'type' => 'int',
            	'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
            	'not_null' => 1, 'default' => 0
            ),

            'FromUserId' => Array (
            	'type' => 'int',
            	'formatter' => 'kLEFTFormatter', 'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'), 'options' => Array (-1 => 'root'), 'left_sql' => 'SELECT %s FROM '.TABLE_PREFIX.'PortalUser WHERE `%s` = \'%s\'', 'left_key_field' => 'PortalUserId', 'left_title_field' => 'Login',
            	'default' => NULL
            ),

            'Module' => Array ('type' => 'string', 'not_null' => 1, 'required' => 1, 'default' => ''),
            'Description' => Array ('type' => 'string', 'not_null' => 1, 'required' => 1, 'default' => ''),
            'Type' => Array (
            	'type' => 'int',
            	'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Text_Admin', 0 => 'la_Text_User'), 'use_phrases' => 1,
            	'not_null' => 1, 'required' => 1, 'default' => 0
            ),
    	),

		'VirtualFields' => Array (
			'FromUser'	=>	Array ('type' => 'string', 'default' => ''),
		),

		'Grids'	=> Array (
			'Default' => Array (
				'Icons' => Array (
					'default' => 'icon16_item.png',
					0 => 'icon16_disabled.png',
					1 => 'icon16_item.png',
				),
				'Fields' => Array (
					'EventId' => Array ('title' => 'la_col_Id', 'filter_block' => 'grid_range_filter', 'width' => 70, ),
					'Description'	=>	Array ( 'title' => 'la_col_Description', 'data_block' => 'label_grid_checkbox_td', 'filter_block' => 'grid_like_filter', 'width' => 250, ),
					'Event'			=>	Array ( 'title' => 'la_col_Event', 'filter_block' => 'grid_like_filter', 'width' => 250, ),
					'Module'		=>	Array ( 'title' => 'la_col_Module', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
					'Type'			=>	Array ( 'title' => 'la_col_Type', 'filter_block' => 'grid_options_filter', 'width' => 120, ),
					'Enabled'		=>	Array ( 'title' => 'la_col_Status', 'filter_block' => 'grid_options_filter', 'width' => 80, ),
				),
			),

			'EmailSettings' => Array (
				'Icons' => Array (
					'default' => 'icon16_item.png',
					0 => 'icon16_disabled.png',
					1 => 'icon16_item.png',
				),
				'Fields' => Array (
					'EventId' => Array ('title' => 'la_col_Id', 'filter_block' => 'grid_range_filter', 'width' => 70, ),
					'Description' => Array ('title' => 'la_col_EventDescription', 'data_block' => 'label_grid_checkbox_td', 'width' => 250, ),
					'FromUser' => Array ('title' => 'la_col_FromToUser', 'data_block' => 'from_user_td', 'filter_block' => 'grid_like_filter', 'width' => 150, ),
        			'Type' => Array ('title' => 'la_col_RecipientType', 'filter_block' => 'grid_options_filter', 'width' => 120, ),
					'FrontEndOnly' => Array ('title' => 'la_col_FrontEndOnly', 'filter_block' => 'grid_options_filter', 'width' => 120, ),
					'Enabled' => Array ('title' => 'la_col_Enabled', 'filter_block' => 'grid_options_filter', 'width' => 80, ),
				),
			),
		),
	);