# ===== v 4.0.1 =====
ALTER TABLE EmailLog ADD EventParams TEXT NOT NULL;

INSERT INTO ConfigurationAdmin VALUES ('MailFunctionHeaderSeparator', 'la_Text_smtp_server', 'la_config_MailFunctionHeaderSeparator', 'radio', NULL, '1=la_Linux,2=la_Windows', 30.08, 0, 0);
INSERT INTO ConfigurationValues VALUES (0, 'MailFunctionHeaderSeparator', 1, 'In-Portal', 'in-portal:configure_general');

ALTER TABLE PersistantSessionData DROP PRIMARY KEY ;
ALTER TABLE PersistantSessionData ADD INDEX ( `PortalUserId` ) ;

# ===== v 4.1.0 =====
ALTER TABLE EmailMessage ADD ReplacementTags TEXT AFTER Template;
ALTER TABLE Phrase
	CHANGE Translation Translation TEXT NOT NULL,
	CHANGE Module Module VARCHAR(30) NOT NULL DEFAULT 'In-Portal';
ALTER TABLE Category
	CHANGE Description Description TEXT,
	CHANGE l1_Description l1_Description TEXT,
	CHANGE l2_Description l2_Description TEXT,
	CHANGE l3_Description l3_Description TEXT,
	CHANGE l4_Description l4_Description TEXT,
	CHANGE l5_Description l5_Description TEXT,
	CHANGE CachedNavbar CachedNavbar text,
	CHANGE l1_CachedNavbar l1_CachedNavbar text,
	CHANGE l2_CachedNavbar l2_CachedNavbar text,
	CHANGE l3_CachedNavbar l3_CachedNavbar text,
	CHANGE l4_CachedNavbar l4_CachedNavbar text,
	CHANGE l5_CachedNavbar l5_CachedNavbar text,
	CHANGE ParentPath ParentPath TEXT NULL DEFAULT NULL,
	CHANGE NamedParentPath NamedParentPath TEXT NULL DEFAULT NULL;
ALTER TABLE ConfigurationAdmin CHANGE ValueList ValueList TEXT;
ALTER TABLE EmailQueue
	CHANGE `Subject` `Subject` TEXT,
	CHANGE toaddr toaddr TEXT,
	CHANGE fromaddr fromaddr TEXT;
ALTER TABLE Category DROP Pop;
ALTER TABLE PortalUser
	CHANGE CreatedOn CreatedOn INT DEFAULT NULL,
	CHANGE dob dob INT(11) NULL DEFAULT NULL,
	CHANGE PassResetTime PassResetTime INT(11) UNSIGNED NULL DEFAULT NULL,
	CHANGE PwRequestTime PwRequestTime INT(11) UNSIGNED NULL DEFAULT NULL,
	CHANGE `Password` `Password` VARCHAR(255) NULL DEFAULT 'd41d8cd98f00b204e9800998ecf8427e';
ALTER TABLE Modules
	CHANGE BuildDate BuildDate INT UNSIGNED NULL DEFAULT NULL,
	CHANGE Version Version VARCHAR(10) NOT NULL DEFAULT '0.0.0',
	CHANGE `Var` `Var` VARCHAR(100) NOT NULL DEFAULT '';
ALTER TABLE Language
	CHANGE Enabled Enabled INT(11) NOT NULL DEFAULT '1',
	CHANGE InputDateFormat InputDateFormat VARCHAR(50) NOT NULL DEFAULT 'm/d/Y',
	CHANGE InputTimeFormat InputTimeFormat VARCHAR(50) NOT NULL DEFAULT 'g:i:s A',
	CHANGE DecimalPoint DecimalPoint VARCHAR(10) NOT NULL DEFAULT '',
	CHANGE ThousandSep ThousandSep VARCHAR(10) NOT NULL DEFAULT '';
ALTER TABLE Events CHANGE FromUserId FromUserId INT(11) NOT NULL DEFAULT '-1';
ALTER TABLE StdDestinations CHANGE DestAbbr2 DestAbbr2 CHAR(2) NULL DEFAULT NULL;
ALTER TABLE PermCache DROP DACL;
ALTER TABLE PortalGroup CHANGE CreatedOn CreatedOn INT UNSIGNED NULL DEFAULT NULL;
ALTER TABLE UserSession
	CHANGE SessionKey SessionKey INT UNSIGNED NULL DEFAULT NULL ,
	CHANGE CurrentTempKey CurrentTempKey INT UNSIGNED NULL DEFAULT NULL ,
	CHANGE PrevTempKey PrevTempKey INT UNSIGNED NULL DEFAULT NULL ,
	CHANGE LastAccessed LastAccessed INT UNSIGNED NOT NULL DEFAULT '0',
	CHANGE PortalUserId PortalUserId INT(11) NOT NULL DEFAULT '-2',
	CHANGE Language Language INT(11) NOT NULL DEFAULT '1',
	CHANGE Theme Theme INT(11) NOT NULL DEFAULT '1';
CREATE TABLE Counters (
  CounterId int(10) unsigned NOT NULL auto_increment,
  Name varchar(100) NOT NULL default '',
  CountQuery text,
  CountValue text,
  LastCounted int(10) unsigned default NULL,
  LifeTime int(10) unsigned NOT NULL default '3600',
  IsClone tinyint(3) unsigned NOT NULL default '0',
  TablesAffected text,
  PRIMARY KEY  (CounterId),
  UNIQUE KEY Name (Name)
);
CREATE TABLE Skins (
  `SkinId` int(11) NOT NULL auto_increment,
  `Name` varchar(255) default NULL,
  `CSS` text,
  `Logo` varchar(255) default NULL,
  `Options` text,
  `LastCompiled` int(11) NOT NULL default '0',
  `IsPrimary` int(1) NOT NULL default '0',
  PRIMARY KEY  (`SkinId`)
);
INSERT INTO Skins VALUES (DEFAULT, 'Default', '/* General elements */\r\n\r\nhtml {\r\n	height: 100%;\r\n}\r\n\r\nbody {\r\n 	font-family: verdana,arial,helvetica,sans-serif;\r\n	font-size: 9pt;\r\n 	color: #000000;\r\n	overflow-x: auto; overflow-y: auto;\r\n	margin: 0px 0px 0px 0px;\r\n	text-decoration: none;\r\n}\r\n\r\na {\r\n	color: #006699;\r\n	text-decoration: none;\r\n}\r\n\r\na:hover {\r\n	color: #009ff0;\r\n	text-decoration: none;\r\n}\r\n\r\nform {\r\n   display: inline;\r\n}\r\n\r\nimg { border: 0px; }\r\n\r\nbody.height-100 {\r\n	height: 100%;\r\n}\r\n\r\nbody.regular-body {\r\n	margin: 0px 10px 5px 10px;\r\n	color: #000000;\r\n	background-color: @@SectionBgColor@@;\r\n}\r\n\r\nbody.edit-popup {\r\n	margin: 0px 0px 0px 0px;\r\n}\r\n\r\ntable.collapsed {\r\n	border-collapse: collapse;\r\n}\r\n\r\n.bordered, table.bordered, .bordered-no-bottom {\r\n	border: 1px solid #000000;\r\n	border-collapse: collapse;\r\n}\r\n\r\n.bordered-no-bottom {\r\n	border-bottom: none;\r\n}\r\n\r\n.login-table td {\r\n	padding: 1px;\r\n}\r\n\r\n.disabled {\r\n	background-color: #ebebeb;\r\n}\r\n\r\n/* Head frame */\r\n.head-table tr td {\r\n	background-color: @@HeadBgColor@@;\r\n	color: @@HeadColor@@\r\n}\r\n\r\ntd.kx-block-header, .head-table tr td.kx-block-header{\r\n	color: @@HeadBarColor@@;\r\n	background-color: @@HeadBarBgColor@@;\r\n	padding-left: 7px;\r\n	padding-right: 7px;\r\n}\r\n\r\na.kx-header-link {\r\n	text-decoration: underline;\r\n	color: #FFFFFF;\r\n}\r\n\r\na.kx-header-link:hover {\r\n	color: #FFCB05;\r\n	text-decoration: none;\r\n}\r\n\r\n.kx-secondary-foreground 	{\r\n	color: @@HeadBarColor@@;\r\n	background-color: @@HeadBarBgColor@@;\r\n}\r\n\r\n.kx-login-button {\r\n	background-color: #2D79D6;\r\n	color: #FFFFFF;\r\n}\r\n\r\n/* General form button (yellow) */\r\n.button {\r\n	font-size: 12px;\r\n	font-weight: normal;\r\n	color: #000000;\r\n	background: url(@@base_url@@/proj-base/admin_templates/img/button_back.gif) #f9eeae repeat-x;\r\n	text-decoration: none;\r\n}\r\n\r\n/* Disabled (grayed-out) form button */\r\n.button-disabled {\r\n	font-size: 12px;\r\n	font-weight: normal;\r\n	color: #676767;\r\n	background: url(@@base_url@@/proj-base/admin_templates/img/button_back_disabled.gif) #f9eeae repeat-x;\r\n	text-decoration: none;\r\n}\r\n\r\n/* Tabs bar */\r\n\r\n.tab, .tab-active {\r\n	background-color: #F0F1EB;\r\n	padding: 3px 7px 2px 7px;\r\n	border-top: 1px solid black;\r\n	border-left: 1px solid black;\r\n	border-right: 1px solid black;\r\n}\r\n\r\n.tab-active {\r\n	background-color: #2D79D6;\r\n	border-bottom: 1px solid #2D79D6;\r\n}\r\n\r\n.tab a {\r\n	color: #00659C;\r\n	font-weight: bold;\r\n}\r\n\r\n.tab-active a {\r\n	color: #fff;\r\n	font-weight: bold;\r\n}\r\n\r\n\r\n/* Toolbar */\r\n\r\n.toolbar {\r\n	font-size: 8pt;\r\n	border: 1px solid #000000;\r\n	border-width: 0px 1px 1px 1px;\r\n	background-color: @@ToolbarBgColor@@;\r\n	border-collapse: collapse;\r\n}\r\n\r\n.toolbar td {\r\n	height: 100%;\r\n}\r\n\r\n.toolbar-button, .toolbar-button-disabled, .toolbar-button-over {\r\n	float: left;\r\n	text-align: center;\r\n	font-size: 8pt;\r\n	padding: 5px 5px 5px 5px;\r\n	vertical-align: middle;\r\n	color: #006F99;\r\n}\r\n\r\n.toolbar-button-over {\r\n	color: #000;\r\n}\r\n\r\n.toolbar-button-disabled {\r\n	color: #444;\r\n}\r\n\r\n/*  Scrollable Grids */\r\n\r\n\r\n/* Main Grid class */\r\n.grid-scrollable {\r\n	padding: 0px;\r\n	border: 1px solid black !important;\r\n	border-top: none !important;\r\n}\r\n\r\n/* Div generated by js, which contains all the scrollable grid elements, affects the style of scrollable area without data (if there are too few rows) */\r\n.grid-container {\r\n	background-color: #fff;\r\n}\r\n\r\n.grid-container table {\r\n	border-collapse: collapse;\r\n}\r\n\r\n/* Inner div generated in each data-cell */\r\n.grid-cell-div {\r\n	overflow: hidden;\r\n	height: auto;\r\n}\r\n\r\n/* Main row definition */\r\n.grid-data-row td, .grid-data-row-selected td, .grid-data-row-even-selected td, .grid-data-row-mouseover td, .table-color1, .table-color2 {\r\n	font-weight: normal;\r\n	color: @@OddColor@@;\r\n	background-color: @@OddBgColor@@;\r\n	padding: 3px 5px 3px 5px;\r\n	height: 30px;\r\n	overflow: hidden;\r\n	/* border-right: 1px solid black; */\r\n}\r\n.grid-data-row-even td, .table-color2 {\r\n	background-color: @@EvenBgColor@@;\r\n	color: @@EvenColor@@;\r\n}\r\n.grid-data-row td a, .grid-data-row-selected td a, .grid-data-row-mouseover td a {\r\n	text-decoration: underline;\r\n}\r\n\r\n/* mouse-over rows */\r\n.grid-data-row-mouseover td {\r\n	background: #FFFDF4;\r\n}\r\n\r\n/* Selected row, applies to both checkbox and data areas */\r\n.grid-data-row-selected td {\r\n	background: #FEF2D6;\r\n}\r\n\r\n.grid-data-row-even-selected td {\r\n	background: #FFF7E0;\r\n}\r\n\r\n/* General header cell definition */\r\n.grid-header-row td {\r\n	font-weight: bold;\r\n	background-color: @@ColumnTitlesBgColor@@;\r\n	text-decoration: none;\r\n	padding: 3px 5px 3px 5px;\r\n	color: @@ColumnTitlesColor@@;\r\n	border-right: none;\r\n	text-align: left;\r\n	vertical-align: middle !important;\r\n	white-space: nowrap;\r\n	/* border-right: 1px solid black; */\r\n}\r\n\r\n/* Filters row */\r\ntr.grid-header-row-0 td {\r\n	background-color: @@FiltersBgColor@@;\r\n	border-bottom: 1px solid black;\r\n}\r\n\r\n/* Grid Filters */\r\ntable.range-filter {\r\n	width: 100%;\r\n}\r\n\r\n.range-filter td {\r\n	padding: 0px 0px 2px 2px !important;\r\n	border: none !important;\r\n	font-size: 8pt !important;\r\n	font-weight: normal !important;\r\n	text-align: left;\r\n	color: #000000 !important;\r\n}\r\n\r\ninput.filter, select.filter {\r\n	margin-bottom: 0px;\r\n	width: 85%;\r\n}\r\n\r\ninput.filter-active {\r\n  background-color: #FFFF00;\r\n}\r\n\r\nselect.filter-active {\r\n background-color: #FFFF00;\r\n}\r\n\r\n/* Column titles row */\r\ntr.grid-header-row-1 td {\r\n	height: 25px;\r\n	font-weight: bold;\r\n	background-color: @@ColumnTitlesBgColor@@;\r\n	color: @@ColumnTitlesColor@@;\r\n}\r\n\r\ntr.grid-header-row-1 td a {\r\n	color: @@ColumnTitlesColor@@;\r\n}\r\n\r\ntr.grid-header-row-1 td a:hover {\r\n	color: #FFCC00;\r\n}\r\n\r\n\r\n.grid-footer-row td {\r\n	background-color: #D7D7D7;\r\n	font-weight: bold;\r\n	border-right: none;\r\n	padding: 3px 5px 3px 5px;\r\n}\r\n\r\ntd.grid-header-last-cell, td.grid-data-last-cell, td.grid-footer-last-cell {\r\n	border-right: none !important;\r\n}\r\n\r\ntd.grid-data-col-0, td.grid-data-col-0 div {\r\n	text-align: center;\r\n	vertical-align: middle !important;\r\n}\r\n\r\ntr.grid-header-row-0 td.grid-header-col-0 {\r\n	text-align: center;\r\n	vertical-align: middle !important;\r\n}\r\n\r\ntr.grid-header-row-0 td.grid-header-col-0 div {\r\n	display: table-cell;\r\n	vertical-align: middle;\r\n}\r\n\r\n.grid-status-bar {\r\n	border: 1px solid black;\r\n	border-top: none;\r\n	padding: 0px;\r\n	width: 100%;\r\n	border-collapse: collapse;\r\n	height: 30px;\r\n}\r\n\r\n.grid-status-bar td {\r\n	background-color: @@TitleBarBgColor@@;\r\n  color: @@TitleBarColor@@;\r\n	font-size: 11pt;\r\n	font-weight: normal;\r\n	padding: 2px 8px 2px 8px;\r\n}\r\n\r\n/*  /Scrollable Grids */\r\n\r\n\r\n/* Forms */\r\ntable.edit-form {\r\n	border: none;\r\n	border-top-width: 0px;\r\n	border-collapse: collapse;\r\n	width: 100%;\r\n}\r\n\r\n.edit-form-odd, .edit-form-even {\r\n	padding: 0px;\r\n}\r\n\r\n.subsectiontitle {\r\n	font-size: 10pt;\r\n	font-weight: bold;\r\n	background-color: #4A92CE;\r\n	color: #fff;\r\n	height: 25px;\r\n	border-top: 1px solid black;\r\n}\r\n\r\n.label-cell {\r\n	background: #DEE7F6 url(@@base_url@@/proj-base/admin_templates/img/bgr_input_name_line.gif) no-repeat right bottom;\r\n  font: 12px arial, sans-serif;\r\n  padding: 4px 20px;\r\n  width: 150px;\r\n}\r\n\r\n.control-mid {\r\n	width: 13px;\r\n	border-left: 1px solid #7A95C2;\r\n	background: #fff url(@@base_url@@/proj-base/admin_templates/img/bgr_mid.gif) repeat-x left bottom;\r\n}\r\n\r\n.control-cell {\r\n	font: 11px arial, sans-serif;\r\n	padding: 4px 10px 5px 5px;\r\n	background: #fff url(@@base_url@@/proj-base/admin_templates/img/bgr_input_line.gif) no-repeat left bottom;\r\n	width: auto;\r\n	vertical-align: middle;\r\n}\r\n\r\n.label-cell-filler {\r\n	background: #DEE7F6 none;\r\n}\r\n.control-mid-filler {\r\n	background: #fff none;\r\n	border-left: 1px solid #7A95C2;\r\n}\r\n.control-cell-filler {\r\n	background: #fff none;\r\n}\r\n\r\n\r\n.error-cell {\r\n	background-color: #fff;\r\n	color: red;\r\n}\r\n\r\n.form-warning {\r\n	color: red;\r\n}\r\n\r\n.req-note {\r\n	font-style: italic;\r\n	color: #333;\r\n}\r\n\r\n#scroll_container table.tableborder {\r\n	border-collapse: separate\r\n}\r\n\r\n\r\n/* Uploader */\r\n\r\n.uploader-main {\r\n	position: absolute;\r\n	display: none;\r\n	z-index: 10;\r\n	border: 1px solid #777;\r\n	padding: 10px;\r\n	width: 350px;\r\n	height: 120px;\r\n	overflow: hidden;\r\n	background-color: #fff;\r\n}\r\n\r\n.uploader-percent {\r\n	width: 100%;\r\n	padding-top: 3px;\r\n	text-align: center;\r\n	position: relative;\r\n	z-index: 20;\r\n	float: left;\r\n	font-weight: bold;\r\n}\r\n\r\n.uploader-left {\r\n	width: 100%;\r\n	border: 1px solid black;\r\n	height: 20px;\r\n	background: #fff url(@@base_url@@/core/admin_templates/img/progress_left.gif);\r\n}\r\n\r\n.uploader-done {\r\n	width: 0%;\r\n	background-color: green;\r\n	height: 20px;\r\n	background: #4A92CE url(@@base_url@@/core/admin_templates/img/progress_done.gif);\r\n}\r\n\r\n\r\n/* To be sorted */\r\n\r\n\r\n/* Section title, right to the big icon */\r\n.admintitle {\r\n	font-size: 16pt;\r\n	font-weight: bold;\r\n	color: @@SectionColor@@;\r\n	text-decoration: none;\r\n}\r\n\r\n/* Left sid of bluebar */\r\n.header_left_bg {\r\n	background-color: @@TitleBarBgColor@@;\r\n	background-image: none;\r\n	padding-left: 5px;\r\n}\r\n\r\n/* Right side of bluebar */\r\n.tablenav, tablenav a {\r\n	font-size: 11pt;\r\n	font-weight: bold;\r\n	color: @@TitleBarColor@@;\r\n\r\n	text-decoration: none;\r\n	background-color: @@TitleBarBgColor@@;\r\n	background-image: none;\r\n}\r\n\r\n/* Section title in the bluebar * -- why ''link''? :S */\r\n.tablenav_link {\r\n	font-size: 11pt;\r\n	font-weight: bold;\r\n	color: @@TitleBarColor@@;\r\n	text-decoration: none;\r\n}\r\n\r\n/* Active page in top and bottom bluebars pagination */\r\n.current_page {\r\n	font-size: 10pt;\r\n	font-weight: bold;\r\n	background-color: #fff;\r\n	color: #2D79D6;\r\n	padding: 3px 2px 3px 3px;\r\n}\r\n\r\n/* Other pages and arrows in pagination on blue */\r\n.nav_url {\r\n	font-size: 10pt;\r\n	font-weight: bold;\r\n	color: #fff;\r\n	padding: 3px 2px 3px 3px;\r\n}\r\n\r\n/* Tree */\r\n.tree-body {\r\n	background-color: @@TreeBgColor@@;\r\n	height: 100%\r\n}\r\n\r\n.tree_head.td, .tree_head, .tree_head:hover {\r\n font-weight: bold;\r\n font-size: 10px;\r\n color: #FFFFFF;\r\n font-family: Verdana, Arial;\r\n text-decoration: none;\r\n}\r\n\r\n.tree {\r\n	padding: 0px;\r\n	border: none;\r\n	border-collapse: collapse;\r\n}\r\n\r\n.tree tr td {\r\n	padding: 0px;\r\n	margin: 0px;\r\n	font-family: helvetica, arial, verdana,;\r\n	font-size: 11px;\r\n	white-space: nowrap;\r\n}\r\n\r\n.tree tr td a {\r\n	font-size: 11px;\r\n	color: @@TreeColor@@;\r\n	font-family: Helvetica, Arial, Verdana;\r\n	text-decoration: none;\r\n	padding: 2px 0px 2px 2px;\r\n}\r\n\r\n.tree tr.highlighted td a {\r\n	background-color: @@TreeHighBgColor@@;\r\n	color: @@TreeHighColor@@;\r\n}\r\n\r\n.tree tr.highlighted td a:hover {\r\n	color: #fff;\r\n}\r\n\r\n.tree tr td a:hover {\r\n	color: #000000;\r\n}', 'just_logo.gif', 'a:20:{s:11:"HeadBgColor";a:2:{s:11:"Description";s:27:"Head frame background color";s:5:"Value";s:7:"#1961B8";}s:9:"HeadColor";a:2:{s:11:"Description";s:21:"Head frame text color";s:5:"Value";s:7:"#CCFF00";}s:14:"SectionBgColor";a:2:{s:11:"Description";s:28:"Section bar background color";s:5:"Value";s:7:"#FFFFFF";}s:12:"SectionColor";a:2:{s:11:"Description";s:22:"Section bar text color";s:5:"Value";s:7:"#2D79D6";}s:12:"HeadBarColor";a:1:{s:5:"Value";s:7:"#FFFFFF";}s:14:"HeadBarBgColor";a:1:{s:5:"Value";s:7:"#1961B8";}s:13:"TitleBarColor";a:1:{s:5:"Value";s:7:"#FFFFFF";}s:15:"TitleBarBgColor";a:1:{s:5:"Value";s:7:"#2D79D6";}s:14:"ToolbarBgColor";a:1:{s:5:"Value";s:7:"#F0F1EB";}s:14:"FiltersBgColor";a:1:{s:5:"Value";s:7:"#D7D7D7";}s:17:"ColumnTitlesColor";a:1:{s:5:"Value";s:7:"#FFFFFF";}s:19:"ColumnTitlesBgColor";a:1:{s:5:"Value";s:7:"#999999";}s:8:"OddColor";a:1:{s:5:"Value";s:7:"#000000";}s:10:"OddBgColor";a:1:{s:5:"Value";s:7:"#F6F6F6";}s:9:"EvenColor";a:1:{s:5:"Value";s:7:"#000000";}s:11:"EvenBgColor";a:1:{s:5:"Value";s:7:"#EBEBEB";}s:9:"TreeColor";a:1:{s:5:"Value";s:7:"#006F99";}s:11:"TreeBgColor";a:1:{s:5:"Value";s:7:"#FFFFFF";}s:13:"TreeHighColor";a:1:{s:5:"Value";s:7:"#FFFFFF";}s:15:"TreeHighBgColor";a:1:{s:5:"Value";s:7:"#4A92CE";}}', 1178706881, 1);
INSERT INTO Permissions VALUES (0, 'in-portal:skins.view', 11, 1, 1, 0), (0, 'in-portal:skins.add', 11, 1, 1, 0), (0, 'in-portal:skins.edit', 11, 1, 1, 0), (0, 'in-portal:skins.delete', 11, 1, 1, 0);

# ===== v 4.1.1 =====
DROP TABLE EmailQueue;

CREATE TABLE EmailQueue (
  EmailQueueId int(10) unsigned NOT NULL auto_increment,
  ToEmail varchar(255) NOT NULL default '',
  `Subject` varchar(255) NOT NULL default '',
  MessageHeaders text,
  MessageBody longtext,
  Queued int(10) unsigned NOT NULL default '0',
  SendRetries int(10) unsigned NOT NULL default '0',
  LastSendRetry int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (EmailQueueId),
  KEY LastSendRetry (LastSendRetry),
  KEY SendRetries (SendRetries)
);

ALTER TABLE Events ADD ReplacementTags TEXT AFTER Event;

# ===== v 4.2.0 =====
ALTER TABLE CustomField ADD MultiLingual TINYINT UNSIGNED NOT NULL DEFAULT '1' AFTER FieldLabel;
ALTER TABLE Category
	ADD TreeLeft BIGINT NOT NULL AFTER ParentPath,
	ADD TreeRight BIGINT NOT NULL AFTER TreeLeft;

ALTER TABLE Category ADD INDEX (TreeLeft);
ALTER TABLE Category ADD INDEX (TreeRight);

INSERT INTO ConfigurationValues VALUES (DEFAULT, 'CategoriesRebuildSerial', '0', 'In-Portal', '');

UPDATE ConfigurationAdmin SET `element_type` = 'textarea' WHERE `VariableName` IN ('Category_MetaKey', 'Category_MetaDesc');

ALTER TABLE PortalUser
	CHANGE FirstName FirstName VARCHAR(255) NOT NULL DEFAULT '',
	CHANGE LastName LastName VARCHAR(255) NOT NULL DEFAULT '';

# ===== v 4.2.1 =====
INSERT INTO ConfigurationAdmin VALUES ('UseSmallHeader', 'la_Text_Website', 'la_config_UseSmallHeader', 'checkbox', '', '', 10.21, 0, 0);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'UseSmallHeader', '0', 'In-Portal', 'in-portal:configure_general');

INSERT INTO ConfigurationAdmin VALUES ('User_Default_Registration_Country', 'la_Text_General', 'la_config_DefaultRegistrationCountry', 'select', NULL , '=+,<SQL>SELECT DestName AS OptionName, DestId AS OptionValue FROM <PREFIX>StdDestinations WHERE DestParentId IS NULL Order BY OptionName</SQL>', 10.111, 0, 0);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'User_Default_Registration_Country', '', 'In-Portal:Users', 'in-portal:configure_users');

ALTER TABLE Category ADD SymLinkCategoryId INT UNSIGNED NULL DEFAULT NULL AFTER `Type`, ADD INDEX (SymLinkCategoryId);
ALTER TABLE ConfigurationValues CHANGE VariableValue VariableValue TEXT NULL DEFAULT NULL;

ALTER TABLE Language
	ADD AdminInterfaceLang TINYINT UNSIGNED NOT NULL AFTER PrimaryLang,
	ADD Priority INT NOT NULL AFTER AdminInterfaceLang;

UPDATE Language SET AdminInterfaceLang = 1 WHERE PrimaryLang = 1;

DELETE FROM PersistantSessionData WHERE VariableName = 'lang_columns_.';
ALTER TABLE SessionData CHANGE VariableValue VariableValue longtext NOT NULL;

INSERT INTO ConfigurationAdmin VALUES ('CSVExportDelimiter', 'la_Text_CSV_Export', 'la_config_CSVExportDelimiter', 'select', NULL, '0=la_Tab,1=la_Comma,2=la_Semicolon,3=la_Space,4=la_Colon', 40.1, 0, 1);
INSERT INTO ConfigurationAdmin VALUES ('CSVExportEnclosure', 'la_Text_CSV_Export', 'la_config_CSVExportEnclosure', 'radio', NULL, '0=la_Doublequotes,1=la_Quotes', 40.2, 0, 1);
INSERT INTO ConfigurationAdmin VALUES ('CSVExportSeparator', 'la_Text_CSV_Export', 'la_config_CSVExportSeparator', 'radio', NULL, '0=la_Linux,1=la_Windows', 40.3, 0, 1);
INSERT INTO ConfigurationAdmin VALUES ('CSVExportEncoding', 'la_Text_CSV_Export', 'la_config_CSVExportEncoding', 'radio', NULL, '0=la_Unicode,1=la_Regular', 40.4, 0, 1);

INSERT INTO ConfigurationValues VALUES (DEFAULT, 'CSVExportDelimiter', '0', 'In-Portal', 'in-portal:configure_general');
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'CSVExportEnclosure', '0', 'In-Portal', 'in-portal:configure_general');
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'CSVExportSeparator', '0', 'In-Portal', 'in-portal:configure_general');
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'CSVExportEncoding', '0', 'In-Portal', 'in-portal:configure_general');

# ===== v 4.2.2 =====
INSERT INTO ConfigurationAdmin VALUES ('UseColumnFreezer', 'la_Text_Website', 'la_config_UseColumnFreezer', 'checkbox', '', '', 10.22, 0, 0);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'UseColumnFreezer', '0', 'In-Portal', 'in-portal:configure_general');

INSERT INTO ConfigurationAdmin VALUES ('TrimRequiredFields', 'la_Text_Website', 'la_config_TrimRequiredFields', 'checkbox', '', '', 10.23, 0, 0);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'TrimRequiredFields', '0', 'In-Portal', 'in-portal:configure_general');

INSERT INTO ConfigurationAdmin VALUES ('MenuFrameWidth', 'la_title_General', 'la_prompt_MenuFrameWidth', 'text', NULL, NULL, '11', '0', '0');
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'MenuFrameWidth', 200, 'In-Portal', 'in-portal:configure_general');

INSERT INTO ConfigurationAdmin VALUES ('DefaultSettingsUserId', 'la_title_General', 'la_prompt_DefaultUserId', 'text', NULL, NULL, '12', '0', '0');
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'DefaultSettingsUserId', -1, 'In-Portal', 'in-portal:configure_general');

INSERT INTO ConfigurationAdmin VALUES ('KeepSessionOnBrowserClose', 'la_title_General', 'la_prompt_KeepSessionOnBrowserClose', 'checkbox', NULL, NULL, '13', '0', '0');
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'KeepSessionOnBrowserClose', 0, 'In-Portal', 'in-portal:configure_general');

ALTER TABLE PersistantSessionData ADD VariableId BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY FIRST;

# ===== v 4.3.0 =====
INSERT INTO ConfigurationAdmin VALUES ('u_MaxImageCount', 'la_section_ImageSettings', 'la_config_MaxImageCount', 'text', '', '', 30.01, 0, 0);
INSERT INTO ConfigurationAdmin VALUES ('u_ThumbnailImageWidth', 'la_section_ImageSettings', 'la_config_ThumbnailImageWidth', 'text', '', '', 30.02, 0, 0);
INSERT INTO ConfigurationAdmin VALUES ('u_ThumbnailImageHeight', 'la_section_ImageSettings', 'la_config_ThumbnailImageHeight', 'text', '', '', 30.03, 0, 0);
INSERT INTO ConfigurationAdmin VALUES ('u_FullImageWidth', 'la_section_ImageSettings', 'la_config_FullImageWidth', 'text', '', '', 30.04, 0, 0);
INSERT INTO ConfigurationAdmin VALUES ('u_FullImageHeight', 'la_section_ImageSettings', 'la_config_FullImageHeight', 'text', '', '', 30.05, 0, 0);

INSERT INTO ConfigurationValues VALUES (DEFAULT, 'u_MaxImageCount', 5, 'In-Portal:Users', 'in-portal:configure_users');
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'u_ThumbnailImageWidth', 120, 'In-Portal:Users', 'in-portal:configure_users');
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'u_ThumbnailImageHeight', 120, 'In-Portal:Users', 'in-portal:configure_users');
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'u_FullImageWidth', 450, 'In-Portal:Users', 'in-portal:configure_users');
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'u_FullImageHeight', 450, 'In-Portal:Users', 'in-portal:configure_users');

CREATE TABLE ChangeLogs (
  ChangeLogId bigint(20) NOT NULL auto_increment,
  PortalUserId int(11) NOT NULL default '0',
  SessionLogId int(11) NOT NULL default '0',
  `Action` tinyint(4) NOT NULL default '0',
  OccuredOn int(11) NOT NULL default '0',
  Prefix varchar(255) NOT NULL default '',
  ItemId bigint(20) NOT NULL default '0',
  Changes text NOT NULL,
  MasterPrefix varchar(255) NOT NULL default '',
  MasterId bigint(20) NOT NULL default '0',
  PRIMARY KEY  (ChangeLogId),
  KEY PortalUserId (PortalUserId),
  KEY SessionLogId (SessionLogId),
  KEY `Action` (`Action`),
  KEY OccuredOn (OccuredOn),
  KEY Prefix (Prefix),
  KEY MasterPrefix (MasterPrefix)
);

CREATE TABLE SessionLogs (
  SessionLogId bigint(20) NOT NULL auto_increment,
  PortalUserId int(11) NOT NULL default '0',
  SessionId int(10) NOT NULL default '0',
  `Status` tinyint(4) NOT NULL default '1',
  SessionStart int(11) NOT NULL default '0',
  SessionEnd int(11) default NULL,
  IP varchar(15) NOT NULL default '',
  AffectedItems int(11) NOT NULL default '0',
  PRIMARY KEY  (SessionLogId),
  KEY SessionId (SessionId),
  KEY `Status` (`Status`),
  KEY PortalUserId (PortalUserId)
);

ALTER TABLE CustomField ADD INDEX (MultiLingual), ADD INDEX (DisplayOrder), ADD INDEX (OnGeneralTab), ADD INDEX (IsSystem);
ALTER TABLE ConfigurationAdmin ADD INDEX (DisplayOrder), ADD INDEX (GroupDisplayOrder), ADD INDEX (Install);
ALTER TABLE EmailSubscribers ADD INDEX (EmailMessageId), ADD INDEX (PortalUserId);
ALTER TABLE Events ADD INDEX (`Type`), ADD INDEX (Enabled);
ALTER TABLE Language ADD INDEX (Enabled), ADD INDEX (PrimaryLang), ADD INDEX (AdminInterfaceLang), ADD INDEX (Priority);
ALTER TABLE Modules ADD INDEX (Loaded), ADD INDEX (LoadOrder);
ALTER TABLE PhraseCache ADD INDEX (CacheDate), ADD INDEX (ThemeId), ADD INDEX (StylesheetId);
ALTER TABLE PortalGroup ADD INDEX (CreatedOn);
ALTER TABLE PortalUser ADD INDEX (Status), ADD INDEX (Modified), ADD INDEX (dob), ADD INDEX (IsBanned);
ALTER TABLE Theme ADD INDEX (Enabled), ADD INDEX (StylesheetId), ADD INDEX (PrimaryTheme);
ALTER TABLE UserGroup ADD INDEX (MembershipExpires), ADD INDEX (ExpirationReminderSent);
ALTER TABLE EmailLog ADD INDEX (`timestamp`);
ALTER TABLE StdDestinations ADD INDEX (DestType), ADD INDEX (DestParentId);
ALTER TABLE Category ADD INDEX (Status), ADD INDEX (CreatedOn), ADD INDEX (EditorsPick);
ALTER TABLE Stylesheets ADD INDEX (Enabled), ADD INDEX (LastCompiled);
ALTER TABLE Counters ADD INDEX (IsClone), ADD INDEX (LifeTime), ADD INDEX (LastCounted);
ALTER TABLE Skins ADD INDEX (IsPrimary), ADD INDEX (LastCompiled);

INSERT INTO ConfigurationAdmin VALUES ('UseChangeLog', 'la_Text_Website', 'la_config_UseChangeLog', 'checkbox', '', '', 10.25, 0, 0);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'UseChangeLog', '0', 'In-Portal', 'in-portal:configure_general');

INSERT INTO ConfigurationAdmin VALUES ('AutoRefreshIntervals', 'la_Text_Website', 'la_config_AutoRefreshIntervals', 'text', '', '', 10.26, 0, 0);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'AutoRefreshIntervals', '1,5,15,30,60,120,240', 'In-Portal', 'in-portal:configure_general');

DELETE FROM Cache WHERE SUBSTRING(VarName, 1, 7) = 'mod_rw_';

ALTER TABLE Category CHANGE `Status` `Status` TINYINT(4) NOT NULL DEFAULT '2';

# ===== v 4.3.1 =====
INSERT INTO ConfigurationAdmin VALUES ('RememberLastAdminTemplate', 'la_Text_General', 'la_config_RememberLastAdminTemplate', 'checkbox', '', '', 10.13, 0, 0);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'RememberLastAdminTemplate', '', 'In-Portal:Users', 'in-portal:configure_users');

INSERT INTO ConfigurationAdmin VALUES ('AllowSelectGroupOnFront', 'la_Text_General', 'la_config_AllowSelectGroupOnFront', 'checkbox', NULL, NULL, 10.13, 0, 0);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'AllowSelectGroupOnFront', '0', 'In-Portal:Users', 'in-portal:configure_users');

CREATE TABLE StatisticsCapture (
  StatisticsId int(10) unsigned NOT NULL auto_increment,
  TemplateName varchar(255) NOT NULL default '',
  Hits int(10) unsigned NOT NULL default '0',
  LastHit int(11) NOT NULL default '0',
  ScriptTimeMin decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  ScriptTimeAvg decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  ScriptTimeMax decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  SqlTimeMin decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  SqlTimeAvg decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  SqlTimeMax decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  SqlCountMin decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  SqlCountAvg decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  SqlCountMax decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  PRIMARY KEY  (StatisticsId),
  KEY TemplateName (TemplateName),
  KEY Hits (Hits),
  KEY LastHit (LastHit),
  KEY ScriptTimeMin (ScriptTimeMin),
  KEY ScriptTimeAvg (ScriptTimeAvg),
  KEY ScriptTimeMax (ScriptTimeMax),
  KEY SqlTimeMin (SqlTimeMin),
  KEY SqlTimeAvg (SqlTimeAvg),
  KEY SqlTimeMax (SqlTimeMax),
  KEY SqlCountMin (SqlCountMin),
  KEY SqlCountAvg (SqlCountAvg),
  KEY SqlCountMax (SqlCountMax)
);

CREATE TABLE SlowSqlCapture (
  CaptureId int(10) unsigned NOT NULL auto_increment,
  TemplateNames text,
  Hits int(10) unsigned NOT NULL default '0',
  LastHit int(11) NOT NULL default '0',
  SqlQuery text,
  TimeMin decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  TimeAvg decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  TimeMax decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  QueryCrc int(11) NOT NULL default '0',
  PRIMARY KEY  (CaptureId),
  KEY Hits (Hits),
  KEY LastHit (LastHit),
  KEY TimeMin (TimeMin),
  KEY TimeAvg (TimeAvg),
  KEY TimeMax (TimeMax),
  KEY QueryCrc (QueryCrc)
);

ALTER TABLE PortalGroup ADD FrontRegistration TINYINT UNSIGNED NOT NULL;
UPDATE PortalGroup SET FrontRegistration = 1 WHERE GroupId = 13;

INSERT INTO ConfigurationAdmin VALUES ('ForceImageMagickResize', 'la_Text_Website', 'la_config_ForceImageMagickResize', 'checkbox', '', '', 10.28, 0, 0);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'ForceImageMagickResize', '0', 'In-Portal', 'in-portal:configure_general');

INSERT INTO ConfigurationAdmin VALUES ('AdminSSL_URL', 'la_Text_Website', 'la_config_AdminSSL_URL', 'text', '', '', 10.091, 0, 0);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'AdminSSL_URL', '', 'In-Portal', 'in-portal:configure_general');

# ===== v 4.3.9 =====
ALTER TABLE CustomField
	CHANGE ValueList ValueList TEXT NULL DEFAULT NULL,
	ADD DefaultValue VARCHAR(255) NOT NULL AFTER ValueList,
	ADD INDEX (DefaultValue);

UPDATE CustomField SET ValueList = REPLACE(ValueList, ',', '||');

CREATE TABLE Agents (
  AgentId int(11) NOT NULL auto_increment,
  AgentName varchar(255) NOT NULL default '',
  AgentType tinyint(3) unsigned NOT NULL default '1',
  Status tinyint(3) unsigned NOT NULL default '1',
  Event varchar(255) NOT NULL default '',
  RunInterval int(10) unsigned NOT NULL default '0',
  RunMode tinyint(3) unsigned NOT NULL default '2',
  LastRunOn int(10) unsigned default NULL,
  LastRunStatus tinyint(3) unsigned NOT NULL default '1',
  NextRunOn int(11) default NULL,
  RunTime int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (AgentId),
  KEY Status (Status),
  KEY RunInterval (RunInterval),
  KEY RunMode (RunMode),
  KEY AgentType (AgentType),
  KEY LastRunOn (LastRunOn),
  KEY LastRunStatus (LastRunStatus),
  KEY RunTime (RunTime),
  KEY NextRunOn (NextRunOn)
);

INSERT INTO Permissions VALUES(DEFAULT, 'in-portal:agents.delete', 11, 1, 1, 0);
INSERT INTO Permissions VALUES(DEFAULT, 'in-portal:agents.edit', 11, 1, 1, 0);
INSERT INTO Permissions VALUES(DEFAULT, 'in-portal:agents.add', 11, 1, 1, 0);
INSERT INTO Permissions VALUES(DEFAULT, 'in-portal:agents.view', 11, 1, 1, 0);

INSERT INTO ConfigurationAdmin VALUES ('FilenameSpecialCharReplacement', 'la_Text_General', 'la_config_FilenameSpecialCharReplacement', 'select', NULL, '_=+_,-=+-', 10.16, 0, 0);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'FilenameSpecialCharReplacement', '_', 'In-Portal', 'in-portal:configure_categories');

CREATE TABLE SpellingDictionary (
  SpellingDictionaryId int(11) NOT NULL auto_increment,
  MisspelledWord varchar(255) NOT NULL default '',
  SuggestedCorrection varchar(255) NOT NULL default '',
  PRIMARY KEY  (SpellingDictionaryId),
  KEY MisspelledWord (MisspelledWord),
  KEY SuggestedCorrection (SuggestedCorrection)
);

INSERT INTO ConfigurationValues VALUES(NULL, 'YahooApplicationId', '', 'In-Portal', 'in-portal:configure_categories');
INSERT INTO ConfigurationAdmin VALUES('YahooApplicationId', 'la_Text_General', 'la_config_YahooApplicationId', 'text', NULL, NULL, 10.15, 0, 0);

CREATE TABLE Thesaurus (
  ThesaurusId int(11) NOT NULL auto_increment,
  SearchTerm varchar(255) NOT NULL default '',
  ThesaurusTerm varchar(255) NOT NULL default '',
  ThesaurusType tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (ThesaurusId),
  KEY ThesaurusType (ThesaurusType),
  KEY SearchTerm (SearchTerm)
);

INSERT INTO Permissions VALUES (DEFAULT, 'in-portal:ban_rulelist.delete', 11, 1, 1, 0);
INSERT INTO Permissions VALUES (DEFAULT, 'in-portal:ban_rulelist.edit', 11, 1, 1, 0);
INSERT INTO Permissions VALUES (DEFAULT, 'in-portal:ban_rulelist.add', 11, 1, 1, 0);

ALTER TABLE Language ADD FilenameReplacements TEXT NULL AFTER UnitSystem;
ALTER TABLE Language ADD Locale varchar(10) NOT NULL default 'en-US' AFTER FilenameReplacements;

CREATE TABLE LocalesList (
  LocaleId int(11) NOT NULL auto_increment,
  LocaleIdentifier varchar(6) NOT NULL default '',
  LocaleName varchar(255) NOT NULL default '',
  Locale varchar(20) NOT NULL default '',
  ScriptTag varchar(255) NOT NULL default '',
  ANSICodePage varchar(10) NOT NULL default '',
  PRIMARY KEY (LocaleId)
);

INSERT INTO LocalesList VALUES
(1, '0x0436', 'Afrikaans (South Africa)', 'af-ZA', 'Latn', '1252'),
(2, '0x041c', 'Albanian (Albania)', 'sq-AL', 'Latn', '1252'),
(3, '0x0484', 'Alsatian (France)', 'gsw-FR', '', ''),
(4, '0x045e', 'Amharic (Ethiopia)', 'am-ET', '', 'UTF-8'),
(5, '0x1401', 'Arabic (Algeria)', 'ar-DZ', 'Arab', '1256'),
(6, '0x3c01', 'Arabic (Bahrain)', 'ar-BH', 'Arab', '1256'),
(7, '0x0c01', 'Arabic (Egypt)', 'ar-EG', 'Arab', '1256'),
(8, '0x0801', 'Arabic (Iraq)', 'ar-IQ', 'Arab', '1256'),
(9, '0x2c01', 'Arabic (Jordan)', 'ar-JO', 'Arab', '1256'),
(10, '0x3401', 'Arabic (Kuwait)', 'ar-KW', 'Arab', '1256'),
(11, '0x3001', 'Arabic (Lebanon)', 'ar-LB', 'Arab', '1256'),
(12, '0x1001', 'Arabic (Libya)', 'ar-LY', 'Arab', '1256'),
(13, '0x1801', 'Arabic (Morocco)', 'ar-MA', 'Arab', '1256'),
(14, '0x2001', 'Arabic (Oman)', 'ar-OM', 'Arab', '1256'),
(15, '0x4001', 'Arabic (Qatar)', 'ar-QA', 'Arab', '1256'),
(16, '0x0401', 'Arabic (Saudi Arabia)', 'ar-SA', 'Arab', '1256'),
(17, '0x2801', 'Arabic (Syria)', 'ar-SY', 'Arab', '1256'),
(18, '0x1c01', 'Arabic (Tunisia)', 'ar-TN', 'Arab', '1256'),
(19, '0x3801', 'Arabic (U.A.E.)', 'ar-AE', 'Arab', '1256'),
(20, '0x2401', 'Arabic (Yemen)', 'ar-YE', 'Arab', '1256'),
(21, '0x042b', 'Armenian (Armenia)', 'hy-AM', 'Armn', 'UTF-8'),
(22, '0x044d', 'Assamese (India)', 'as-IN', '', 'UTF-8'),
(23, '0x082c', 'Azeri (Azerbaijan, Cyrillic)', 'az-Cyrl-AZ', 'Cyrl', '1251'),
(24, '0x042c', 'Azeri (Azerbaijan, Latin)', 'az-Latn-AZ', 'Latn', '1254'),
(25, '0x046d', 'Bashkir (Russia)', 'ba-RU', '', ''),
(26, '0x042d', 'Basque (Basque)', 'eu-ES', 'Latn', '1252'),
(27, '0x0423', 'Belarusian (Belarus)', 'be-BY', 'Cyrl', '1251'),
(28, '0x0445', 'Bengali (India)', 'bn-IN', 'Beng', 'UTF-8'),
(29, '0x201a', 'Bosnian (Bosnia and Herzegovina, Cyrillic)', 'bs-Cyrl-BA', 'Cyrl', '1251'),
(30, '0x141a', 'Bosnian (Bosnia and Herzegovina, Latin)', 'bs-Latn-BA', 'Latn', '1250'),
(31, '0x047e', 'Breton (France)', 'br-FR', 'Latn', '1252'),
(32, '0x0402', 'Bulgarian (Bulgaria)', 'bg-BG', 'Cyrl', '1251'),
(33, '0x0403', 'Catalan (Catalan)', 'ca-ES', 'Latn', '1252'),
(34, '0x0c04', 'Chinese (Hong Kong SAR, PRC)', 'zh-HK', 'Hant', '950'),
(35, '0x1404', 'Chinese (Macao SAR)', 'zh-MO', 'Hant', '950'),
(36, '0x0804', 'Chinese (PRC)', 'zh-CN', 'Hans', '936'),
(37, '0x1004', 'Chinese (Singapore)', 'zh-SG', 'Hans', '936'),
(38, '0x0404', 'Chinese (Taiwan)', 'zh-TW', 'Hant', '950'),
(39, '0x101a', 'Croatian (Bosnia and Herzegovina, Latin)', 'hr-BA', 'Latn', '1250'),
(40, '0x041a', 'Croatian (Croatia)', 'hr-HR', 'Latn', '1250'),
(41, '0x0405', 'Czech (Czech Republic)', 'cs-CZ', 'Latn', '1250'),
(42, '0x0406', 'Danish (Denmark)', 'da-DK', 'Latn', '1252'),
(43, '0x048c', 'Dari (Afghanistan)', 'prs-AF', 'Arab', '1256'),
(44, '0x0465', 'Divehi (Maldives)', 'dv-MV', 'Thaa', 'UTF-8'),
(45, '0x0813', 'Dutch (Belgium)', 'nl-BE', 'Latn', '1252'),
(46, '0x0413', 'Dutch (Netherlands)', 'nl-NL', 'Latn', '1252'),
(47, '0x0c09', 'English (Australia)', 'en-AU', 'Latn', '1252'),
(48, '0x2809', 'English (Belize)', 'en-BZ', 'Latn', '1252'),
(49, '0x1009', 'English (Canada)', 'en-CA', 'Latn', '1252'),
(50, '0x2409', 'English (Caribbean)', 'en-029', 'Latn', '1252'),
(51, '0x4009', 'English (India)', 'en-IN', 'Latn', '1252'),
(52, '0x1809', 'English (Ireland)', 'en-IE', 'Latn', '1252'),
(53, '0x2009', 'English (Jamaica)', 'en-JM', 'Latn', '1252'),
(54, '0x4409', 'English (Malaysia)', 'en-MY', 'Latn', '1252'),
(55, '0x1409', 'English (New Zealand)', 'en-NZ', 'Latn', '1252'),
(56, '0x3409', 'English (Philippines)', 'en-PH', 'Latn', '1252'),
(57, '0x4809', 'English (Singapore)', 'en-SG', 'Latn', '1252'),
(58, '0x1c09', 'English (South Africa)', 'en-ZA', 'Latn', '1252'),
(59, '0x2c09', 'English (Trinidad and Tobago)', 'en-TT', 'Latn', '1252'),
(60, '0x0809', 'English (United Kingdom)', 'en-GB', 'Latn', '1252'),
(61, '0x0409', 'English (United States)', 'en-US', 'Latn', '1252'),
(62, '0x3009', 'English (Zimbabwe)', 'en-ZW', 'Latn', '1252'),
(63, '0x0425', 'Estonian (Estonia)', 'et-EE', 'Latn', '1257'),
(64, '0x0438', 'Faroese (Faroe Islands)', 'fo-FO', 'Latn', '1252'),
(65, '0x0464', 'Filipino (Philippines)', 'fil-PH', 'Latn', '1252'),
(66, '0x040b', 'Finnish (Finland)', 'fi-FI', 'Latn', '1252'),
(67, '0x080c', 'French (Belgium)', 'fr-BE', 'Latn', '1252'),
(68, '0x0c0c', 'French (Canada)', 'fr-CA', 'Latn', '1252'),
(69, '0x040c', 'French (France)', 'fr-FR', 'Latn', '1252'),
(70, '0x140c', 'French (Luxembourg)', 'fr-LU', 'Latn', '1252'),
(71, '0x180c', 'French (Monaco)', 'fr-MC', 'Latn', '1252'),
(72, '0x100c', 'French (Switzerland)', 'fr-CH', 'Latn', '1252'),
(73, '0x0462', 'Frisian (Netherlands)', 'fy-NL', 'Latn', '1252'),
(74, '0x0456', 'Galician (Spain)', 'gl-ES', 'Latn', '1252'),
(75, '0x0437', 'Georgian (Georgia)', 'ka-GE', 'Geor', 'UTF-8'),
(76, '0x0c07', 'German (Austria)', 'de-AT', 'Latn', '1252'),
(77, '0x0407', 'German (Germany)', 'de-DE', 'Latn', '1252'),
(78, '0x1407', 'German (Liechtenstein)', 'de-LI', 'Latn', '1252'),
(79, '0x1007', 'German (Luxembourg)', 'de-LU', 'Latn', '1252'),
(80, '0x0807', 'German (Switzerland)', 'de-CH', 'Latn', '1252'),
(81, '0x0408', 'Greek (Greece)', 'el-GR', 'Grek', '1253'),
(82, '0x046f', 'Greenlandic (Greenland)', 'kl-GL', 'Latn', '1252'),
(83, '0x0447', 'Gujarati (India)', 'gu-IN', 'Gujr', 'UTF-8'),
(84, '0x0468', 'Hausa (Nigeria, Latin)', 'ha-Latn-NG', 'Latn', '1252'),
(85, '0x040d', 'Hebrew (Israel)', 'he-IL', 'Hebr', '1255'),
(86, '0x0439', 'Hindi (India)', 'hi-IN', 'Deva', 'UTF-8'),
(87, '0x040e', 'Hungarian (Hungary)', 'hu-HU', 'Latn', '1250'),
(88, '0x040f', 'Icelandic (Iceland)', 'is-IS', 'Latn', '1252'),
(89, '0x0470', 'Igbo (Nigeria)', 'ig-NG', '', ''),
(90, '0x0421', 'Indonesian (Indonesia)', 'id-ID', 'Latn', '1252'),
(91, '0x085d', 'Inuktitut (Canada, Latin)', 'iu-Latn-CA', 'Latn', '1252'),
(92, '0x045d', 'Inuktitut (Canada, Syllabics)', 'iu-Cans-CA', 'Cans', 'UTF-8'),
(93, '0x083c', 'Irish (Ireland)', 'ga-IE', 'Latn', '1252'),
(94, '0x0410', 'Italian (Italy)', 'it-IT', 'Latn', '1252'),
(95, '0x0810', 'Italian (Switzerland)', 'it-CH', 'Latn', '1252'),
(96, '0x0411', 'Japanese (Japan)', 'ja-JP', 'Hani;Hira;Kana', '932'),
(97, '0x044b', 'Kannada (India)', 'kn-IN', 'Knda', 'UTF-8'),
(98, '0x043f', 'Kazakh (Kazakhstan)', 'kk-KZ', 'Cyrl', '1251'),
(99, '0x0453', 'Khmer (Cambodia)', 'kh-KH', 'Khmr', 'UTF-8'),
(100, '0x0486', 'K''iche (Guatemala)', 'qut-GT', 'Latn', '1252'),
(101, '0x0487', 'Kinyarwanda (Rwanda)', 'rw-RW', 'Latn', '1252'),
(102, '0x0457', 'Konkani (India)', 'kok-IN', 'Deva', 'UTF-8'),
(103, '0x0812', 'Windows 95, Windows NT 4.0 only: Korean (Johab)', '', '', ''),
(104, '0x0412', 'Korean (Korea)', 'ko-KR', 'Hang;Hani', '949'),
(105, '0x0440', 'Kyrgyz (Kyrgyzstan)', 'ky-KG', 'Cyrl', '1251'),
(106, '0x0454', 'Lao (Lao PDR)', 'lo-LA', 'Laoo', 'UTF-8'),
(107, '0x0426', 'Latvian (Latvia)', 'lv-LV', 'Latn', '1257'),
(108, '0x0427', 'Lithuanian (Lithuania)', 'lt-LT', 'Latn', '1257'),
(109, '0x082e', 'Lower Sorbian (Germany)', 'dsb-DE', 'Latn', '1252'),
(110, '0x046e', 'Luxembourgish (Luxembourg)', 'lb-LU', 'Latn', '1252'),
(111, '0x042f', 'Macedonian (Macedonia, FYROM)', 'mk-MK', 'Cyrl', '1251'),
(112, '0x083e', 'Malay (Brunei Darussalam)', 'ms-BN', 'Latn', '1252'),
(113, '0x043e', 'Malay (Malaysia)', 'ms-MY', 'Latn', '1252'),
(114, '0x044c', 'Malayalam (India)', 'ml-IN', 'Mlym', 'UTF-8'),
(115, '0x043a', 'Maltese (Malta)', 'mt-MT', 'Latn', '1252'),
(116, '0x0481', 'Maori (New Zealand)', 'mi-NZ', 'Latn', '1252'),
(117, '0x047a', 'Mapudungun (Chile)', 'arn-CL', 'Latn', '1252'),
(118, '0x044e', 'Marathi (India)', 'mr-IN', 'Deva', 'UTF-8'),
(119, '0x047c', 'Mohawk (Canada)', 'moh-CA', 'Latn', '1252'),
(120, '0x0450', 'Mongolian (Mongolia)', 'mn-Cyrl-MN', 'Cyrl', '1251'),
(121, '0x0850', 'Mongolian (PRC)', 'mn-Mong-CN', 'Mong', 'UTF-8'),
(122, '0x0850', 'Nepali (India)', 'ne-IN', '__', 'UTF-8'),
(123, '0x0461', 'Nepali (Nepal)', 'ne-NP', 'Deva', 'UTF-8'),
(124, '0x0414', 'Norwegian (Bokmål, Norway)', 'nb-NO', 'Latn', '1252'),
(125, '0x0814', 'Norwegian (Nynorsk, Norway)', 'nn-NO', 'Latn', '1252'),
(126, '0x0482', 'Occitan (France)', 'oc-FR', 'Latn', '1252'),
(127, '0x0448', 'Oriya (India)', 'or-IN', 'Orya', 'UTF-8'),
(128, '0x0463', 'Pashto (Afghanistan)', 'ps-AF', '', ''),
(129, '0x0429', 'Persian (Iran)', 'fa-IR', 'Arab', '1256'),
(130, '0x0415', 'Polish (Poland)', 'pl-PL', 'Latn', '1250'),
(131, '0x0416', 'Portuguese (Brazil)', 'pt-BR', 'Latn', '1252'),
(132, '0x0816', 'Portuguese (Portugal)', 'pt-PT', 'Latn', '1252'),
(133, '0x0446', 'Punjabi (India)', 'pa-IN', 'Guru', 'UTF-8'),
(134, '0x046b', 'Quechua (Bolivia)', 'quz-BO', 'Latn', '1252'),
(135, '0x086b', 'Quechua (Ecuador)', 'quz-EC', 'Latn', '1252'),
(136, '0x0c6b', 'Quechua (Peru)', 'quz-PE', 'Latn', '1252'),
(137, '0x0418', 'Romanian (Romania)', 'ro-RO', 'Latn', '1250'),
(138, '0x0417', 'Romansh (Switzerland)', 'rm-CH', 'Latn', '1252'),
(139, '0x0419', 'Russian (Russia)', 'ru-RU', 'Cyrl', '1251'),
(140, '0x243b', 'Sami (Inari, Finland)', 'smn-FI', 'Latn', '1252'),
(141, '0x103b', 'Sami (Lule, Norway)', 'smj-NO', 'Latn', '1252'),
(142, '0x143b', 'Sami (Lule, Sweden)', 'smj-SE', 'Latn', '1252'),
(143, '0x0c3b', 'Sami (Northern, Finland)', 'se-FI', 'Latn', '1252'),
(144, '0x043b', 'Sami (Northern, Norway)', 'se-NO', 'Latn', '1252'),
(145, '0x083b', 'Sami (Northern, Sweden)', 'se-SE', 'Latn', '1252'),
(146, '0x203b', 'Sami (Skolt, Finland)', 'sms-FI', 'Latn', '1252'),
(147, '0x183b', 'Sami (Southern, Norway)', 'sma-NO', 'Latn', '1252'),
(148, '0x1c3b', 'Sami (Southern, Sweden)', 'sma-SE', 'Latn', '1252'),
(149, '0x044f', 'Sanskrit (India)', 'sa-IN', 'Deva', 'UTF-8'),
(150, '0x1c1a', 'Serbian (Bosnia and Herzegovina, Cyrillic)', 'sr-Cyrl-BA', 'Cyrl', '1251'),
(151, '0x181a', 'Serbian (Bosnia and Herzegovina, Latin)', 'sr-Latn-BA', 'Latn', '1250'),
(152, '0x0c1a', 'Serbian (Serbia, Cyrillic)', 'sr-Cyrl-CS', 'Cyrl', '1251'),
(153, '0x081a', 'Serbian (Serbia, Latin)', 'sr-Latn-CS', 'Latn', '1250'),
(154, '0x046c', 'Sesotho sa Leboa/Northern Sotho (South Africa)', 'ns-ZA', 'Latn', '1252'),
(155, '0x0432', 'Setswana/Tswana (South Africa)', 'tn-ZA', 'Latn', '1252'),
(156, '0x045b', 'Sinhala (Sri Lanka)', 'si-LK', 'Sinh', 'UTF-8'),
(157, '0x041b', 'Slovak (Slovakia)', 'sk-SK', 'Latn', '1250'),
(158, '0x0424', 'Slovenian (Slovenia)', 'sl-SI', 'Latn', '1250'),
(159, '0x2c0a', 'Spanish (Argentina)', 'es-AR', 'Latn', '1252'),
(160, '0x400a', 'Spanish (Bolivia)', 'es-BO', 'Latn', '1252'),
(161, '0x340a', 'Spanish (Chile)', 'es-CL', 'Latn', '1252'),
(162, '0x240a', 'Spanish (Colombia)', 'es-CO', 'Latn', '1252'),
(163, '0x140a', 'Spanish (Costa Rica)', 'es-CR', 'Latn', '1252'),
(164, '0x1c0a', 'Spanish (Dominican Republic)', 'es-DO', 'Latn', '1252'),
(165, '0x300a', 'Spanish (Ecuador)', 'es-EC', 'Latn', '1252'),
(166, '0x440a', 'Spanish (El Salvador)', 'es-SV', 'Latn', '1252'),
(167, '0x100a', 'Spanish (Guatemala)', 'es-GT', 'Latn', '1252'),
(168, '0x480a', 'Spanish (Honduras)', 'es-HN', 'Latn', '1252'),
(169, '0x080a', 'Spanish (Mexico)', 'es-MX', 'Latn', '1252'),
(170, '0x4c0a', 'Spanish (Nicaragua)', 'es-NI', 'Latn', '1252'),
(171, '0x180a', 'Spanish (Panama)', 'es-PA', 'Latn', '1252'),
(172, '0x3c0a', 'Spanish (Paraguay)', 'es-PY', 'Latn', '1252'),
(173, '0x280a', 'Spanish (Peru)', 'es-PE', 'Latn', '1252'),
(174, '0x500a', 'Spanish (Puerto Rico)', 'es-PR', 'Latn', '1252'),
(175, '0x0c0a', 'Spanish (Spain)', 'es-ES', 'Latn', '1252'),
(176, '0x040a', 'Spanish (Spain, Traditional Sort)', 'es-ES_tradnl', 'Latn', '1252'),
(177, '0x540a', 'Spanish (United States)', 'es-US', '', ''),
(178, '0x380a', 'Spanish (Uruguay)', 'es-UY', 'Latn', '1252'),
(179, '0x200a', 'Spanish (Venezuela)', 'es-VE', 'Latn', '1252'),
(180, '0x0441', 'Swahili (Kenya)', 'sw-KE', 'Latn', '1252'),
(181, '0x081d', 'Swedish (Finland)', 'sv-FI', 'Latn', '1252'),
(182, '0x041d', 'Swedish (Sweden)', 'sv-SE', 'Latn', '1252'),
(183, '0x045a', 'Syriac (Syria)', 'syr-SY', 'Syrc', 'UTF-8'),
(184, '0x0428', 'Tajik (Tajikistan)', 'tg-Cyrl-TJ', 'Cyrl', '1251'),
(185, '0x085f', 'Tamazight (Algeria, Latin)', 'tzm-Latn-DZ', 'Latn', '1252'),
(186, '0x0449', 'Tamil (India)', 'ta-IN', 'Taml', 'UTF-8'),
(187, '0x0444', 'Tatar (Russia)', 'tt-RU', 'Cyrl', '1251'),
(188, '0x044a', 'Telugu (India)', 'te-IN', 'Telu', 'UTF-8'),
(189, '0x041e', 'Thai (Thailand)', 'th-TH', 'Thai', '874'),
(190, '0x0851', 'Tibetan (Bhutan)', 'bo-BT', 'Tibt', 'UTF-8'),
(191, '0x0451', 'Tibetan (PRC)', 'bo-CN', 'Tibt', 'UTF-8'),
(192, '0x041f', 'Turkish (Turkey)', 'tr-TR', 'Latn', '1254'),
(193, '0x0442', 'Turkmen (Turkmenistan)', 'tk-TM', 'Cyrl', '1251'),
(194, '0x0480', 'Uighur (PRC)', 'ug-CN', 'Arab', '1256'),
(195, '0x0422', 'Ukrainian (Ukraine)', 'uk-UA', 'Cyrl', '1251'),
(196, '0x042e', 'Upper Sorbian (Germany)', 'wen-DE', 'Latn', '1252'),
(197, '0x0820', 'Urdu (India)', 'tr-IN', '', ''),
(198, '0x0420', 'Urdu (Pakistan)', 'ur-PK', 'Arab', '1256'),
(199, '0x0843', 'Uzbek (Uzbekistan, Cyrillic)', 'uz-Cyrl-UZ', 'Cyrl', '1251'),
(200, '0x0443', 'Uzbek (Uzbekistan, Latin)', 'uz-Latn-UZ', 'Latn', '1254'),
(201, '0x042a', 'Vietnamese (Vietnam)', 'vi-VN', 'Latn', '1258'),
(202, '0x0452', 'Welsh (United Kingdom)', 'cy-GB', 'Latn', '1252'),
(203, '0x0488', 'Wolof (Senegal)', 'wo-SN', 'Latn', '1252'),
(204, '0x0434', 'Xhosa/isiXhosa (South Africa)', 'xh-ZA', 'Latn', '1252'),
(205, '0x0485', 'Yakut (Russia)', 'sah-RU', 'Cyrl', '1251'),
(206, '0x0478', 'Yi (PRC)', 'ii-CN', 'Yiii', 'UTF-8'),
(207, '0x046a', 'Yoruba (Nigeria)', 'yo-NG', '', ''),
(208, '0x0435', 'Zulu/isiZulu (South Africa)', 'zu-ZA', 'Latn', '1252');

UPDATE Phrase SET Module = 'Core' WHERE Module IN ('Proj-Base', 'In-Portal');
UPDATE Phrase SET Module = 'Core' WHERE Phrase IN ('la_fld_Phone', 'la_fld_City', 'la_fld_State', 'la_fld_Zip');
UPDATE Phrase SET Module = 'Core' WHERE Phrase IN ('la_col_Image', 'la_col_Username', 'la_fld_AddressLine1', 'la_fld_AddressLine2', 'la_fld_Comments', 'la_fld_Country', 'la_fld_Email', 'la_fld_Language', 'la_fld_Login', 'la_fld_MessageText', 'la_fld_MetaDescription', 'la_fld_MetaKeywords', 'la_fld_Password', 'la_fld_Username', 'la_fld_Type');

UPDATE Phrase SET Phrase = 'la_Add' WHERE Phrase = 'LA_ADD';
UPDATE Phrase SET Phrase = 'la_col_MembershipExpires' WHERE Phrase = 'la_col_membershipexpires';
UPDATE Phrase SET Phrase = 'la_ShortToolTip_Clone' WHERE Phrase = 'la_shorttooltip_clone';
UPDATE Phrase SET Phrase = 'la_ShortToolTip_Edit' WHERE Phrase = 'LA_SHORTTOOLTIP_EDIT';
UPDATE Phrase SET Phrase = 'la_ShortToolTip_Export' WHERE Phrase = 'LA_SHORTTOOLTIP_EXPORT';
UPDATE Phrase SET Phrase = 'la_ShortToolTip_GoUp' WHERE Phrase = 'LA_SHORTTOOLTIP_GOUP';
UPDATE Phrase SET Phrase = 'la_ShortToolTip_Import' WHERE Phrase = 'LA_SHORTTOOLTIP_IMPORT';
UPDATE Phrase SET Phrase = 'la_ShortToolTip_MoveUp' WHERE Phrase = 'la_shorttooltip_moveup';
UPDATE Phrase SET Phrase = 'la_ShortToolTip_MoveDown' WHERE Phrase = 'la_shorttooltip_movedown';
UPDATE Phrase SET Phrase = 'la_ShortToolTip_RescanThemes' WHERE Phrase = 'la_shorttooltip_rescanthemes';
UPDATE Phrase SET Phrase = 'la_ShortToolTip_SetPrimary' WHERE Phrase = 'LA_SHORTTOOLTIP_SETPRIMARY';
UPDATE Phrase SET Phrase = 'la_ShortToolTip_Rebuild' WHERE Phrase = 'LA_SHORTTOOLTIP_REBUILD';
UPDATE Phrase SET Phrase = 'la_Tab_Service' WHERE Phrase = 'la_tab_service';
UPDATE Phrase SET Phrase = 'la_tab_Files' WHERE Phrase = 'la_tab_files';
UPDATE Phrase SET Phrase = 'la_ToolTipShort_Edit_Current_Category' WHERE Phrase = 'LA_TOOLTIPSHORT_EDIT_CURRENT_CATEGORY';
UPDATE Phrase SET Phrase = 'la_ToolTip_Add' WHERE Phrase = 'LA_TOOLTIP_ADD';
UPDATE Phrase SET Phrase = 'la_ToolTip_Add_Product' WHERE Phrase = 'LA_TOOLTIP_ADD_PRODUCT';
UPDATE Phrase SET Phrase = 'la_ToolTip_NewSearchConfig' WHERE Phrase = 'LA_TOOLTIP_NEWSEARCHCONFIG';
UPDATE Phrase SET Phrase = 'la_ToolTip_Prev' WHERE Phrase = 'la_tooltip_prev';
UPDATE Phrase SET Phrase = 'la_Invalid_Password' WHERE Phrase = 'la_invalid_password';

UPDATE Events SET Module = REPLACE(Module, 'In-Portal', 'Core');

DROP TABLE ImportScripts;

CREATE TABLE BanRules (
  RuleId int(11) NOT NULL auto_increment,
  RuleType tinyint(4) NOT NULL default '0',
  ItemField varchar(255) default NULL,
  ItemVerb tinyint(4) NOT NULL default '0',
  ItemValue varchar(255) NOT NULL default '',
  ItemType int(11) NOT NULL default '0',
  Priority int(11) NOT NULL default '0',
  Status tinyint(4) NOT NULL default '1',
  ErrorTag varchar(255) default NULL,
  PRIMARY KEY  (RuleId),
  KEY Status (Status),
  KEY Priority (Priority),
  KEY ItemType (ItemType)
);

CREATE TABLE CountCache (
  ListType int(11) NOT NULL default '0',
  ItemType int(11) NOT NULL default '-1',
  Value int(11) NOT NULL default '0',
  CountCacheId int(11) NOT NULL auto_increment,
  LastUpdate int(11) NOT NULL default '0',
  ExtraId varchar(50) default NULL,
  TodayOnly tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (CountCacheId)
);

CREATE TABLE Favorites (
  FavoriteId int(11) NOT NULL auto_increment,
  PortalUserId int(11) NOT NULL default '0',
  ResourceId int(11) NOT NULL default '0',
  ItemTypeId int(11) NOT NULL default '0',
  Modified int(11) NOT NULL default '0',
  PRIMARY KEY  (FavoriteId),
  UNIQUE KEY main (PortalUserId,ResourceId),
  KEY Modified (Modified),
  KEY ItemTypeId (ItemTypeId)
);

CREATE TABLE Images (
  ImageId int(11) NOT NULL auto_increment,
  ResourceId int(11) NOT NULL default '0',
  Url varchar(255) NOT NULL default '',
  Name varchar(255) NOT NULL default '',
  AltName VARCHAR(255) NOT NULL DEFAULT '',
  ImageIndex int(11) NOT NULL default '0',
  LocalImage tinyint(4) NOT NULL default '1',
  LocalPath varchar(240) NOT NULL default '',
  Enabled int(11) NOT NULL default '1',
  DefaultImg int(11) NOT NULL default '0',
  ThumbUrl varchar(255) default NULL,
  Priority int(11) NOT NULL default '0',
  ThumbPath varchar(255) default NULL,
  LocalThumb tinyint(4) NOT NULL default '1',
  SameImages tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (ImageId),
  KEY ResourceId (ResourceId),
  KEY Enabled (Enabled),
  KEY Priority (Priority)
);

CREATE TABLE ItemRating (
  RatingId int(11) NOT NULL auto_increment,
  IPAddress varchar(255) NOT NULL default '',
  CreatedOn INT UNSIGNED NULL DEFAULT NULL,
  RatingValue int(11) NOT NULL default '0',
  ItemId int(11) NOT NULL default '0',
  PRIMARY KEY  (RatingId),
  KEY CreatedOn (CreatedOn),
  KEY ItemId (ItemId),
  KEY RatingValue (RatingValue)
);

CREATE TABLE ItemReview (
  ReviewId int(11) NOT NULL auto_increment,
  CreatedOn INT UNSIGNED NULL DEFAULT NULL,
  ReviewText longtext NOT NULL,
  Rating tinyint(3) unsigned default NULL,
  IPAddress varchar(255) NOT NULL default '',
  ItemId int(11) NOT NULL default '0',
  CreatedById int(11) NOT NULL default '-1',
  ItemType tinyint(4) NOT NULL default '0',
  Priority int(11) NOT NULL default '0',
  Status tinyint(4) NOT NULL default '2',
  TextFormat int(11) NOT NULL default '0',
  Module varchar(255) NOT NULL default '',
  PRIMARY KEY  (ReviewId),
  KEY CreatedOn (CreatedOn),
  KEY ItemId (ItemId),
  KEY ItemType (ItemType),
  KEY Priority (Priority),
  KEY Status (Status)
);

CREATE TABLE ItemTypes (
  ItemType int(11) NOT NULL default '0',
  Module varchar(50) NOT NULL default '',
  Prefix varchar(20) NOT NULL default '',
  SourceTable varchar(100) NOT NULL default '',
  TitleField varchar(50) default NULL,
  CreatorField varchar(255) NOT NULL default '',
  PopField varchar(255) default NULL,
  RateField varchar(255) default NULL,
  LangVar varchar(255) NOT NULL default '',
  PrimaryItem int(11) NOT NULL default '0',
  EditUrl varchar(255) NOT NULL default '',
  ClassName varchar(40) NOT NULL default '',
  ItemName varchar(50) NOT NULL default '',
  PRIMARY KEY  (ItemType),
  KEY Module (Module)
);

CREATE TABLE ItemFiles (
  FileId int(11) NOT NULL auto_increment,
  ResourceId int(11) unsigned NOT NULL default '0',
  FileName varchar(255) NOT NULL default '',
  FilePath varchar(255) NOT NULL default '',
  Size int(11) NOT NULL default '0',
  `Status` tinyint(4) NOT NULL default '1',
  CreatedOn int(11) unsigned NOT NULL default '0',
  CreatedById int(11) NOT NULL default '-1',
  MimeType varchar(255) NOT NULL default '',
  PRIMARY KEY  (FileId),
  KEY ResourceId (ResourceId),
  KEY CreatedOn (CreatedOn),
  KEY Status (Status)
);

CREATE TABLE Relationship (
  RelationshipId int(11) NOT NULL auto_increment,
  SourceId int(11) default NULL,
  TargetId int(11) default NULL,
  SourceType tinyint(4) NOT NULL default '0',
  TargetType tinyint(4) NOT NULL default '0',
  Type int(11) NOT NULL default '0',
  Enabled int(11) NOT NULL default '1',
  Priority int(11) NOT NULL default '0',
  PRIMARY KEY  (RelationshipId),
  KEY RelSource (SourceId),
  KEY RelTarget (TargetId),
  KEY `Type` (`Type`),
  KEY Enabled (Enabled),
  KEY Priority (Priority),
  KEY SourceType (SourceType),
  KEY TargetType (TargetType)
);

CREATE TABLE SearchConfig (
  TableName varchar(40) NOT NULL default '',
  FieldName varchar(40) NOT NULL default '',
  SimpleSearch tinyint(4) NOT NULL default '1',
  AdvancedSearch tinyint(4) NOT NULL default '1',
  Description varchar(255) default NULL,
  DisplayName varchar(80) default NULL,
  ModuleName VARCHAR(20) NOT NULL DEFAULT 'In-Portal',
  ConfigHeader varchar(255) default NULL,
  DisplayOrder int(11) NOT NULL default '0',
  SearchConfigId int(11) NOT NULL auto_increment,
  Priority int(11) NOT NULL default '0',
  FieldType varchar(20) NOT NULL default 'text',
  ForeignField TEXT,
  JoinClause TEXT,
  IsWhere text,
  IsNotWhere text,
  ContainsWhere text,
  NotContainsWhere text,
  CustomFieldId int(11) default NULL,
  PRIMARY KEY  (SearchConfigId),
  KEY SimpleSearch (SimpleSearch),
  KEY AdvancedSearch (AdvancedSearch),
  KEY DisplayOrder (DisplayOrder),
  KEY Priority (Priority),
  KEY CustomFieldId (CustomFieldId)
);

CREATE TABLE SearchLog (
  SearchLogId int(11) NOT NULL auto_increment,
  Keyword varchar(255) NOT NULL default '',
  Indices bigint(20) NOT NULL default '0',
  SearchType int(11) NOT NULL default '0',
  PRIMARY KEY  (SearchLogId),
  KEY SearchType (SearchType)
);

CREATE TABLE IgnoreKeywords (
  keyword varchar(20) NOT NULL default '',
  PRIMARY KEY  (keyword)
);

CREATE TABLE SpamControl (
  ItemResourceId int(11) NOT NULL default '0',
  IPaddress varchar(20) NOT NULL default '',
  Expire INT UNSIGNED NULL DEFAULT NULL,
  PortalUserId int(11) NOT NULL default '0',
  DataType varchar(20) default NULL,
  KEY PortalUserId (PortalUserId),
  KEY Expire (Expire),
  KEY ItemResourceId (ItemResourceId)
);

CREATE TABLE StatItem (
  StatItemId int(11) NOT NULL auto_increment,
  Module varchar(20) NOT NULL default '',
  ValueSQL varchar(255) default NULL,
  ResetSQL varchar(255) default NULL,
  ListLabel varchar(255) NOT NULL default '',
  Priority int(11) NOT NULL default '0',
  AdminSummary int(11) NOT NULL default '0',
  PRIMARY KEY  (StatItemId),
  KEY AdminSummary (AdminSummary),
  KEY Priority (Priority)
);

CREATE TABLE SuggestMail (
  email varchar(255) NOT NULL default '',
  sent INT UNSIGNED NULL DEFAULT NULL,
  PRIMARY KEY  (email),
  KEY sent (sent)
);

CREATE TABLE SysCache (
  SysCacheId int(11) NOT NULL auto_increment,
  Name varchar(255) NOT NULL default '',
  Value mediumtext,
  Expire INT UNSIGNED NULL DEFAULT NULL,
  Module varchar(20) default NULL,
  Context varchar(255) default NULL,
  GroupList varchar(255) NOT NULL default '',
  PRIMARY KEY  (SysCacheId),
  KEY Name (Name)
);

CREATE TABLE TagLibrary (
  TagId int(11) NOT NULL auto_increment,
  name varchar(255) NOT NULL default '',
  description text,
  example text,
  scope varchar(20) NOT NULL default 'global',
  PRIMARY KEY  (TagId)
);

CREATE TABLE TagAttributes (
  AttrId int(11) NOT NULL auto_increment,
  TagId int(11) NOT NULL default '0',
  Name varchar(255) NOT NULL default '',
  AttrType varchar(20) default NULL,
  DefValue varchar(255) default NULL,
  Description TEXT,
  Required int(11) NOT NULL default '0',
  PRIMARY KEY  (AttrId),
  KEY TagId (TagId)
);

CREATE TABLE ImportScripts (
  ImportId INT(11) NOT NULL auto_increment,
  Name VARCHAR(255) NOT NULL DEFAULT '',
  Description TEXT NOT NULL,
  Prefix VARCHAR(10) NOT NULL DEFAULT '',
  Module VARCHAR(50) NOT NULL DEFAULT '',
  ExtraFields VARCHAR(255) NOT NULL DEFAULT '',
  Type VARCHAR(10) NOT NULL DEFAULT '',
  Status TINYINT NOT NULL,
  PRIMARY KEY (ImportId),
  KEY Module (Module),
  KEY Status (Status)
);

CREATE TABLE StylesheetSelectors (
  SelectorId int(11) NOT NULL auto_increment,
  StylesheetId int(11) NOT NULL default '0',
  Name varchar(255) NOT NULL default '',
  SelectorName varchar(255) NOT NULL default '',
  SelectorData text NOT NULL,
  Description text NOT NULL,
  Type tinyint(4) NOT NULL default '0',
  AdvancedCSS text NOT NULL,
  ParentId int(11) NOT NULL default '0',
  PRIMARY KEY  (SelectorId),
  KEY StylesheetId (StylesheetId),
  KEY ParentId (ParentId),
  KEY `Type` (`Type`)
);

CREATE TABLE Visits (
  VisitId int(11) NOT NULL auto_increment,
  VisitDate int(10) unsigned NOT NULL default '0',
  Referer varchar(255) NOT NULL default '',
  IPAddress varchar(15) NOT NULL default '',
  AffiliateId int(10) unsigned NOT NULL default '0',
  PortalUserId int(11) NOT NULL default '-2',
  PRIMARY KEY  (VisitId),
  KEY PortalUserId (PortalUserId),
  KEY AffiliateId (AffiliateId),
  KEY VisitDate (VisitDate)
);

CREATE TABLE ImportCache (
  CacheId int(11) NOT NULL auto_increment,
  CacheName varchar(255) NOT NULL default '',
  VarName int(11) NOT NULL default '0',
  VarValue text NOT NULL,
  PRIMARY KEY  (CacheId),
  KEY CacheName (CacheName),
  KEY VarName (VarName)
);

CREATE TABLE RelatedSearches (
  RelatedSearchId int(11) NOT NULL auto_increment,
  ResourceId int(11) NOT NULL default '0',
  Keyword varchar(255) NOT NULL default '',
  ItemType tinyint(4) NOT NULL default '0',
  Enabled tinyint(4) NOT NULL default '1',
  Priority int(11) NOT NULL default '0',
  PRIMARY KEY  (RelatedSearchId),
  KEY Enabled (Enabled),
  KEY ItemType (ItemType),
  KEY ResourceId (ResourceId)
);

UPDATE Modules SET Path = 'core/', Version='4.3.9' WHERE Name = 'In-Portal';
UPDATE Skins SET Logo = 'just_logo.gif' WHERE Logo = 'just_logo_1.gif';

UPDATE ConfigurationAdmin SET prompt = 'la_config_PathToWebsite' WHERE VariableName = 'Site_Path';

# ===== v 5.0.0 =====
CREATE TABLE StopWords (
  StopWordId int(11) NOT NULL auto_increment,
  StopWord varchar(255) NOT NULL default '',
  PRIMARY KEY  (StopWordId),
  KEY StopWord (StopWord)
);

INSERT INTO StopWords VALUES (90, '~'),(152, 'on'),(157, 'see'),(156, 'put'),(128, 'and'),(154, 'or'),(155, 'other'),(153, 'one'),(126, 'as'),(127, 'at'),(125, 'are'),(91, '!'),(92, '@'),(93, '#'),(94, '$'),(95, '%'),(96, '^'),(97, '&'),(98, '*'),(99, '('),(100, ')'),(101, '-'),(102, '_'),(103, '='),(104, '+'),(105, '['),(106, '{'),(107, ']'),(108, '}'),(109, '\\'),(110, '|'),(111, ';'),(112, ':'),(113, ''''),(114, '"'),(115, '<'),(116, '.'),(117, '>'),(118, '/'),(119, '?'),(120, 'ah'),(121, 'all'),(122, 'also'),(123, 'am'),(124, 'an'),(151, 'of'),(150, 'note'),(149, 'not'),(148, 'no'),(147, 'may'),(146, 'its'),(145, 'it'),(144, 'is'),(143, 'into'),(142, 'in'),(141, 'had'),(140, 'has'),(139, 'have'),(138, 'from'),(137, 'form'),(136, 'for'),(135, 'end'),(134, 'each'),(133, 'can'),(132, 'by'),(130, 'be'),(131, 'but'),(129, 'any'),(158, 'that'),(159, 'the'),(160, 'their'),(161, 'there'),(162, 'these'),(163, 'they'),(164, 'this'),(165, 'through'),(166, 'thus'),(167, 'to'),(168, 'two'),(169, 'too'),(170, 'up'),(171, 'where'),(172, 'which'),(173, 'with'),(174, 'were'),(175, 'was'),(176, 'you'),(177, 'yet');

INSERT INTO Permissions VALUES (DEFAULT, 'in-portal:stop_words.view', 11, 1, 1, 0);
INSERT INTO Permissions VALUES (DEFAULT, 'in-portal:stop_words.add', 11, 1, 1, 0);
INSERT INTO Permissions VALUES (DEFAULT, 'in-portal:stop_words.edit', 11, 1, 1, 0);
INSERT INTO Permissions VALUES (DEFAULT, 'in-portal:stop_words.delete', 11, 1, 1, 0);

INSERT INTO ConfigurationAdmin VALUES ('CheckStopWords', 'la_Text_Website', 'la_config_CheckStopWords', 'checkbox', '', '', 10.29, 0, 0);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'CheckStopWords', '0', 'In-Portal', 'in-portal:configure_general');

ALTER TABLE SpamControl ADD INDEX (DataType);

CREATE TABLE MailingLists (
  MailingId int(10) unsigned NOT NULL auto_increment,
  PortalUserId int(11) NOT NULL default '-1',
  `To` longtext,
  ToParsed longtext,
  Attachments text,
  `Subject` varchar(255) NOT NULL,
  MessageText longtext,
  MessageHtml longtext,
  `Status` tinyint(3) unsigned NOT NULL default '1',
  EmailsQueued int(10) unsigned NOT NULL,
  EmailsSent int(10) unsigned NOT NULL,
  EmailsTotal int(10) unsigned NOT NULL,
  PRIMARY KEY  (MailingId),
  KEY EmailsTotal (EmailsTotal),
  KEY EmailsSent (EmailsSent),
  KEY EmailsQueued (EmailsQueued),
  KEY `Status` (`Status`),
  KEY PortalUserId (PortalUserId)
);

INSERT INTO Permissions VALUES (DEFAULT, 'in-portal:mailing_lists.view', 11, 1, 1, 0);
INSERT INTO Permissions VALUES (DEFAULT, 'in-portal:mailing_lists.add', 11, 1, 1, 0);
INSERT INTO Permissions VALUES (DEFAULT, 'in-portal:mailing_lists.edit', 11, 1, 1, 0);
INSERT INTO Permissions VALUES (DEFAULT, 'in-portal:mailing_lists.delete', 11, 1, 1, 0);

ALTER TABLE EmailQueue
	ADD MailingId INT UNSIGNED NOT NULL,
	ADD INDEX (MailingId);

INSERT INTO ConfigurationAdmin VALUES ('MailingListQueuePerStep', 'la_Text_smtp_server', 'la_config_MailingListQueuePerStep', 'text', NULL, NULL, 30.09, 0, 0);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'MailingListQueuePerStep', 10, 'In-Portal', 'in-portal:configure_general');

INSERT INTO ConfigurationAdmin VALUES ('MailingListSendPerStep', 'la_Text_smtp_server', 'la_config_MailingListSendPerStep', 'text', NULL, NULL, 30.10, 0, 0);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'MailingListSendPerStep', 10, 'In-Portal', 'in-portal:configure_general');

ALTER TABLE Events ADD INDEX (Event);
ALTER TABLE SearchLog ADD INDEX (Keyword);

ALTER TABLE Skins
	ADD LogoBottom VARCHAR(255) NOT NULL AFTER Logo,
	ADD LogoLogin VARCHAR(255) NOT NULL AFTER LogoBottom;

UPDATE Skins
SET Logo = 'in-portal_logo_img.jpg', LogoBottom = 'in-portal_logo_img2.jpg', LogoLogin = 'in-portal_logo_login.gif'
WHERE Logo = 'just_logo_1.gif' OR Logo = 'just_logo.gif';

INSERT INTO ConfigurationValues VALUES (DEFAULT, 'SiteNameSubTitle', '', 'In-Portal', 'in-portal:configure_general');
INSERT INTO ConfigurationAdmin VALUES ('SiteNameSubTitle', 'la_Text_Website', 'la_config_SiteNameSubTitle', 'text', '', '', 10.021, 0, 0);

INSERT INTO ConfigurationAdmin VALUES ('ResizableFrames', 'la_Text_Website', 'la_config_ResizableFrames', 'checkbox', '', '', 10.30, 0, 0);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'ResizableFrames', '0', 'In-Portal', 'in-portal:configure_general');

INSERT INTO ConfigurationAdmin VALUES ('QuickCategoryPermissionRebuild', 'la_Text_General', 'la_config_QuickCategoryPermissionRebuild', 'checkbox', NULL , NULL , 10.12, 0, 0);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'QuickCategoryPermissionRebuild', '1', 'In-Portal', 'in-portal:configure_categories');

ALTER TABLE Language ADD UserDocsUrl VARCHAR(255) NOT NULL;

UPDATE Category SET Template = CategoryTemplate WHERE CategoryTemplate <> '';

ALTER TABLE Category
	ADD ThemeId INT UNSIGNED NOT NULL,
	ADD INDEX (ThemeId),
	ADD COLUMN UseExternalUrl tinyint(3) unsigned NOT NULL default '0' AFTER Template,
	ADD COLUMN ExternalUrl varchar(255) NOT NULL default '' AFTER UseExternalUrl,
	ADD COLUMN UseMenuIconUrl tinyint(3) unsigned NOT NULL default '0' AFTER ExternalUrl,
	ADD COLUMN MenuIconUrl varchar(255) NOT NULL default '' AFTER UseMenuIconUrl,
	CHANGE MetaKeywords MetaKeywords TEXT,
	CHANGE MetaDescription MetaDescription TEXT,
	CHANGE CachedCategoryTemplate CachedTemplate VARCHAR(255) NOT NULL,
	DROP CategoryTemplate;

UPDATE Category SET l1_MenuTitle = l1_Name WHERE l1_MenuTitle = '' OR l1_MenuTitle LIKE '_Auto: %';
UPDATE Category SET l2_MenuTitle = l2_Name WHERE l2_MenuTitle = '' OR l2_MenuTitle LIKE '_Auto: %';
UPDATE Category SET l3_MenuTitle = l3_Name WHERE l3_MenuTitle = '' OR l3_MenuTitle LIKE '_Auto: %';
UPDATE Category SET l4_MenuTitle = l4_Name WHERE l4_MenuTitle = '' OR l4_MenuTitle LIKE '_Auto: %';
UPDATE Category SET l5_MenuTitle = l5_Name WHERE l5_MenuTitle = '' OR l5_MenuTitle LIKE '_Auto: %';
UPDATE Category SET Template = '/platform/designs/general' WHERE Template = '/in-edit/designs/general';
UPDATE Category SET CachedTemplate = '/platform/designs/general' WHERE CachedTemplate = '/in-edit/designs/general';
UPDATE Category SET CachedTemplate = Template WHERE Template <> '';

CREATE TABLE PageContent (
  PageContentId int(11) NOT NULL auto_increment,
  ContentNum int(11) NOT NULL default '0',
  PageId int(11) NOT NULL default '0',
  l1_Content text,
  l2_Content text,
  l3_Content text,
  l4_Content text,
  l5_Content text,
  l1_Translated tinyint(4) NOT NULL default '0',
  l2_Translated tinyint(4) NOT NULL default '0',
  l3_Translated tinyint(4) NOT NULL default '0',
  l4_Translated tinyint(4) NOT NULL default '0',
  l5_Translated tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (PageContentId),
  KEY ContentNum (ContentNum,PageId)
);

CREATE TABLE FormFields (
  FormFieldId int(11) NOT NULL auto_increment,
  FormId int(11) NOT NULL default '0',
  Type int(11) NOT NULL default '0',
  FieldName varchar(255) NOT NULL default '',
  FieldLabel varchar(255) default NULL,
  Heading varchar(255) default NULL,
  Prompt varchar(255) default NULL,
  ElementType varchar(50) NOT NULL default '',
  ValueList varchar(255) default NULL,
  Priority int(11) NOT NULL default '0',
  IsSystem tinyint(3) unsigned NOT NULL default '0',
  Required tinyint(1) NOT NULL default '0',
  DisplayInGrid tinyint(1) NOT NULL default '1',
  DefaultValue text NOT NULL,
  Validation TINYINT NOT NULL DEFAULT '0',
  PRIMARY KEY  (FormFieldId),
  KEY `Type` (`Type`),
  KEY FormId (FormId),
  KEY Priority (Priority),
  KEY IsSystem (IsSystem),
  KEY DisplayInGrid (DisplayInGrid)
);

CREATE TABLE FormSubmissions (
  FormSubmissionId int(11) NOT NULL auto_increment,
  FormId int(11) NOT NULL default '0',
  SubmissionTime int(11) NOT NULL default '0',
  PRIMARY KEY  (FormSubmissionId),
  KEY FormId (FormId),
  KEY SubmissionTime (SubmissionTime)
);

CREATE TABLE Forms (
  FormId int(11) NOT NULL auto_increment,
  Title VARCHAR(255) NOT NULL DEFAULT '',
  Description text,
  PRIMARY KEY  (FormId)
);

UPDATE Events SET Module = 'Core:Category', Description = 'la_event_FormSubmitted' WHERE Event = 'FORM.SUBMITTED';

DELETE FROM PersistantSessionData WHERE VariableName LIKE '%img%';
UPDATE Modules SET TemplatePath = Path WHERE TemplatePath <> '';

UPDATE ConfigurationValues SET VariableValue = '/platform/designs/general' WHERE VariableName = 'cms_DefaultDesign';
UPDATE ConfigurationValues SET ModuleOwner = 'In-Portal', Section = 'in-portal:configure_categories' WHERE VariableName = 'cms_DefaultDesign';
UPDATE ConfigurationAdmin SET DisplayOrder = 10.15 WHERE VariableName = 'cms_DefaultDesign';

UPDATE Phrase SET Phrase = 'la_Regular' WHERE Phrase = 'la_regular';
UPDATE Phrase SET Module = 'Core' WHERE Phrase IN ('la_Hide', 'la_Show', 'la_fld_Requied', 'la_col_Modified', 'la_col_Referer', 'la_Regular');
UPDATE Phrase SET Phrase = 'la_title_Editing_E-mail' WHERE Phrase = 'la_title_editing_e-mail';

ALTER TABLE Phrase ADD UNIQUE (LanguageId, Phrase);

ALTER TABLE CustomField ADD IsRequired tinyint(3) unsigned NOT NULL default '0';

DELETE FROM Permissions
WHERE
	(Permission LIKE 'proj-cms:structure%') OR
	(Permission LIKE 'proj-cms:submissions%') OR
	(Permission LIKE 'proj-base:users%') OR
	(Permission LIKE 'proj-base:system_variables%') OR
	(Permission LIKE 'proj-base:email_settings%') OR
	(Permission LIKE 'proj-base:other_settings%') OR
	(Permission LIKE 'proj-base:sysconfig%');

UPDATE Permissions SET Permission = REPLACE(Permission, 'proj-cms:browse', 'in-portal:browse_site');
UPDATE Permissions SET Permission = REPLACE(Permission, 'proj-cms:', 'in-portal:');
UPDATE Permissions SET Permission = REPLACE(Permission, 'proj-base:', 'in-portal:');

ALTER TABLE CategoryItems ADD INDEX (ItemResourceId);
ALTER TABLE CategoryItems DROP INDEX Filename;
ALTER TABLE CategoryItems ADD INDEX Filename(Filename);

DROP TABLE Pages;
DELETE FROM PermissionConfig WHERE PermissionName LIKE 'PAGE.%';
DELETE FROM Permissions WHERE Permission LIKE 'PAGE.%';
DELETE FROM SearchConfig WHERE TableName = 'Pages';
DELETE FROM ConfigurationAdmin WHERE VariableName LIKE '%_pages';
DELETE FROM ConfigurationValues WHERE VariableName LIKE '%_pages';
DELETE FROM ConfigurationAdmin WHERE VariableName LIKE 'PerPage_Pages%';
DELETE FROM ConfigurationValues WHERE VariableName LIKE 'PerPage_Pages%';

INSERT INTO Permissions VALUES (DEFAULT, 'in-portal:website_setting_folder.view', 11, 1, 1, 0);
INSERT INTO Permissions VALUES (DEFAULT, 'in-portal:user_setting_folder.view', 11, 1, 1, 0);
INSERT INTO Permissions VALUES (DEFAULT, 'in-portal:configure_advanced.view', 11, 1, 1, 0);
INSERT INTO Permissions VALUES (DEFAULT, 'in-portal:configure_advanced.edit', 11, 1, 1, 0);

#INSERT INTO Permissions VALUES (DEFAULT, 'in-portal:spelling_dictionary.delete', 11, 1, 1, 0);
#INSERT INTO Permissions VALUES (DEFAULT, 'in-portal:spelling_dictionary.edit', 11, 1, 1, 0);
#INSERT INTO Permissions VALUES (DEFAULT, 'in-portal:spelling_dictionary.add', 11, 1, 1, 0);
#INSERT INTO Permissions VALUES (DEFAULT, 'in-portal:spelling_dictionary.view', 11, 1, 1, 0);

UPDATE ConfigurationValues
SET ModuleOwner = 'In-Portal', Section = 'in-portal:configure_general'
WHERE ModuleOwner = 'Proj-Base' AND Section IN ('proj-base:system_variables', 'proj-base:email_settings');

UPDATE ConfigurationValues
SET ModuleOwner = 'In-Portal', Section = 'in-portal:configure_advanced'
WHERE ModuleOwner = 'Proj-Base' AND Section IN ('proj-base:other_settings', 'proj-base:sysconfig');

UPDATE ConfigurationAdmin SET heading = 'la_Text_General' WHERE VariableName IN ('AdvancedUserManagement', 'RememberLastAdminTemplate', 'DefaultSettingsUserId');
UPDATE ConfigurationAdmin SET DisplayOrder = 10.011 WHERE VariableName = 'AdvancedUserManagement';
UPDATE ConfigurationAdmin SET DisplayOrder = 10.14 WHERE VariableName = 'RememberLastAdminTemplate';
UPDATE ConfigurationAdmin SET DisplayOrder = 10.15 WHERE VariableName = 'DefaultSettingsUserId';
UPDATE ConfigurationAdmin SET DisplayOrder = 10.13 WHERE VariableName = 'FilenameSpecialCharReplacement';
UPDATE ConfigurationAdmin SET DisplayOrder = 10.14 WHERE VariableName = 'YahooApplicationId';

UPDATE ConfigurationAdmin SET heading = 'la_section_SettingsMailling', prompt = 'la_prompt_AdminMailFrom', ValueList = 'size="40"', DisplayOrder = 30.07 WHERE VariableName = 'Smtp_AdminMailFrom';
UPDATE ConfigurationAdmin SET heading = 'la_section_SettingsWebsite' WHERE VariableName IN ('Site_Path','SiteNameSubTitle','UseModRewrite','Config_Server_Time','Config_Site_Time','ErrorTemplate','NoPermissionTemplate','UsePageHitCounter','ForceImageMagickResize','CheckStopWords','Site_Name');
UPDATE ConfigurationAdmin SET heading = 'la_section_SettingsSession' WHERE VariableName IN ('CookieSessions','SessionCookieName','SessionTimeout','KeepSessionOnBrowserClose','SessionReferrerCheck','UseJSRedirect');
UPDATE ConfigurationAdmin SET heading = 'la_section_SettingsSSL' WHERE VariableName IN ('SSL_URL','AdminSSL_URL','Require_SSL','Require_AdminSSL','Force_HTTP_When_SSL_Not_Required','UseModRewriteWithSSL');
UPDATE ConfigurationAdmin SET heading = 'la_section_SettingsAdmin' WHERE VariableName IN ('UseToolbarLabels','UseSmallHeader','UseColumnFreezer','UsePopups','UseDoubleSorting','MenuFrameWidth','ResizableFrames','AutoRefreshIntervals');
UPDATE ConfigurationAdmin SET heading = 'la_section_SettingsMailling' WHERE VariableName IN ('Smtp_Server','Smtp_Port','Smtp_Authenticate','Smtp_User','Smtp_Pass','Smtp_DefaultHeaders','MailFunctionHeaderSeparator','MailingListQueuePerStep','MailingListSendPerStep');
UPDATE ConfigurationAdmin SET heading = 'la_section_SettingsSystem' WHERE VariableName IN ('UseOutputCompression','OutputCompressionLevel','TrimRequiredFields','UseCronForRegularEvent','UseChangeLog','Backup_Path','SystemTagCache','SocketBlockingMode');
UPDATE ConfigurationAdmin SET heading = 'la_section_SettingsCSVExport' WHERE VariableName IN ('CSVExportDelimiter','CSVExportEnclosure','CSVExportSeparator','CSVExportEncoding');

UPDATE ConfigurationAdmin SET DisplayOrder = 10.01 WHERE VariableName = 'Site_Path';
UPDATE ConfigurationAdmin SET DisplayOrder = 10.02 WHERE VariableName = 'SiteNameSubTitle';
UPDATE ConfigurationAdmin SET DisplayOrder = 10.03 WHERE VariableName = 'UseModRewrite';
UPDATE ConfigurationAdmin SET DisplayOrder = 10.04 WHERE VariableName = 'Config_Server_Time';
UPDATE ConfigurationAdmin SET DisplayOrder = 10.05 WHERE VariableName = 'Config_Site_Time';
UPDATE ConfigurationAdmin SET DisplayOrder = 10.06 WHERE VariableName = 'ErrorTemplate';
UPDATE ConfigurationAdmin SET DisplayOrder = 10.07 WHERE VariableName = 'NoPermissionTemplate';
UPDATE ConfigurationAdmin SET DisplayOrder = 10.08 WHERE VariableName = 'UsePageHitCounter';
UPDATE ConfigurationAdmin SET DisplayOrder = 10.09 WHERE VariableName = 'ForceImageMagickResize';
UPDATE ConfigurationAdmin SET DisplayOrder = 10.10 WHERE VariableName = 'CheckStopWords';

UPDATE ConfigurationAdmin SET DisplayOrder = 20.01 WHERE VariableName = 'CookieSessions';
UPDATE ConfigurationAdmin SET DisplayOrder = 20.02 WHERE VariableName = 'SessionCookieName';
UPDATE ConfigurationAdmin SET DisplayOrder = 20.03 WHERE VariableName = 'SessionTimeout';
UPDATE ConfigurationAdmin SET DisplayOrder = 20.04 WHERE VariableName = 'KeepSessionOnBrowserClose';
UPDATE ConfigurationAdmin SET DisplayOrder = 20.05 WHERE VariableName = 'SessionReferrerCheck';
UPDATE ConfigurationAdmin SET DisplayOrder = 20.06 WHERE VariableName = 'UseJSRedirect';

UPDATE ConfigurationAdmin SET DisplayOrder = 30.01 WHERE VariableName = 'SSL_URL';
UPDATE ConfigurationAdmin SET DisplayOrder = 30.02 WHERE VariableName = 'AdminSSL_URL';
UPDATE ConfigurationAdmin SET DisplayOrder = 30.03 WHERE VariableName = 'Require_SSL';
UPDATE ConfigurationAdmin SET DisplayOrder = 30.04 WHERE VariableName = 'Require_AdminSSL';
UPDATE ConfigurationAdmin SET DisplayOrder = 30.05 WHERE VariableName = 'Force_HTTP_When_SSL_Not_Required';
UPDATE ConfigurationAdmin SET DisplayOrder = 30.06 WHERE VariableName = 'UseModRewriteWithSSL';

UPDATE ConfigurationAdmin SET DisplayOrder = 40.01 WHERE VariableName = 'UseToolbarLabels';
UPDATE ConfigurationAdmin SET DisplayOrder = 40.02 WHERE VariableName = 'UseSmallHeader';
UPDATE ConfigurationAdmin SET DisplayOrder = 40.03 WHERE VariableName = 'UseColumnFreezer';
UPDATE ConfigurationAdmin SET DisplayOrder = 40.04 WHERE VariableName = 'UsePopups';
UPDATE ConfigurationAdmin SET DisplayOrder = 40.05 WHERE VariableName = 'UseDoubleSorting';
UPDATE ConfigurationAdmin SET DisplayOrder = 40.06 WHERE VariableName = 'MenuFrameWidth';
UPDATE ConfigurationAdmin SET DisplayOrder = 40.07 WHERE VariableName = 'ResizableFrames';
UPDATE ConfigurationAdmin SET DisplayOrder = 40.08 WHERE VariableName = 'AutoRefreshIntervals';

UPDATE ConfigurationAdmin SET DisplayOrder = 50.01 WHERE VariableName = 'Smtp_Server';
UPDATE ConfigurationAdmin SET DisplayOrder = 50.02 WHERE VariableName = 'Smtp_Port';
UPDATE ConfigurationAdmin SET DisplayOrder = 50.03 WHERE VariableName = 'Smtp_Authenticate';
UPDATE ConfigurationAdmin SET DisplayOrder = 50.04 WHERE VariableName = 'Smtp_User';
UPDATE ConfigurationAdmin SET DisplayOrder = 50.05 WHERE VariableName = 'Smtp_Pass';
UPDATE ConfigurationAdmin SET DisplayOrder = 50.06 WHERE VariableName = 'Smtp_DefaultHeaders';
UPDATE ConfigurationAdmin SET DisplayOrder = 50.07 WHERE VariableName = 'MailFunctionHeaderSeparator';
UPDATE ConfigurationAdmin SET DisplayOrder = 50.08 WHERE VariableName = 'MailingListQueuePerStep';
UPDATE ConfigurationAdmin SET DisplayOrder = 50.09 WHERE VariableName = 'MailingListSendPerStep';

UPDATE ConfigurationAdmin SET DisplayOrder = 60.01 WHERE VariableName = 'UseOutputCompression';
UPDATE ConfigurationAdmin SET DisplayOrder = 60.02 WHERE VariableName = 'OutputCompressionLevel';
UPDATE ConfigurationAdmin SET DisplayOrder = 60.03 WHERE VariableName = 'TrimRequiredFields';
UPDATE ConfigurationAdmin SET DisplayOrder = 60.04 WHERE VariableName = 'UseCronForRegularEvent';
UPDATE ConfigurationAdmin SET DisplayOrder = 60.05 WHERE VariableName = 'UseChangeLog';
UPDATE ConfigurationAdmin SET DisplayOrder = 60.06 WHERE VariableName = 'Backup_Path';
UPDATE ConfigurationAdmin SET DisplayOrder = 60.07 WHERE VariableName = 'SystemTagCache';
UPDATE ConfigurationAdmin SET DisplayOrder = 60.08 WHERE VariableName = 'SocketBlockingMode';

UPDATE ConfigurationAdmin SET DisplayOrder = 70.01 WHERE VariableName = 'CSVExportDelimiter';
UPDATE ConfigurationAdmin SET DisplayOrder = 70.02 WHERE VariableName = 'CSVExportEnclosure';
UPDATE ConfigurationAdmin SET DisplayOrder = 70.03 WHERE VariableName = 'CSVExportSeparator';
UPDATE ConfigurationAdmin SET DisplayOrder = 70.04 WHERE VariableName = 'CSVExportEncoding';

UPDATE Phrase SET Phrase = 'la_section_SettingsWebsite' WHERE Phrase = 'la_Text_Website';
UPDATE Phrase SET Phrase = 'la_section_SettingsMailling' WHERE Phrase = 'la_Text_smtp_server';
UPDATE Phrase SET Phrase = 'la_section_SettingsCSVExport' WHERE Phrase = 'la_Text_CSV_Export';
DELETE FROM Phrase WHERE Phrase IN (
	'la_Text_BackupPath', 'la_config_AllowManualFilenames', 'la_fld_cat_MenuLink', 'la_fld_UseCategoryTitle',
	'la_In-Edit', 'la_ItemTab_Pages', 'la_Text_Pages', 'la_title_Pages', 'la_title_Page_Categories', 'lu_Pages',
	'lu_page_HtmlTitle', 'lu_page_OnPageTitle', 'la_tab_AllPages', 'la_title_AllPages', 'la_title_ContentManagement',
	'la_title_ContentManagment', 'lu_ViewSubPages', 'la_CMS_FormSubmitted'
);
DELETE FROM Phrase WHERE (Phrase LIKE 'la_Description_In-Edit%') OR (Phrase LIKE 'la_Pages_PerPage%') OR (Phrase LIKE 'lu_PermName_Page.%');

UPDATE ConfigurationValues
SET VariableValue = 1, ModuleOwner = 'In-Portal:Users', Section = 'in-portal:configure_users'
WHERE VariableName = 'RememberLastAdminTemplate';

UPDATE ConfigurationValues
SET ModuleOwner = 'In-Portal:Users', Section = 'in-portal:configure_users'
WHERE VariableName IN ('AdvancedUserManagement', 'DefaultSettingsUserId');

INSERT INTO ConfigurationAdmin VALUES ('Search_MinKeyword_Length', 'la_Text_General', 'la_config_Search_MinKeyword_Length', 'text', NULL, NULL, 10.19, 0, 0);
UPDATE ConfigurationValues SET Section = 'in-portal:configure_categories' WHERE VariableName = 'Search_MinKeyword_Length';

UPDATE ConfigurationAdmin
SET ValueList = '=+,<SQL>SELECT DestName AS OptionName, DestId AS OptionValue FROM <PREFIX>StdDestinations WHERE COALESCE(DestParentId, 0) = 0 ORDER BY OptionName</SQL>'
WHERE VariableName = 'User_Default_Registration_Country';

UPDATE ConfigurationValues
SET ModuleOwner = 'In-Portal', Section = 'in-portal:configure_advanced'
WHERE VariableName IN (
	'Site_Path', 'SiteNameSubTitle', 'CookieSessions', 'SessionCookieName', 'SessionTimeout', 'SessionReferrerCheck',
	'SystemTagCache', 'SocketBlockingMode', 'SSL_URL', 'AdminSSL_URL', 'Require_SSL', 'Force_HTTP_When_SSL_Not_Required',
	'UseModRewrite', 'UseModRewriteWithSSL', 'UseJSRedirect', 'UseCronForRegularEvent', 'ErrorTemplate',
	'NoPermissionTemplate', 'UseOutputCompression', 'OutputCompressionLevel', 'UseToolbarLabels', 'UseSmallHeader',
	'UseColumnFreezer', 'TrimRequiredFields', 'UsePageHitCounter', 'UseChangeLog', 'AutoRefreshIntervals',
	'KeepSessionOnBrowserClose', 'ForceImageMagickResize', 'CheckStopWords', 'ResizableFrames', 'Config_Server_Time',
	'Config_Site_Time', 'Smtp_Server', 'Smtp_Port', 'Smtp_Authenticate', 'Smtp_User', 'Smtp_Pass', 'Smtp_DefaultHeaders',
	'MailFunctionHeaderSeparator', 'MailingListQueuePerStep', 'MailingListSendPerStep', 'Backup_Path',
	'CSVExportDelimiter', 'CSVExportEnclosure', 'CSVExportSeparator', 'CSVExportEncoding'
);

DELETE FROM ConfigurationValues WHERE VariableName IN (
	'Columns_Category', 'Perpage_Archive', 'debug', 'Perpage_User', 'Perpage_LangEmail', 'Default_FromAddr',
	'email_replyto', 'email_footer', 'Default_Theme', 'Default_Language', 'User_SortField', 'User_SortOrder',
	'Suggest_MinInterval', 'SubCat_ListCount', 'Timeout_Rating', 'Perpage_Relations', 'Group_SortField',
	'Group_SortOrder', 'Default_FromName', 'Relation_LV_Sortfield', 'ampm_time', 'Perpage_Template',
	'Perpage_Phrase', 'Perpage_Sessionlist', 'Perpage_Items', 'GuestSessions', 'Perpage_Email',
	'LinksValidation_LV_Sortfield', 'CustomConfig_LV_Sortfield', 'Event_LV_SortField', 'Theme_LV_SortField',
	'Template_LV_SortField', 'Lang_LV_SortField', 'Phrase_LV_SortField', 'LangEmail_LV_SortField',
	'CustomData_LV_SortField', 'Summary_SortField', 'Session_SortField', 'SearchLog_SortField', 'Perpage_StatItem',
	'Perpage_Groups', 'Perpage_Event', 'Perpage_BanRules', 'Perpage_SearchLog', 'Perpage_LV_lang',
	'Perpage_LV_Themes', 'Perpage_LV_Catlist', 'Perpage_Reviews', 'Perpage_Modules', 'Perpage_Grouplist',
	'Perpage_Images', 'EmailsL_SortField', 'Perpage_EmailsL', 'Perpage_CustomData', 'Perpage_Review',
	'SearchRel_DefaultIncrease', 'SearchRel_DefaultKeyword', 'SearchRel_DefaultPop', 'SearchRel_DefaultRating',
	'Category_Highlight_OpenTag', 'Category_Highlight_CloseTag', 'DomainSelect', 'MetaKeywords', 'MetaDescription',
	'Config_Name', 'Config_Company', 'Config_Reg_Number', 'Config_Website_Name', 'Config_Web_Address',
	'Smtp_SendHTML', 'ProjCMSAllowManualFilenames'
);

DELETE FROM ConfigurationAdmin WHERE VariableName IN ('Domain_Detect', 'Server_Name', 'ProjCMSAllowManualFilenames');

DROP TABLE SuggestMail;

ALTER TABLE ThemeFiles ADD FileMetaInfo TEXT NULL;

UPDATE SearchConfig
SET SimpleSearch = 0
WHERE FieldType NOT IN ('text', 'range') AND SimpleSearch = 1;

DELETE FROM PersistantSessionData WHERE VariableName IN ('c_columns_.', 'c.showall_columns_.', 'emailevents_columns_.', 'emailmessages_columns_.');

INSERT INTO ConfigurationAdmin VALUES ('DebugOnlyFormConfigurator', 'la_section_SettingsAdmin', 'la_config_DebugOnlyFormConfigurator', 'checkbox', '', '', 40.09, 0, 0);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'DebugOnlyFormConfigurator', '0', 'In-Portal', 'in-portal:configure_advanced');

CREATE TABLE Semaphores (
  SemaphoreId int(11) NOT NULL auto_increment,
  SessionKey int(10) unsigned NOT NULL,
  Timestamp int(10) unsigned NOT NULL,
  MainPrefix varchar(255) NOT NULL,
  PRIMARY KEY  (SemaphoreId),
  KEY SessionKey (SessionKey),
  KEY Timestamp (Timestamp),
  KEY MainPrefix (MainPrefix)
);

ALTER TABLE Language ADD IconDisabledURL VARCHAR(255) NULL DEFAULT NULL AFTER IconURL;

UPDATE Phrase
SET Translation = REPLACE(Translation, 'category', 'section')
WHERE (Phrase IN (
	'la_confirm_maintenance', 'la_error_move_subcategory', 'la_error_RootCategoriesDelete',
	'la_error_unknown_category', 'la_fld_IsBaseCategory', 'la_nextcategory', 'la_prevcategory',
	'la_prompt_max_import_category_levels', 'la_prompt_root_name', 'la_SeparatedCategoryPath',
	'la_title_category_select'
) OR Phrase LIKE 'la_Description_%') AND (PhraseType = 1);

UPDATE Phrase SET Translation = REPLACE(Translation, 'Category', 'Section') WHERE PhraseType = 1;

UPDATE Phrase
SET Translation = REPLACE(Translation, 'categories', 'sections')
WHERE (Phrase IN (
	'la_category_perpage_prompt', 'la_category_showpick_prompt', 'la_category_sortfield_prompt',
	'la_Description_in-portal:advanced_view', 'la_Description_in-portal:browse', 'la_Description_in-portal:site',
	'la_error_copy_subcategory', 'la_Msg_PropagateCategoryStatus', 'la_Text_DataType_1'
)) AND (PhraseType = 1);

UPDATE Phrase SET Translation = REPLACE(Translation, 'Categories', 'Sections') WHERE PhraseType = 1;

UPDATE Phrase
SET Translation = REPLACE(Translation, 'Page', 'Section')
WHERE (Phrase IN ('la_col_PageTitle', 'la_col_System', 'la_fld_IsIndex', 'la_fld_PageTitle', 'la_section_Page')) AND (PhraseType = 1);

DELETE FROM Phrase WHERE Phrase IN ('la_title_Adding_Page', 'la_title_Editing_Page', 'la_title_New_Page', 'la_fld_PageId');

INSERT INTO ConfigurationAdmin VALUES ('UseModalWindows', 'la_section_SettingsAdmin', 'la_config_UseModalWindows', 'checkbox', '', '', 40.10, 0, 0);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'UseModalWindows', '1', 'In-Portal', 'in-portal:configure_advanced');

UPDATE Language SET UserDocsUrl = 'http://docs.in-portal.org/eng/index.php';

DELETE FROM Modules WHERE Name = 'Proj-Base';

DELETE FROM Phrase WHERE Phrase IN ('la_fld_ImageId', 'la_fld_RelationshipId', 'la_fld_ReviewId', 'la_prompt_CensorhipId', 'my_account_title', 'Next Theme', 'Previous Theme', 'test 1', 'la_article_reviewed', 'la_configerror_review', 'la_link_reviewed', 'la_Prompt_ReviewedBy', 'la_prompt_ReviewId', 'la_prompt_ReviewText', 'la_reviewer', 'la_review_added', 'la_review_alreadyreviewed', 'la_review_error', 'la_tab_Editing_Review', 'la_tab_Review', 'la_ToolTip_New_Review', 'la_topic_reviewed', 'lu_add_review', 'lu_article_reviews', 'lu_ferror_review_duplicate', 'lu_link_addreview_confirm_pending_text', 'lu_link_reviews', 'lu_link_review_confirm', 'lu_link_review_confirm_pending', 'lu_link_addreview_confirm_text', 'lu_news_addreview_confirm_text', 'lu_news_addreview_confirm__pending_text', 'lu_news_review_confirm', 'lu_news_review_confirm_pending', 'lu_prompt_review', 'lu_reviews_updated', 'lu_review_access_denied', 'lu_review_article', 'lu_review_link', 'lu_review_news', 'lu_review_this_article', 'lu_fld_Review', 'lu_product_reviews', 'lu_ReviewProduct', ' lu_resetpw_confirm_text', 'lu_resetpw_confirm_text');

UPDATE Modules SET Version = '5.0.0', Loaded = 1 WHERE Name = 'In-Portal';

# ===== v 5.0.1 =====
UPDATE ConfigurationAdmin
SET ValueList = '1=la_opt_UserInstantRegistration,2=la_opt_UserNotAllowedRegistration,3=la_opt_UserUponApprovalRegistration,4=la_opt_UserEmailActivation'
WHERE VariableName = 'User_Allow_New';

UPDATE ConfigurationValues SET VariableValue = '1' WHERE VariableName = 'ResizableFrames';

UPDATE Phrase
SET Translation = REPLACE(Translation, 'Page', 'Section')
WHERE (Phrase IN ('la_col_PageTitle', 'la_col_System', 'la_fld_IsIndex', 'la_fld_PageTitle', 'la_section_Page')) AND (PhraseType = 1);

DELETE FROM Phrase WHERE Phrase IN ('la_Tab', 'la_Colon', 'la_Semicolon', 'la_Space', 'la_Colon', 'la_User_Instant', 'la_User_Not_Allowed', 'la_User_Upon_Approval', 'lu_title_PrivacyPolicy');

UPDATE ConfigurationAdmin SET ValueList = '0=la_opt_Tab,1=la_opt_Comma,2=la_opt_Semicolon,3=la_opt_Space,4=la_opt_Colon'
WHERE VariableName = 'CSVExportDelimiter';

UPDATE ConfigurationAdmin SET ValueList = '0=lu_opt_QueryString,1=lu_opt_Cookies,2=lu_opt_AutoDetect'
WHERE VariableName = 'CookieSessions';

UPDATE ConfigurationAdmin SET ValueList = 'Name=la_opt_Title,Description=la_opt_Description,CreatedOn=la_opt_CreatedOn,EditorsPick=la_opt_EditorsPick,<SQL>SELECT Prompt AS OptionName, CONCAT("cust_", FieldName) AS OptionValue FROM <PREFIX>CustomField WHERE (Type = 1) AND (IsSystem = 0)</SQL>'
WHERE VariableName = 'Category_Sortfield';

UPDATE ConfigurationAdmin SET ValueList = 'Name=la_opt_Title,Description=la_opt_Description,CreatedOn=la_opt_CreatedOn,EditorsPick=la_opt_EditorsPick,<SQL>SELECT Prompt AS OptionName, CONCAT("cust_", FieldName) AS OptionValue FROM <PREFIX>CustomField WHERE (Type = 1) AND (IsSystem = 0)</SQL>'
WHERE VariableName = 'Category_Sortfield2';

UPDATE Category SET Template = '#inherit#' WHERE COALESCE(Template, '') = '';
ALTER TABLE Category CHANGE Template Template VARCHAR(255) NOT NULL DEFAULT '#inherit#';

UPDATE Phrase SET Phrase = 'la_config_DefaultDesignTemplate' WHERE Phrase = 'la_prompt_DefaultDesignTemplate';

UPDATE ConfigurationAdmin SET heading = 'la_section_SettingsWebsite', prompt = 'la_config_DefaultDesignTemplate', DisplayOrder = 10.06 WHERE VariableName = 'cms_DefaultDesign';
UPDATE ConfigurationValues SET Section = 'in-portal:configure_advanced' WHERE VariableName = 'cms_DefaultDesign';
UPDATE ConfigurationAdmin SET DisplayOrder = DisplayOrder + 0.01 WHERE VariableName IN ('ErrorTemplate', 'NoPermissionTemplate');

UPDATE ConfigurationAdmin SET DisplayOrder = 10.15 WHERE VariableName = 'Search_MinKeyword_Length';
UPDATE ConfigurationAdmin SET DisplayOrder = 10.01 WHERE VariableName = 'Site_Name';
UPDATE ConfigurationAdmin SET DisplayOrder = 20.01 WHERE VariableName = 'FirstDayOfWeek';
UPDATE ConfigurationAdmin SET DisplayOrder = 30.01 WHERE VariableName = 'Smtp_AdminMailFrom';

UPDATE ConfigurationAdmin SET heading = 'la_Text_Date_Time_Settings', DisplayOrder = DisplayOrder + 9.98 WHERE VariableName IN ('Config_Server_Time', 'Config_Site_Time');
UPDATE ConfigurationValues SET Section = 'in-portal:configure_general' WHERE VariableName IN ('Config_Server_Time', 'Config_Site_Time');
UPDATE ConfigurationAdmin SET DisplayOrder = DisplayOrder - 0.02 WHERE VariableName IN ('cms_DefaultDesign', 'ErrorTemplate', 'NoPermissionTemplate', 'UsePageHitCounter', 'ForceImageMagickResize', 'CheckStopWords');

UPDATE ConfigurationAdmin SET DisplayOrder = 40.01 WHERE VariableName = 'SessionTimeout';
UPDATE ConfigurationValues SET Section = 'in-portal:configure_general' WHERE VariableName = 'SessionTimeout';
UPDATE ConfigurationAdmin SET DisplayOrder = DisplayOrder - 0.01 WHERE VariableName IN ('KeepSessionOnBrowserClose', 'SessionReferrerCheck', 'UseJSRedirect');

ALTER TABLE Events
	ADD FrontEndOnly TINYINT UNSIGNED NOT NULL DEFAULT '0' AFTER Enabled,
	ADD INDEX (FrontEndOnly);

UPDATE Events SET FrontEndOnly = 1 WHERE Enabled = 2;
UPDATE Events SET Enabled = 1 WHERE Enabled = 2;

ALTER TABLE Events CHANGE FromUserId FromUserId INT(11) NULL DEFAULT NULL;
UPDATE Events SET FromUserId = NULL WHERE FromUserId = 0;

DELETE FROM ConfigurationAdmin WHERE VariableName = 'SiteNameSubTitle';
DELETE FROM ConfigurationValues WHERE VariableName = 'SiteNameSubTitle';
UPDATE ConfigurationAdmin SET DisplayOrder = DisplayOrder - 0.01 WHERE VariableName IN ('UseModRewrite', 'cms_DefaultDesign', 'ErrorTemplate' 'NoPermissionTemplate', 'UsePageHitCounter', 'ForceImageMagickResize', 'CheckStopWords');

ALTER TABLE ConfigurationAdmin CHANGE validation Validation TEXT NULL DEFAULT NULL;
UPDATE ConfigurationAdmin SET Validation = 'a:3:{s:4:"type";s:3:"int";s:13:"min_value_inc";i:1;s:8:"required";i:1;}' WHERE VariableName = 'SessionTimeout';

INSERT INTO ConfigurationAdmin VALUES ('AdminConsoleInterface', 'la_section_SettingsAdmin', 'la_config_AdminConsoleInterface', 'select', '', 'simple=+simple,advanced=+advanced,custom=+custom', 50.01, 0, 1);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'AdminConsoleInterface', 'simple', 'In-Portal', 'in-portal:configure_general');
INSERT INTO ConfigurationAdmin VALUES ('AllowAdminConsoleInterfaceChange', 'la_section_SettingsAdmin', 'la_config_AllowAdminConsoleInterfaceChange', 'checkbox', NULL , NULL , 40.01, 0, 0);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'AllowAdminConsoleInterfaceChange', '1', 'In-Portal', 'in-portal:configure_advanced');
UPDATE ConfigurationAdmin SET DisplayOrder = DisplayOrder + 0.01 WHERE VariableName IN ('UseToolbarLabels', 'UseSmallHeader', 'UseColumnFreezer', 'UsePopups', 'UseDoubleSorting', 'MenuFrameWidth', 'ResizableFrames', 'AutoRefreshIntervals', 'DebugOnlyFormConfigurator', 'UseModalWindows');

INSERT INTO ConfigurationAdmin VALUES ('UseTemplateCompression', 'la_section_SettingsSystem', 'la_config_UseTemplateCompression', 'checkbox', '', '', 60.03, 0, 1);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'UseTemplateCompression', '0', 'In-Portal', 'in-portal:configure_advanced');
UPDATE ConfigurationAdmin SET DisplayOrder = DisplayOrder + 0.01 WHERE VariableName IN ('TrimRequiredFields', 'UseCronForRegularEvent', 'UseChangeLog', 'Backup_Path', 'SystemTagCache', 'SocketBlockingMode');

DELETE FROM ConfigurationAdmin WHERE VariableName = 'UseModalWindows';
DELETE FROM ConfigurationValues WHERE VariableName = 'UseModalWindows';
DELETE FROM Phrase WHERE Phrase = 'la_config_UseModalWindows';

UPDATE ConfigurationAdmin SET element_type = 'select', ValueList = '0=la_opt_SameWindow,1=la_opt_PopupWindow,2=la_opt_ModalWindow' WHERE VariableName = 'UsePopups';
UPDATE Phrase SET Translation = 'Editing Window Style' WHERE Phrase = 'la_config_UsePopups';

INSERT INTO ConfigurationAdmin VALUES ('UseVisitorTracking', 'la_section_SettingsWebsite', 'la_config_UseVisitorTracking', 'checkbox', '', '', 10.09, 0, 0);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'UseVisitorTracking', '0', 'In-Portal', 'in-portal:configure_advanced');

DELETE FROM ConfigurationAdmin WHERE VariableName = 'SessionReferrerCheck';
DELETE FROM ConfigurationValues WHERE VariableName = 'SessionReferrerCheck';
DELETE FROM Phrase WHERE Phrase = 'la_promt_ReferrerCheck';

INSERT INTO ConfigurationAdmin VALUES ('SessionBrowserSignatureCheck', 'la_section_SettingsSession', 'la_config_SessionBrowserSignatureCheck', 'checkbox', NULL, NULL, 20.04, 0, 1);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'SessionBrowserSignatureCheck', '0', 'In-Portal', 'in-portal:configure_advanced');

INSERT INTO ConfigurationAdmin VALUES ('SessionIPAddressCheck', 'la_section_SettingsSession', 'la_config_SessionIPAddressCheck', 'checkbox', NULL, NULL, 20.05, 0, 1);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'SessionIPAddressCheck', '0', 'In-Portal', 'in-portal:configure_advanced');

UPDATE ConfigurationAdmin SET DisplayOrder = DisplayOrder + 0.01 WHERE VariableName = 'UseJSRedirect';

ALTER TABLE UserSession
	DROP CurrentTempKey,
	DROP PrevTempKey,
	ADD BrowserSignature VARCHAR(32) NOT NULL,
	ADD INDEX (BrowserSignature);

UPDATE ConfigurationAdmin
SET DisplayOrder = DisplayOrder + 0.01
WHERE heading = 'la_section_SettingsAdmin' AND DisplayOrder > 40 AND DisplayOrder < 50;

UPDATE ConfigurationAdmin SET heading = 'la_section_SettingsAdmin', DisplayOrder = 40.01 WHERE VariableName = 'RootPass';
UPDATE ConfigurationValues SET ModuleOwner = 'In-Portal', Section = 'in-portal:configure_advanced' WHERE VariableName = 'RootPass';
UPDATE ConfigurationAdmin SET DisplayOrder = 10.12 WHERE VariableName = 'User_Default_Registration_Country';

UPDATE ConfigurationAdmin SET heading = 'la_section_SettingsAdmin', DisplayOrder = 40.12 WHERE VariableName = 'RememberLastAdminTemplate';
UPDATE ConfigurationValues SET ModuleOwner = 'In-Portal', Section = 'in-portal:configure_advanced' WHERE VariableName = 'RememberLastAdminTemplate';
UPDATE ConfigurationAdmin SET DisplayOrder = 10.14 WHERE VariableName = 'DefaultSettingsUserId';

INSERT INTO ConfigurationAdmin VALUES ('UseHTTPAuth', 'la_section_SettingsAdmin', 'la_config_UseHTTPAuth', 'checkbox', '', '', 40.13, 0, 0);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'UseHTTPAuth', '0', 'In-Portal', 'in-portal:configure_advanced');
INSERT INTO ConfigurationAdmin VALUES ('HTTPAuthUsername', 'la_section_SettingsAdmin', 'la_config_HTTPAuthUsername', 'text', '', '', 40.14, 0, 0);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'HTTPAuthUsername', '', 'In-Portal', 'in-portal:configure_advanced');
INSERT INTO ConfigurationAdmin VALUES ('HTTPAuthPassword', 'la_section_SettingsAdmin', 'la_config_HTTPAuthPassword', 'password', NULL, NULL, 40.15, 0, 0);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'HTTPAuthPassword', '', 'In-Portal', 'in-portal:configure_advanced');
INSERT INTO ConfigurationAdmin VALUES ('HTTPAuthBypassIPs', 'la_section_SettingsAdmin', 'la_config_HTTPAuthBypassIPs', 'text', '', '', 40.15, 0, 0);
INSERT INTO ConfigurationValues VALUES (DEFAULT, 'HTTPAuthBypassIPs', '', 'In-Portal', 'in-portal:configure_advanced');

INSERT INTO Permissions VALUES (DEFAULT, 'in-portal:service.edit', 11, 1, 1, 0);

UPDATE Phrase SET Phrase = 'la_col_Rating' WHERE Phrase = 'la_col_rating';
UPDATE Phrase SET Phrase = 'la_text_Review' WHERE Phrase = 'la_text_review';
UPDATE Phrase SET Phrase = 'la_title_Reviews' WHERE Phrase = 'la_title_reviews';
UPDATE Phrase SET Phrase = 'la_ToolTip_cancel' WHERE Phrase = 'la_tooltip_cancel';

ALTER TABLE Phrase
	ADD PhraseKey VARCHAR(255) NOT NULL AFTER Phrase,
	ADD INDEX (PhraseKey);

UPDATE Phrase SET PhraseKey = UPPER(Phrase);

UPDATE Modules SET Loaded = 1 WHERE `Name` = 'In-Portal';

# ===== v 5.0.2-B1 =====
ALTER TABLE PortalGroup DROP ResourceId;

ALTER TABLE Category
	DROP l1_Translated,
	DROP l2_Translated,
	DROP l3_Translated,
	DROP l4_Translated,
	DROP l5_Translated;

ALTER TABLE PageContent
	DROP l1_Translated,
	DROP l2_Translated,
	DROP l3_Translated,
	DROP l4_Translated,
	DROP l5_Translated;

ALTER TABLE Category
	CHANGE CachedTemplate CachedTemplate varchar(255) NOT NULL DEFAULT '',
	CHANGE ThemeId ThemeId int(10) unsigned NOT NULL DEFAULT '0';

ALTER TABLE UserSession CHANGE BrowserSignature BrowserSignature varchar(32) NOT NULL DEFAULT '';

ALTER TABLE ChangeLogs
	CHANGE Changes Changes text NULL,
	CHANGE OccuredOn OccuredOn INT(11) NULL DEFAULT NULL;

ALTER TABLE EmailLog CHANGE EventParams EventParams text NULL;
ALTER TABLE FormFields CHANGE DefaultValue DefaultValue text NULL;
ALTER TABLE ImportCache CHANGE VarValue VarValue text NULL;
ALTER TABLE ImportScripts CHANGE Description Description text NULL;
ALTER TABLE PersistantSessionData CHANGE VariableValue VariableValue text NULL;

ALTER TABLE Phrase
	CHANGE `Translation` `Translation` text NULL,
	CHANGE PhraseKey PhraseKey VARCHAR(255) NOT NULL DEFAULT '',
	CHANGE LastChanged LastChanged INT(10) UNSIGNED NULL DEFAULT NULL;

ALTER TABLE PhraseCache CHANGE PhraseList PhraseList text NULL;

ALTER TABLE Stylesheets
	CHANGE AdvancedCSS AdvancedCSS text NULL,
	CHANGE LastCompiled LastCompiled INT(10) UNSIGNED NULL DEFAULT NULL;

ALTER TABLE StylesheetSelectors
	CHANGE SelectorData SelectorData text NULL,
	CHANGE Description Description text NULL,
	CHANGE AdvancedCSS AdvancedCSS text NULL;

ALTER TABLE Category
	CHANGE `Status` `Status` TINYINT(4) NOT NULL DEFAULT '1',
	CHANGE CreatedOn CreatedOn INT(11) NULL DEFAULT NULL,
	CHANGE Modified Modified INT(11) NULL DEFAULT NULL;

ALTER TABLE Language CHANGE UserDocsUrl UserDocsUrl VARCHAR(255) NOT NULL DEFAULT '';

ALTER TABLE MailingLists
	CHANGE Subject Subject VARCHAR(255) NOT NULL DEFAULT '',
	CHANGE EmailsQueued EmailsQueued INT(10) UNSIGNED NOT NULL DEFAULT '0',
	CHANGE EmailsSent EmailsSent INT(10) UNSIGNED NOT NULL DEFAULT '0',
	CHANGE EmailsTotal EmailsTotal INT(10) UNSIGNED NOT NULL DEFAULT '0';

ALTER TABLE EmailQueue
	CHANGE MailingId MailingId INT(10) UNSIGNED NOT NULL DEFAULT '0',
	CHANGE Queued Queued INT(10) UNSIGNED NULL DEFAULT NULL,
	CHANGE LastSendRetry LastSendRetry INT(10) UNSIGNED NULL DEFAULT NULL;

ALTER TABLE ImportScripts CHANGE `Status` `Status` TINYINT(4) NOT NULL DEFAULT '1';

ALTER TABLE Semaphores
	CHANGE SessionKey SessionKey INT(10) UNSIGNED NOT NULL DEFAULT '0',
	CHANGE `Timestamp` `Timestamp` INT(10) UNSIGNED NOT NULL DEFAULT '0',
	CHANGE MainPrefix MainPrefix VARCHAR(255) NOT NULL DEFAULT '';

ALTER TABLE Skins
	CHANGE LogoBottom LogoBottom VARCHAR(255) NOT NULL DEFAULT '',
	CHANGE LogoLogin LogoLogin VARCHAR(255) NOT NULL DEFAULT '';

ALTER TABLE ItemReview CHANGE ReviewText ReviewText LONGTEXT NULL;
ALTER TABLE SessionData CHANGE VariableValue VariableValue LONGTEXT NULL;

ALTER TABLE PortalUser
	CHANGE `Status` `Status` TINYINT(4) NOT NULL DEFAULT '1',
	CHANGE Modified Modified INT(11) NULL DEFAULT NULL;

ALTER TABLE ItemFiles CHANGE CreatedOn CreatedOn INT(11) UNSIGNED NULL DEFAULT NULL;
ALTER TABLE FormSubmissions CHANGE SubmissionTime SubmissionTime INT(11) NULL DEFAULT NULL;
ALTER TABLE SessionLogs CHANGE SessionStart SessionStart INT(11) NULL DEFAULT NULL;
ALTER TABLE Visits CHANGE VisitDate VisitDate INT(10) UNSIGNED NULL DEFAULT NULL;

# ===== v 5.0.2-B2 =====
ALTER TABLE Theme
	ADD LanguagePackInstalled TINYINT UNSIGNED NOT NULL DEFAULT '0',
	ADD TemplateAliases TEXT,
	ADD INDEX (LanguagePackInstalled);

ALTER TABLE ThemeFiles
	ADD TemplateAlias VARCHAR(255) NOT NULL DEFAULT '' AFTER FilePath,
	ADD INDEX (TemplateAlias);

UPDATE Phrase SET PhraseType = 1 WHERE Phrase IN ('la_ToolTip_MoveUp', 'la_ToolTip_MoveDown', 'la_invalid_state', 'la_Pending', 'la_text_sess_expired', 'la_ToolTip_Export');
DELETE FROM Phrase WHERE Phrase IN ('la_ToolTip_Move_Up', 'la_ToolTip_Move_Down');
UPDATE Phrase SET Phrase = 'lu_btn_SendPassword' WHERE Phrase = 'LU_BTN_SENDPASSWORD';

ALTER TABLE Category DROP IsIndex;
DELETE FROM Phrase WHERE Phrase IN ('la_CategoryIndex', 'la_Container', 'la_fld_IsIndex', 'lu_text_Redirecting', 'lu_title_Redirecting', 'lu_zip_code');

ALTER TABLE PortalUser
	ADD AdminLanguage INT(11) NULL DEFAULT NULL,
	ADD INDEX (AdminLanguage);
