<?php
/**
* @version	$Id: themes_config.php 12883 2009-11-10 02:00:36Z dmitrya $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config =	Array(
					'Prefix'			=>	'theme',
					'ItemClass'			=>	Array('class'=>'ThemeItem','file'=>'theme_item.php','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'ThemesEventHandler','file'=>'themes_eh.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'ThemesTagProcessor','file'=>'themes_tag_processor.php','build_event'=>'OnBuild'),
					'AutoLoad'			=>	true,
					'Hooks'				=>	Array(),
					'QueryString'		=>	Array(
												1	=>	'id',
												2	=>	'Page',
												3	=>	'event',
												4	=>	'mode',
											),

					'IDField'			=>	'ThemeId',
					'StatusField'		=>	Array('Enabled', 'PrimaryTheme'),

					'PermSection'		=>	Array('main' => 'in-portal:configure_themes'),

					'Sections' => Array (
						'in-portal:configure_themes' => Array (
							'parent'		=>	'in-portal:website_setting_folder',
							'icon'			=>	'conf_themes',
							'label'			=>	'la_tab_Themes',
							'url'			=>	Array('t' => 'themes/themes_list', 'pass' => 'm'),
							'permissions'	=>	Array ('view', 'add', 'edit', 'delete'),
							'priority'		=>	5,
							'type'			=>	stTREE,
						),
					),

					'TitleField'		=>	'Name',

					'TitlePresets' => Array (
						'default' => Array (
							'new_status_labels' => Array('theme' => '!la_title_Adding_Theme!'),
							'edit_status_labels' => Array('theme' => '!la_title_Editing_Theme!'),
							'new_titlefield' => Array('theme' => '!la_title_NewTheme!'),
						),

						'themes_list' => Array(
							'prefixes' => Array('theme_List'), 'format' => "!la_tab_Themes!",
							'toolbar_buttons' => Array ('new_item', 'edit', 'delete', 'setprimary', 'refresh', 'view', 'dbl-click'),
							),

						'themes_edit_general' => Array(
							'prefixes' => Array('theme'), 'format' => "#theme_status# '#theme_titlefield#' - !la_title_General!",
							 'toolbar_buttons' => Array('select', 'cancel', 'prev', 'next'),
							),

						'themes_edit_files' => Array(
							'prefixes' => Array('theme', 'theme-file_List'), 'format' => "#theme_status# '#theme_titlefield#' - !la_title_ThemeFiles!",
							'toolbar_buttons' => Array('select', 'cancel', 'prev', 'next', 'view', 'dbl-click'),
							),

						'theme_file_edit' => Array (
							'prefixes' => Array ('theme', 'theme-file'),
							'new_status_labels' => Array ('theme-file' => '!la_title_AddingThemeFile!'),
							'edit_status_labels' => Array ('theme-file' => '!la_title_EditingThemeFile!'),
							'new_titlefield' => Array ('theme-file' => '!la_title_NewThemeFile!'),
							'format' => "#theme_status# '#theme_titlefield#' - #theme-file_status# '#theme-file_titlefield#'",
							'toolbar_buttons' => Array('select', 'cancel', 'reset_edit'),
						),

						'block_edit' => Array('prefixes' => Array('theme-file'), 'format' => "!la_title_EditingThemeFile! '#theme-file_titlefield#'"),
					),

					'EditTabPresets' => Array (
						'Default' => Array (
							'general' => Array ('title' => 'la_tab_General', 't' => 'themes/themes_edit', 'priority' => 1),
							'files' => Array ('title' => 'la_tab_Files', 't' => 'themes/themes_edit_files', 'priority' => 2),
						),
					),

					'TableName'			=>	TABLE_PREFIX.'Theme',
					'SubItems' => Array('theme-file'),

					'FilterMenu'		=>	Array(
												'Groups' => Array(
													Array('mode' => 'AND', 'filters' => Array(0,1), 'type' => WHERE_FILTER),
												),

												'Filters' => Array(
													0	=>	Array('label' =>'la_Enabled', 'on_sql' => '', 'off_sql' => '%1$s.Enabled != 1' ),
													1	=>	Array('label' => 'la_Disabled', 'on_sql' => '', 'off_sql' => '%1$s.Enabled != 0'  ),
												)
											),

					'AutoDelete'		=>	true,
					'AutoClone'			=>	true,

					'ListSQLs' => Array ('' => '	SELECT %1$s.* %2$s
													FROM %s
													LEFT JOIN '.TABLE_PREFIX.'Stylesheets st ON st.StylesheetId	= %1$s.StylesheetId'),

					'ItemSQLs' => Array ( '' => '	SELECT %1$s.* %2$s
													FROM %s
													LEFT JOIN '.TABLE_PREFIX.'Stylesheets st ON st.StylesheetId	= %1$s.StylesheetId'),

					'ListSortings' => Array (
						'' => Array(
							'Sorting' => Array('Name' => 'asc'),
						)
					),

					'CalculatedFields' => Array (
						'' => Array (
								'StyleName' => 'st.Name',
								'LastCompiled' => 'st.LastCompiled',
							),
					),

					'Fields' => Array(
										'ThemeId' => Array('type' => 'int', 'not_null' => 1, 'default' => 0),
										'Name' => Array('type' => 'string','not_null' => 1, 'required' => 1, 'default' => ''),
										'Enabled' => Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array(1=>'la_Active', 0=>'la_Disabled'), 'use_phrases'=>1, 'not_null' => 1, 'default' => 1),
										'Description' => Array('type' => 'string', 'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => null),
										'PrimaryTheme' => Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 0),
										'CacheTimeout' => Array('type' => 'int', 'not_null' => 1, 'default' => 0),
										'StylesheetId' => Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %s FROM '.TABLE_PREFIX.'Stylesheets', 'option_key_field' => 'StylesheetId', 'option_title_field' => 'Name', 'not_null' => 1, 'default' => 0),
										'LanguagePackInstalled' => Array (
											'type' => 'int',
											'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
											'not_null' => 1, 'default' => 0
										),
										'TemplateAliases' => Array ('type' => 'string', 'formatter' => 'kSerializedFormatter', 'default' => 'a:0:{}'),
								),

					'VirtualFields' => Array (
						'StyleName' => Array ('type' => 'string', 'default' => ''),
						'LastCompiled' => Array ('type' => 'int', 'default' => null),
					),

					'Grids'	=> Array(
						'Default' => Array(
							'Icons' => Array (
								'default' => 'icon16_item.png',
								'0_0' => 'icon16_disabled.png',
								'0_1' => 'icon16_disabled.png',
								'1_0' => 'icon16_item.png',
								'1_1' => 'icon16_primary.png',
							),
							'Fields' => Array(
								'ThemeId' => Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 50, ),
								'Name' => Array( 'title'=>'la_col_Name', 'filter_block' => 'grid_like_filter', 'width' => 200, ),
								'Description' => Array( 'title'=>'la_col_Description', 'filter_block' => 'grid_like_filter', 'width' => 250, ),
								'Enabled' => Array( 'title'=>'la_col_Status', 'filter_block' => 'grid_options_filter', 'width' => 200, ),
//								'PrimaryTheme' 	=> Array( 'title'=>'la_col_Primary', 'filter_block' => 'grid_options_filter'),
								'LanguagePackInstalled' => Array ('title' => 'la_col_LanguagePackInstalled', 'filter_block' => 'grid_options_filter', 'width' => 200,),
							),
						),
					),
	);