<?php
/**
* @version	$Id: theme_files_config.php 12734 2009-10-20 19:28:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config =	Array(
					'Prefix'			=>	'theme-file',
					'ItemClass'			=>	Array('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
					'ListClass'			=>	Array('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
					'EventHandlerClass'	=>	Array('class' => 'ThemeFileEventHandler', 'file' => 'theme_file_eh.php', 'build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class' => 'kDBTagProcessor', 'file' => '', 'build_event'=>'OnBuild'),
					'AutoLoad'			=>	true,

					'QueryString'		=>	Array(
												1	=>	'id',
												2	=>	'page',
												3	=>	'event',
											),

					'IDField'			=>	'FileId',

					'TitleField'		=>	'FileName',

					'TableName'			=>	TABLE_PREFIX.'ThemeFiles',

					'ForeignKey'		=>	'ThemeId',
					'ParentTableKey' 	=> 	'ThemeId',
					'ParentPrefix' 		=> 	'theme',
					'AutoDelete'		=>	true,
					'AutoClone'			=> 	true,

					'ListSQLs'			=>	Array(	'' => 'SELECT %1$s.* %2$s FROM %s'),
					'ItemSQLs'			=>	Array(	'' => 'SELECT %1$s.* %2$s FROM %s'),

					'ListSortings' => Array (
						'' => Array(
							'Sorting' => Array('FileName' => 'asc'),
						)
					),

					'Fields' => Array(
						'FileId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
						'ThemeId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
						'FileName' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
						'FilePath' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
						'Description' => Array ('type' => 'string', 'max_len' => 255, 'default' => NULL),
						'FileType' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
						'FileFound' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
						'FileMetaInfo' => Array ('type' => 'string', 'default' => NULL),
					),

					'VirtualFields' => Array (
						'FileContents' => Array ('type' => 'string', 'required' => 1, 'default' => ''),
						'BlockPosition' => Array ('type' => 'string', 'default' => ''),
					),

					'Grids' => Array (
						'Default' => Array (
							'Icons' => Array (
								'default' => 'icon16_item.png',
								0 => 'icon16_disabled.png',
								1 => 'icon16_item.png',
							),
							'Fields' => Array (
								'FileId' => Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 70, ),
								'FileName' 	=> Array( 'title'=>'la_col_FileName', 'width' => 150, ),
								'FilePath' => Array( 'title'=>'la_col_FilePath', 'width' => 300, ),
								'Description' 	=> Array( 'title'=>'la_col_Description', 'width' => 300, ),
							),

						),
					),
	);