String.prototype.trim = function() { return this.replace(/^\s+|\s+$/, ''); };

function update_checkbox(cb, cb_hidden) {
	cb_hidden.value = cb.checked ? 1 : 0;
}

function redirect($url) {
	window.location.href = $url;
}

function open_window($url, $window_name, $width, $height) {
	window.open($url, $window_name, 'width='+$width+',height='+$height+',resizable=yes');
	return false;
}

function addLoadEvent(func, wnd) {
	if (!wnd) wnd = window
	var oldonload = wnd.onload;
	if (typeof wnd.onload != 'function') {
		wnd.onload = func;
	} else {
		wnd.onload = function() {
			if (oldonload) {
				oldonload();
			}
			func();
		}
	}
}

function addEvent(el, evname, func, traditional) {
	if (traditional) {
		eval('el.on'+evname+'='+func);
		return;
	}

	if (document.all) {
		el.attachEvent("on" + evname, func);
	} else {
		el.addEventListener(evname, func, true);
	}
};

// ItemCategories class
function ItemCategories($table_id, $field_id, $primary_category, $phrases) {
	this.CategoryTable = document.getElementById($table_id);
	this.CategorySelector = document.getElementById($field_id + '_select');
	this.MoreCategoriesField = document.getElementById($field_id);
	this.PrimaryCategory = $primary_category;
	this.Phrases = $phrases;

	// get additional categories from item
	if (this.MoreCategoriesField.value.length) {
		this.MoreCategories = this.MoreCategoriesField.value;
		this.MoreCategories = this.MoreCategories.substring(1, this.MoreCategories.length - 1).split('|');
	}
	else {
		this.MoreCategories = new Array ();
	}
}

ItemCategories.prototype.AddCategory = function($separator, $delete_button, $max_categories) {
	var $category_id = this.CategorySelector.options[this.CategorySelector.selectedIndex].value;
	var $category_name = this.CategorySelector.options[this.CategorySelector.selectedIndex].innerHTML.trim();

	if ((this.SearchCategory($category_id) !== false) || ($category_id == this.PrimaryCategory) || ($category_id == 0)) {
		// don't add same category twice & don't allow to add item's primary category
		alert(this.Phrases[1]);
		return ;
	}

	if ((this.MoreCategories.length + 2) > $max_categories)
	{
		// don't add more category - $max_categories limit
		alert(this.Phrases[0]);
		return ;
	}

	// strip trailing HTML spaces & separator
	var $separator_pos = $category_name.indexOf($separator);
	if ($separator_pos != -1) {
		$category_name = $category_name.substring($separator_pos + $separator.length);
	}


	var $row = this.CategoryTable.insertRow(-1);
	$row.id = 'category_' + $category_id;

	var $cell = $row.insertCell(-1);
	$cell.innerHTML = $category_name;

	$cell = $row.insertCell(-1);
	$cell.innerHTML = $delete_button.replace(/#CATEGORY_ID#/g, $category_id);

	this.MoreCategories.push($category_id);
	this.updateMoreCategoriesField();
}

ItemCategories.prototype.SearchCategory = function($category_id) {
	var $i = 0;
	while ($i < this.CategoryTable.rows.length) {
		if (this.CategoryTable.rows[$i].id == 'category_' + $category_id) {
			return $i;
		}
		$i++;
	}

	return false;
}

ItemCategories.prototype.DeleteCategory = function($category_id) {
	var $row_index = this.SearchCategory($category_id);

	if ($row_index !== false) {
		this.CategoryTable.deleteRow($row_index);
		var $i = 0;
		while ($i < this.MoreCategories.length) {
			if (this.MoreCategories[$i] == $category_id) {
				this.MoreCategories.splice($i, 1);
				break;
			}
			$i++;
		}
		this.updateMoreCategoriesField();
	}
}

ItemCategories.prototype.updateMoreCategoriesField = function() {
	this.MoreCategoriesField.value = this.MoreCategories.length ? '|' + this.MoreCategories.join('|') + '|' : '';
}

function jq($selector) {
	return $selector.replace(/(\[|\]|\.|:)/g, '\\$1');
}

function MultiLanguageSelector($language_info, $current_language) {
	this._languageInfo = $language_info;
	this._currentLanguage = $current_language;
	this._controls = new Array ();

	var $me = this;

	$(document).ready(
		function() {
			$me.init();
		}
	);
}

MultiLanguageSelector.prototype.init = function () {
	var $i = 0;
	var $me = this;

	while ($i < this._controls.length) {
		// set current language
		$( jq('#' + this._controls[$i]) ).data('PrevLanguage', this._currentLanguage);

		for (var $language_id in this._languageInfo) {
			var $id = this.inputForLanguage(this._controls[$i], $language_id);

			$( jq('#' + $id + '_flag') ).each(
				function() {
					$(this)
					.data('MainControl', $me._controls[$i])
					.data('ThisLanguage', $language_id)
					.click(
						function ($event) {
							var $this_flag = $(this);
							var $this_language = $this_flag.data('ThisLanguage');

							var $main_control = $('#' + jq($this_flag.data('MainControl')) );

							var $prev_language = $main_control.data('PrevLanguage');
							var $prev_flag = $( jq('#' + $me.inputForLanguage($main_control.attr('id'), $prev_language) + '_flag') );

							var $language_info;

							if ($this_language != $prev_language) {
								// hide prev language input + enable it's flag
								var $prev_image = $prev_flag.children('img:first');
								if ($prev_image.length) {
									// found image for given language
									$language_info = $me._languageInfo[$prev_language];
									$prev_image.attr('src', $prev_image.attr('src').replace($language_info.off, $language_info.on));
								}
								$( jq('#' + $prev_flag.attr('id').replace(/_flag$/, '_input') ) ).hide();

								// show this language input + disable it's flag
								var $this_image = $this_flag.children('img:first');
								if ($this_image.length) {
									// found image for given language
									$language_info = $me._languageInfo[$this_language];
									$this_image.attr('src', $this_image.attr('src').replace($language_info.on, $language_info.off));
								}
								var $this_container = $( jq('#' + $this_flag.attr('id').replace(/_flag$/, '_input') ) );
								$this_container.show();

								// focus on shown control
								$('input:first, textarea:first', $this_container).focus();

								// remember last used language
								$main_control.data('PrevLanguage', $this_language);
							}

							$event.preventDefault();
						}
					);
				}
			);
		}

		$i++;
	}
}

MultiLanguageSelector.prototype.inputForLanguage = function ($control_id, $language_id) {
	return $control_id.replace('l' + this._currentLanguage + '_', 'l' + $language_id + '_');
}

MultiLanguageSelector.prototype.registerControl = function ($id) {
	this._controls.push($id);
}

