<?php
/**
* @version	$Id: session_log_eh.php 12299 2009-08-17 01:51:27Z dmitrya $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class SessionLogEventHandler extends kDBEventHandler {

		/**
		 * Opens log for new session
		 *
		 * @param kEvent $event
		 */
		function OnStartSession(&$event)
		{
			if (!$this->Application->ConfigValue('UseChangeLog')) {
				// don't use session log when change log is disabled
				return ;
			}

			$object =& $this->Application->recallObject($event->Prefix, null, Array ('skip_autoload' => 1));
			/* @var $object kDBItem */

			$fields_hash = Array (
				'SessionStart' => adodb_mktime(),
				'IP' => $_SERVER['REMOTE_ADDR'],
				'PortalUserId' => $this->Application->RecallVar('user_id'),
				'SessionId' => $this->Application->GetSID(),
				'Status' => 0,
			);

			$object->SetDBFieldsFromHash($fields_hash);

			$object->UpdateFormattersSubFields();

			if ($object->Create()) {
				$this->Application->StoreVar('_SessionLogId_', $object->GetID());
			}
		}

		/**
		 * Closes log for current session
		 *
		 * @param kEvent $event
		 */
		function OnEndSession(&$event)
		{
			$object =& $this->Application->recallObject($event->Prefix, null, Array ('skip_autoload' => 1));
			/* @var $object kDBItem */

			$object->Load($this->Application->RecallVar('_SessionLogId_'));
			if (!$object->isLoaded()) {
				return ;
			}

			$fields_hash = Array (
				'SessionEnd' => adodb_mktime(),
				'Status' => 1,
			);

			$object->SetDBFieldsFromHash($fields_hash);

			$object->UpdateFormattersSubFields();
			$object->Update();
		}

	}