<?php
/**
* @version	$Id: user_groups_eh.php 12511 2009-09-15 19:27:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class UserGroupsEventHandler extends kDBEventHandler {

		/**
		 * Adds user as member for selected groups
		 *
		 * @param kEvent $event
		 */
		function OnProcessSelected(&$event)
		{
			if ($event->Prefix == 'u-ug') {
			$new_groups = $this->Application->GetVar('g');
			if (!$new_groups) {
				return ;
			}

			$new_groups = array_keys($new_groups);

			// don't insert duplicate group membership record
			$user_id = $this->Application->GetVar('u_id');
			$table_name = $this->Application->GetTempName(TABLE_PREFIX.'UserGroup', 'prefix:u');
			$sql = 'SELECT GroupId
					FROM '.$table_name.'
					WHERE PortalUserId = '.(int)$user_id;
			$old_groups = $this->Conn->GetCol($sql);

			$new_groups = array_diff($new_groups, $old_groups);
			if ($new_groups) {
				foreach ($new_groups as $new_group) {
					$fields_hash = Array (
						'GroupId'		=>	$new_group,
						'PortalUserId'	=>	$user_id,
						'PrimaryGroup'	=>	0,
					);
					$this->Conn->doInsert($fields_hash, $table_name);
				}
			}
			}
			if ($event->Prefix == 'g-ug') {
				$new_users = $this->Application->GetVar('u');
				if (!$new_users) {
					return ;
				}

				$new_users = array_keys($new_users);

				// don't insert duplicate group membership record
				$group_id = $this->Application->GetVar('g_id');
				$table_name = $this->Application->GetTempName(TABLE_PREFIX.'UserGroup', 'prefix:g');
				$sql = 'SELECT PortalUserId
						FROM ' . $table_name . '
						WHERE GroupId = ' . (int)$group_id;
				$old_users = $this->Conn->GetCol($sql);

				$new_users = array_diff($new_users, $old_users);
				if ($new_users) {
					foreach ($new_users as $new_user) {
						$fields_hash = Array (
							'GroupId'		=>	$group_id,
							'PortalUserId'	=>	$new_user,
							'PrimaryGroup'	=>	0,
						);
						$this->Conn->doInsert($fields_hash, $table_name);
					}
				}
			}

			$this->Application->StoreVar($this->Application->GetTopmostPrefix($event->Prefix).'_modified', '1');
			$event->SetRedirectParam('opener', 'u');
		}

		/**
		 * Sets primary group for user (in editing only)
		 *
		 * @param kEvent $event
		 */
		function OnSetPrimary(&$event)
		{
			$ids = $this->StoreSelectedIDs($event);
			if ($ids) {
				$id = array_shift($ids);
				$object =& $event->getObject( Array('skip_autoload' => true) );
				$user_id = $this->Application->GetVar('u_id');

				$sql = 'UPDATE ' . $object->TableName . '
						SET PrimaryGroup = 0
						WHERE PortalUserId = ' . (int)$user_id;
				$this->Conn->Query($sql);

				$sql = 'UPDATE ' . $object->TableName . '
						SET PrimaryGroup = 1
						WHERE ' . $object->IDField . ' = ' . $id . ' AND PortalUserId = ' . (int)$user_id;
				$this->Conn->Query($sql);
			}

			$this->clearSelectedIDs($event);
		}

		/**
		 * Don't allow primary group record deleting
		 *
		 * @param kEvent $event
		 */
		function customProcessing(&$event, $type)
		{
			if ($event->Name == 'OnMassDelete' && $type == 'before') {
				$ids = $event->getEventParam('ids');
				if ($ids) {
					$object =& $event->getObject( Array('skip_autoload' => true) );

					if ($event->Prefix == 'u-ug') {
					$user_id = $this->Application->GetVar('u_id');
					$sql = 'SELECT '.$object->IDField.'
							FROM '.$object->TableName.'
							WHERE '.$object->IDField.' IN ('.implode(',', $ids).') AND PortalUserId = '.(int)$user_id.' AND PrimaryGroup = 0';
					$ids = $this->Conn->GetCol($sql);
					}
					elseif ($event->Prefix == 'g-ug') {
						$group_id = $this->Application->GetVar('g_id');
						$sql = 'SELECT '.$object->IDField.'
								FROM '.$object->TableName.'
								WHERE '.$object->IDField.' IN ('.implode(',', $ids).') AND GroupId = '.(int)$group_id.' AND PrimaryGroup = 0';
						$ids = $this->Conn->GetCol($sql);
					}
					$event->setEventParam('ids', $ids);
				}
			}
		}

	}