<?php
/**
* @version	$Id: stop_words_config.php 12495 2009-09-15 04:09:10Z dmitrya $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'stop-word',
		'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'kDBEventHandler', 'file' => '', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'kDBTagProcessor', 'file' => '', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'event',
			4 => 'mode',
		),

		'IDField' => 'StopWordId',

		'TableName' => TABLE_PREFIX.'StopWords',

		'TitleField' => 'StopWord',

		'TitlePresets' => Array (
			'default' => Array (
				'new_status_labels' => Array ('stop-word' => '!la_title_AddingStopWord!'),
				'edit_status_labels' => Array ('stop-word' => '!la_title_EditingStopWord!'),
			),

			'stop_word_list' => Array (
				'prefixes' => Array ('stop-word_List'), 'format' => "!la_title_StopWords!",
				'toolbar_buttons' => Array ('new_item', 'edit', 'delete', 'view', 'dbl-click'),
			),

			'stop_word_edit' => Array (
				'prefixes' => Array ('stop-word'), 'format' => "#stop-word_status# '#stop-word_titlefield#'",
				'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
			),
		),

		'PermSection' => Array('main' => 'in-portal:stop_words'),

		'Sections' => Array (
			'in-portal:stop_words' => Array (
				'parent'		=>	'in-portal:website_setting_folder',
				'icon'			=>	'conf_stopwords',
				'label'			=>	'la_title_StopWords',
				'url'			=>	Array('t' => 'stop_words/stop_word_list', 'pass' => 'm'),
				'permissions'	=>	Array('view', 'add', 'edit', 'delete'),
				'priority'		=>	8,
				'type'			=>	stTREE,
			),
		),

		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s FROM %1$s',
		),

		'ListSortings' => Array (
			'' => Array (
				'Sorting' => Array ('StopWord' => 'asc'),
			)
		),

		'Fields' => Array (
			'StopWordId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'StopWord' => Array ('type' => 'string', 'unique' => Array (), 'max_len' => 255, 'required' => 1, 'not_null' => 1, 'default' => ''),
		),

		'Grids' => Array (
			'Default' => Array (
				'Icons' => Array (
					'default' => 'icon16_item.png',
					0 => 'icon16_disabled.png',
					1 => 'icon16_item.png',
				),
				'Fields' => Array (
					'StopWordId' => Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 70, ),
					'StopWord' => Array ('title' => 'la_col_StopWord', 'filter_block' => 'grid_like_filter', 'width' => 250, ),
				),
			),
		),
	);