<?php
/**
* @version	$Id: constants.php 12299 2009-08-17 01:51:27Z dmitrya $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	// kDBList filter types (then, types are divided into classes)
	define('HAVING_FILTER', 1);
	define('WHERE_FILTER', 2);
	define('AGGREGATE_FILTER', 3);

	// kDBList filter classes
	define('FLT_SYSTEM',	1);	// System Having/Where filter [AND]
	define('FLT_NORMAL',	2);	// User Having/Where filter [OR]
	define('FLT_SEARCH',	3);	// User "Search" Having/Where filter [OR]
	define('FLT_VIEW',		4);	// User "View Menu" Having/Where filter [AND]
	define('FLT_CUSTOM',	5); // Custom fields (above) grid columns [AND]

	// kMultipleFilter types
	define('FLT_TYPE_AND',	'AND');
	define('FLT_TYPE_OR',	'OR');

	// item statuses
	define('STATUS_DISABLED', 0);
	define('STATUS_ACTIVE', 1);
	define('STATUS_PENDING', 2);
	define('STATUS_PENDING_EDITING', -2);

	// sections
	define('stTREE', 1);
	define('stTAB', 2);

	// event statuses
	define('erSUCCESS',		0);		// event finished working succsessfully
	define('erFAIL',		-1);	// event finished working, but result is unsuccsessfull
	define('erFATAL',		-2);	// event experienced FATAL error - no hooks should continue!
	define('erPERM_FAIL',	-3);	// event failed on internal permission checking (user has not permission)
	define('erSTOP',		-4);	// event requested to stop processing (don't parse templates)

	// permission types
	define('ptCATEGORY', 	0);
	define('ptSYSTEM', 		1);

	// email event types
	define('EVENT_TYPE_FRONTEND', 0);
	define('EVENT_TYPE_ADMIN', 1);

	define('EDIT_MARK', '&|edit|&'); // replace this sequence inside filters to SID[_main_wid]

	$application =& kApplication::Instance();
	$spacer_url = $application->BaseURL().'core/admin_templates/img/spacer.gif';
	define('SPACER_URL', $spacer_url);

	if (!$application->IsAdmin()) {
		// don't show debugger buttons on front (if not overrided in "debug.php")
		safeDefine('DBG_TOOLBAR_BUTTONS', 0);
	}

	define('smHIDE', 0); // always hide section from tree
	define('smNORMAL', 1); // show section even, if they were marked as smDEBUG or smSUPER_ADMIN before
	define('smDEBUG', 2); // show section in debug mode only
	define('smSUPER_ADMIN', 4); // show section in super admin & debug mode

	// common usage regular expressions
	define('REGEX_EMAIL_USER', '[-a-zA-Z0-9!\#$%&*+\/=?^_`{|}~.]+');
	define('REGEX_EMAIL_DOMAIN', '[a-zA-Z0-9]{1}[-.a-zA-Z0-9_]*\.[a-zA-Z]{2,6}');
	define('ALLOW_DEFAULT_SETTINGS', '_USE_DEFAULT_USER_DATA_'); //Allow persistent vars to take data from default user's persistent data

	define('XML_NO_TEXT_NODES', 1); // Normal mode for XMLHelper
	define('XML_WITH_TEXT_NODES', 2); // Will create text nodes for every char-data (used in kPDFHelper)

	// ChangeLog actions
	define('clCREATE', 1);
	define('clUPDATE', 2);
	define('clDELETE', 3);

	/**
	 * Separator for ValueList fields
	 *
	 */
	define('VALUE_LIST_SEPARATOR', '||');

	// template editing modes
	define('EDITING_MODE_BROWSE', 1); // no changes, front-end as users see it
	define('EDITING_MODE_CONTENT', 2); // content blocks + phrase editing
	define('EDITING_MODE_DESIGN', 3); // all other blocks

	// agent types
	define('AGENT_TYPE_USER', 1);
	define('AGENT_TYPE_SYSTEM', 2);

	// agent last run statuses
	define('AGENT_LAST_RUN_SUCCEDED', 1);
	define('AGENT_LAST_RUN_FAILED', 0);
	define('AGENT_LAST_RUN_RUNNING', 2);

	// place for product file uploads (sort of "/system/images" but for all other files)
	define('ITEM_FILES_PATH', WRITEBALE_BASE . '/downloads/');

	// mailing list statuses
	define('MAILING_LIST_NOT_PROCESSED', 1);
	define('MAILING_LIST_PARTIALLY_PROCESSED', 2);
	define('MAILING_LIST_PROCESSED', 3);
	define('MAILING_LIST_CANCELLED', 4);

	// theme file statuses (related to structure creation process)
	define('SMS_MODE_AUTO', 1);
	define('SMS_MODE_FORCE', 2);

	/**
	 * Means, that actual category Template field value should inherited from parent category
	 *
	 */
	define('CATEGORY_TEMPLATE_INHERIT', '#inherit#');

	define('REWRITE_MODE_BUILD', 1);
	define('REWRITE_MODE_PARSE', 2);