<?php
/**
* @version	$Id: languages_tag_processor.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

	class LanguagesTagProcessor extends kDBTagProcessor
	{

		/**
		 * Guesses what charset should be used:
		 * 1. use lang.current_Field field="Charset" by default
		 * 2. if using temp tables then use lang_Field field="Charset"
		 *
		 * @param Array $params
		 * @return string
		 */
		function GetCharset($params)
		{
			$edit_direct = $this->Application->GetVar('phrases_label');

			$top_prefix = $this->Application->GetTopmostPrefix($this->Prefix);
			if( substr($this->Application->GetVar($top_prefix.'_mode'), 0, 1) == 't' && !$edit_direct )
			{
				$object =& $this->getObject();
				return $object->GetDBField('Charset');
			}
			$lang_current =& $this->Application->recallObject('lang.current');
			return $lang_current->GetDBField('Charset');
		}

		/**
		 * Returns formatted date + time on current language
		 *
		 * @param Array $params
		 * @return string
		 */
		function CurrentDate($params)
		{
			$format = $params['format'];
			$date = adodb_mktime() + $this->Application->TimeZoneAdjustment();

			if (strpos($format, 'l') !== false) {
				$week_day = $this->Application->Phrase('lu_weekday_'.adodb_date('l'));
				$format = str_replace('l', '#@#', $format); // replace with reserved char (preserves translation link)

				return str_replace('#@#', $week_day, adodb_date($format, $date));
			}

			return adodb_date($format, $date);
		}

		function ListLanguages($params)
		{
			$this->Special = 'enabled';
			return $this->PrintList2($params);
		}

		function LanguageName($params)
		{
			$object =& $this->getObject($params);
			return $this->Application->Phrase($params['phrase_prefix'].$object->GetDBField('PackName'));
		}

		function LanguageLink($params)
		{
			$object =& $this->getObject($params);

			$params['m_lang'] = $object->GetID();

			return $this->Application->ProcessParsedTag('m', 'Link', $params);
		}

		function SelectedLanguage($params)
		{
			$object =& $this->getObject($params);
			return $object->GetDBField('LanguageId') == $this->Application->GetVar('m_lang');
		}

		/**
		 * Returns path where exported languages should be saved
		 *
		 * @param unknown_type $params
		 */
		function ExportPath($params)
		{

			$ret = EXPORT_PATH.'/';

			if( getArrayValue($params,'as_url') )
			{
				$ret = str_replace( FULL_PATH.'/', $this->Application->BaseURL(), $ret);
			}
			return $ret;
		}

		/**
		 * Returns true if system has more then 1 language installed
		 *
		 * @param Array $params
		 * @return bool
		 */
		function IsMultiLanguage($params)
		{
			return $this->TotalRecords($params) > 1;
		}

		function IsPrimaryLanguage($params)
		{
			return $this->Application->GetDefaultLanguageId() == $this->Application->GetVar('m_lang');
		}

/*		function Main_IsMetricUnits($params)
		{
			$object =& $this->Application->recallObject($this->Prefix.'.current');
			$measure_system = $object->GetDBField('UnitSystem');
			return $measure_system == 1 ? 1 : 0;
		}*/

	}

?>