<?php
/**
* @version	$Id: groups_event_handler.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

	class GroupsEventHandler extends kDBEventHandler {

		/**
		 * Adds grouping by userid
		 *
		 * @param kEvent $event
		 */
		function SetCustomQuery(&$event)
		{
			$object =& $event->getObject();
			/* @var $object kDBList */

			switch ($event->Special) {
				case 'user':
					$user_id = $this->Application->GetVar('u_id');
					if ($user_id !== false) {
						// show only groups, that user doesn't belong to
						$table_name = $this->Application->GetTempName(TABLE_PREFIX.'UserGroup', 'prefix:u');
						$sql = 'SELECT GroupId
								FROM '.$table_name.'
								WHERE PortalUserId = '.$user_id;
						$group_ids = $this->Conn->GetCol($sql);
						array_push($group_ids, 14, 15); // Guest & Everyone groups are set dynamically

						$object->addFilter('already_member_filter', '%1$s.GroupId NOT IN ('.implode(',', $group_ids).')');
					}
					break;
			}
		}
	}

?>