<?php
	/* Libchart - PHP chart library
	 * Copyright (C) 2005-2007 Jean-Marc Tr�meaux (jm.tremeaux at gmail.com)
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 */

	/**
	 * Color palette shared by all chart types.
	 *
	 * @author Jean-Marc Tr�meaux (jm.tremeaux at gmail.com)
	 * Created on 25 july 2007
	 */
	class LibchartPalette {
		public $red;
		public $axisColor;
		public $aquaColor;

		public $barColorSet;
		public $lineColorSet;
		public $pieColorSet;

		/**
		 * Palette constructor.
		 */
		public function LibchartPalette() {
			$this->red = new LibchartColor(255, 0, 0);

			// Colors for the horizontal and vertical axis
			$this->axisColor = array(
					new LibchartColor(201, 201, 201),
					new LibchartColor(158, 158, 158)
			);

			// Colors for the background
			$this->aquaColor = array(
					new LibchartColor(242, 242, 242),
					new LibchartColor(231, 231, 231),
					new LibchartColor(239, 239, 239),
					new LibchartColor(253, 253, 253)
			);

			// Colors for the bars
			$this->barColorSet = new LibchartColorSet(array(
					new LibchartColor(42, 71, 181),
					new LibchartColor(243, 198, 118),
					new LibchartColor(128, 63, 35),
					new LibchartColor(128, 63, 35),
					new LibchartColor(195, 45, 28),
					new LibchartColor(224, 198, 165),
					new LibchartColor(239, 238, 218),
					new LibchartColor(40, 72, 59),
					new LibchartColor(71, 112, 132),
					new LibchartColor(167, 192, 199),
					new LibchartColor(218, 233, 202)
			), 0.75);

			// Colors for the lines
			$this->lineColorSet = new LibchartColorSet(array(
					new LibchartColor(172, 172, 210),
					new LibchartColor(2, 78, 0),
					new LibchartColor(148, 170, 36),
					new LibchartColor(233, 191, 49),
					new LibchartColor(240, 127, 41),
					new LibchartColor(243, 63, 34),
					new LibchartColor(190, 71, 47),
					new LibchartColor(135, 81, 60),
					new LibchartColor(128, 78, 162),
					new LibchartColor(121, 75, 255),
					new LibchartColor(142, 165, 250),
					new LibchartColor(162, 254, 239),
					new LibchartColor(137, 240, 166),
					new LibchartColor(104, 221, 71),
					new LibchartColor(98, 174, 35),
					new LibchartColor(93, 129, 1)
			), 0.75);

			// Colors for the pie
			$this->pieColorSet = new LibchartColorSet(array(
				new LibchartColor(2, 78, 0),
				new LibchartColor(148, 170, 36),
				new LibchartColor(233, 191, 49),
				new LibchartColor(240, 127, 41),
				new LibchartColor(243, 63, 34),
				new LibchartColor(190, 71, 47),
				new LibchartColor(135, 81, 60),
				new LibchartColor(128, 78, 162),
				new LibchartColor(121, 75, 255),
				new LibchartColor(142, 165, 250),
				new LibchartColor(162, 254, 239),
				new LibchartColor(137, 240, 166),
				new LibchartColor(104, 221, 71),
				new LibchartColor(98, 174, 35),
				new LibchartColor(93, 129, 1)
			), 0.7);
		}
	}
?>