<?php
/**
* @version	$Id: email_events_config.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

$config	=	Array(
					'Prefix'			=>	'emailevents',
					'ItemClass'			=>	Array('class'=>'kDBItem','file'=>'','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'EmailEventsEventsHandler','file'=>'email_events_event_handler.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'kDBTagProcessor','file'=>'','build_event'=>'OnBuild'),
					'AutoLoad'			=>	true,

					'QueryString'		=>	Array(
												1	=>	'id',
												2	=>	'page',
												3	=>	'event',
											),

					'IDField'			=>	'EventId',

					'StatusField'		=>	Array('Enabled'),

					'TitleField'		=>	'Event',

					'TitlePresets'		=>	Array(
												'email_settings_list' => Array('prefixes'	=> Array('emailevents.module_List'), 'format' => '!la_title_EmailSettings!'),

												'email_send_form' => Array('prefixes' => Array(), 'format' => '!la_title_SendEmail!'),
												'email_prepare' => Array('prefixes' => Array(), 'format' => '!la_title_PreparingEmailsForSending!. !la_title_PleaseWait!'),
												'email_send' => Array('prefixes' => Array(), 'format' => '!la_title_SendingPreparedEmails!. !la_title_PleaseWait!'),
												'email_send_complete' => Array('prefixes' => Array(), 'format' => '!la_title_SendMailComplete!'),
											),

					'PermSection'		=>	Array('main' => 'in-portal:configure_lang'),

					'FilterMenu'		=>	Array(
												'Groups' => Array(
													Array('mode' => 'AND', 'filters' => Array('show_enabled','show_disabled','show_frontonly'), 'type' => WHERE_FILTER),
												),
												'Filters' => Array(
													'show_enabled'	=>	Array('label' =>'la_Enabled', 'on_sql' => '', 'off_sql' => '%1$s.Enabled != 1' ),
													'show_disabled'	=>	Array('label' => 'la_Disabled', 'on_sql' => '', 'off_sql' => '%1$s.Enabled != 0'  ),
													'show_frontonly'	=>	Array('label' => 'la_Text_FrontOnly', 'on_sql' => '', 'off_sql' => '%1$s.Enabled != 2'  ),
												)
											),

					'TableName'			=>	TABLE_PREFIX.'Events',

					'CalculatedFields' => Array(
								'' => Array (
										'FromUser'	=>	'u.Login',
									)
								),

					'ListSQLs'			=>	Array(	''=>'	SELECT %1$s.* %2$s
															FROM %1$s
															LEFT JOIN '.TABLE_PREFIX.'PortalUser u ON %1$s.FromUserId = u.PortalUserId',
											), // key - special, value - list select sql),

					'ItemSQLs'			=>	Array(	''=>'SELECT * FROM %s'),

					'ListSortings'	=> 	Array(
												'' 			=>	Array('Sorting' => Array('Module' => 'asc', 'Description'	=> 'asc') ),

												'module'	=>	Array('Sorting'	=> Array('Description'	=> 'asc') ),
										),

					'Fields'			=>	Array(
													'EventId' => Array('type' => 'int', 'not_null' => 1, 'default' => 0),
										            'Event' => Array('type' => 'string','not_null' => '1','default' => ''),
										            'ReplacementTags' => Array ('type' => 'string', 'default' => NULL),
										            'Enabled' => Array('type'=>'int', 'formatter'=>'kOptionsFormatter', 'options' => Array(1 => 'la_Enabled', 0 => 'la_Disabled', 2 => 'la_Text_FrontOnly'), 'use_phrases' => 1, 'default' => 1, 'not_null' => 1),
										            'FromUserId' => Array('type' => 'int', 'formatter' => 'kLEFTFormatter', 'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'), 'options' => Array(-1=>'root'), 'left_sql' => 'SELECT %s FROM '.TABLE_PREFIX.'PortalUser WHERE `%s` = \'%s\'', 'left_key_field' => 'PortalUserId', 'left_title_field' => 'Login', 'required'=>1, 'not_null' => 1, 'default' => -1),
										            'Module' => Array('type' => 'string','not_null' => '1','default' => ''),
										            'Description' => Array('type' => 'string','not_null' => '1','default' => ''),
										            'Type' => Array('type' => 'int', 'formatter'=>'kOptionsFormatter', 'options' => Array (1 => 'la_Text_Admin', 0 => 'la_Text_User'), 'use_phrases' => 1, 'default' => 0, 'not_null' => 1),
									        ),
					'VirtualFields'		=>	Array(
													'FromUser'	=>	Array(),
											),

					'Grids'	=> Array(
						'Default' => Array (
							'Icons' => Array('default'=>'icon16_custom.gif'),
							'Fields' => Array(
								'EventId' => Array('title' => 'la_col_Id', 'filter_block' => 'grid_range_filter'),
								'Description'	=>	Array( 'title'=>'la_col_Description', 'data_block' => 'label_grid_checkbox_td', 'filter_block' => 'grid_like_filter'),
								'Event'			=>	Array( 'title'=>'la_col_Event', 'filter_block' => 'grid_like_filter'),
								'Module'		=>	Array( 'title'=>'la_col_Module', 'filter_block' => 'grid_like_filter'),
								'Type'			=>	Array( 'title'=>'la_col_Type', 'filter_block' => 'grid_options_filter'),
								'Enabled'		=>	Array( 'title'=>'la_col_Status', 'filter_block' => 'grid_options_filter'),
							),
						),

						'EmailSettings' => Array (
							'Icons' => Array('default'=>'icon16_custom.gif'),
							'Fields' => Array(
								'EventId' => Array('title' => 'la_col_Id', 'filter_block' => 'grid_range_filter'),
								'Description' => Array('title'=>'la_col_Description', 'data_block' => 'label_grid_checkbox_td' ),
		            			'Type' => Array('title'=>'la_col_Type', 'filter_block' => 'grid_options_filter'),
								'Enabled' => Array('title'=>'la_col_Status', 'filter_block' => 'grid_options_filter'),
		            			'FromUser' => Array('title'=>'la_col_FromToUser', 'filter_block' => 'grid_like_filter'),
							),
						),
					),
	);