<?php
/**
* @version	$Id: category_items_event_handler.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

	class CategoryItemsEventHander extends kDBEventHandler
	{

		/**
		 * Setting language dependant navbar as calculated field
		 *
		 * @param kEvent $event
		 */
		function SetCustomQuery(&$event)
		{
			$object =& $event->getObject();

			$ml_formatter =& $this->Application->recallObject('kMultiLanguage');
			$object->addCalculatedField('CategoryName', 'c.'.$ml_formatter->LangFieldName('CachedNavbar'));
		}

		/**
		 * Set's new category as primary for product
		 *
		 * @param kEvent $event
		 */
		function OnSetPrimary(&$event)
		{
			$object =& $event->getObject( Array('skip_autoload' => true) );
			$ids = $this->StoreSelectedIDs($event);

			if($ids)
			{
				$id = array_shift($ids);
				$table_info = $object->getLinkedInfo();

				$this->Conn->Query('UPDATE '.$object->TableName.' SET PrimaryCat = 0 WHERE '.$table_info['ForeignKey'].' = '.$table_info['ParentId']);
				$this->Conn->Query('UPDATE '.$object->TableName.' SET PrimaryCat = 1 WHERE ('.$table_info['ForeignKey'].' = '.$table_info['ParentId'].') AND (CategoryId = '.$id.')');
			}
			$event->redirect_params = Array('opener' => 's'); //stay!
		}

		/**
		 * Apply custom processing to item
		 *
		 * @param kEvent $event
		 */
		function customProcessing(&$event, $type)
		{
			if($event->Name == 'OnMassDelete')
			{
				$object =& $event->getObject();
				$table_info = $object->getLinkedInfo();

				switch ($type)
				{
					case 'before':
						$ids = $event->getEventParam('ids');
						if($ids)
						{
							$ids = $this->Conn->GetCol('SELECT CategoryId FROM '.$object->TableName.' WHERE (PrimaryCat=0) AND ('.$table_info['ForeignKey'].'='.$table_info['ParentId'].') AND CategoryId IN ('.implode(',',$ids).')');
							$event->setEventParam('ids',$ids);
						}
						break;

						// not needed because 'before' does not allow to delete primary cat!
					/*case 'after':
						// set 1st not deleted category as primary
						$has_primary = $this->Conn->GetOne('SELECT COUNT(*) FROM '.$object->TableName.' WHERE (PrimaryCat=1) AND ('.$table_info['ForeignKey'].' = '.$table_info['ParentId'].')');
						if(!$has_primary)
						{
							$cat_id = $this->Conn->GetOne('SELECT CategoryId FROM '.$object->TableName.' WHERE '.$table_info['ForeignKey'].' = '.$table_info['ParentId']);
							$this->Conn->Query('UPDATE '.$object->TableName.' SET PrimaryCat = 1 WHERE ('.$table_info['ForeignKey'].' = '.$table_info['ParentId'].') AND (CategoryId = '.$cat_id.')');
						}
						break;*/
				}
			}
		}

		/**
		 * Removes primary mark from cloned category items record
		 *
		 * @param kEvent $event
		 */
		function OnAfterClone(&$event)
		{
			$id = $event->getEventParam('id');
			$table = $this->Application->getUnitOption($event->Prefix, 'TableName');
			$id_field = $this->Application->getUnitOption($event->Prefix, 'IDField');
			$sql = 'UPDATE %s SET PrimaryCat = 0 WHERE %s = %s';

			$this->Conn->Query( sprintf($sql, $table, $id_field, $id) );
		}

		/**
		 * Deletes items of requested type from requested categories.
		 * In case if item is deleted from it's last category, then delete item too.
		 *
		 * @param kEvent $event
		 */
		function OnDeleteFromCategory(&$event)
		{
			$category_ids = $event->getEventParam('category_ids');
			if(!$category_ids) return false;

			$item_prefix = $event->getEventParam('item_prefix');
			$item =& $this->Application->recallObject($item_prefix.'.-item', null, Array('skip_autoload' => true));

			$ci_table = $this->Application->getUnitOption($event->Prefix, 'TableName');
			$item_table = $this->Application->getUnitOption($item_prefix, 'TableName');

			$sql = 'SELECT ItemResourceId, CategoryId FROM %1$s INNER JOIN %2$s ON (%1$s.ResourceId = %2$s.ItemResourceId) WHERE CategoryId IN (%3$s)';
			$category_items = $this->Conn->Query( sprintf($sql, $item_table, $ci_table, implode(',', $category_ids) ) );

			$item_hash = Array();
			foreach($category_items as $ci_row)
			{
				$item_hash[ $ci_row['ItemResourceId'] ][] = $ci_row['CategoryId'];
			}

			foreach($item_hash as $item_resource_id => $delete_category_ids)
			{
				$item->Load($item_resource_id, 'ResourceId');
				$item->DeleteFromCategories($delete_category_ids);
			}
		}

	}

?>