<?php
/**
* @version	$Id: categories_item.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

	class CategoriesItem extends kDBItem
	{
		function Create($force_id = false, $system_create = false)
		{
			$this->checkFilename();
			$this->generateFilename();

			if ($this->Validate()) {
				// TODO: such approach will not respect changes from CategoryEventHandler::OnBeforeItemCreate event
				$this->SetDBField('ResourceId', $this->Application->NextResourceId());
			}

			// TODO: move to CategoryEventHandler::OnBeforeItemCreate
			$this->SetDBField('CreatedById', $this->Application->RecallVar('user_id') );
			$this->SetDBField('CreatedOn_date', adodb_mktime() );
			$this->SetDBField('CreatedOn_time', adodb_mktime() );

			$parent_category = $this->GetDBField('ParentId') > 0 ? $this->GetDBField('ParentId') : $this->Application->GetVar('m_cat_id');
			$this->SetDBField('ParentId', $parent_category);

			$ret = parent::Create($force_id, $system_create);

			if ($ret) {
				// TODO: move to CategoryEventHandler::OnAfterItemCreate method
				$sql = 'UPDATE %s SET ParentPath = %s WHERE CategoryId = %s';
				$parent_path = $this->buildParentPath();
				$this->Conn->Query( sprintf($sql, $this->TableName, $this->Conn->qstr($parent_path), $this->GetID() ) );

				$this->SetDBField('ParentPath', $parent_path);
			}

			return $ret;

		}

		function Update($id=null, $system_update = false)
		{
			$this->checkFilename();
			$this->generateFilename();

			return parent::Update($id, $system_update);
		}

		function buildParentPath()
		{
			$parent_id = $this->GetDBField('ParentId');

			if ($parent_id == 0) {
				$parent_path = '|';
			}
			else {
				$cat_table = $this->Application->getUnitOption($this->Prefix, 'TableName');
				$sql = 'SELECT ParentPath FROM '.$cat_table.' WHERE CategoryId = %s';
				$parent_path = $this->Conn->GetOne( sprintf($sql, $parent_id) );
			}

			return $parent_path.$this->GetID().'|';
		}

		/**
		 * replace not allowed symbols with "_" chars + remove duplicate "_" chars in result
		 *
		 * @param string $string
		 * @return string
		 */
		function stripDisallowed($string)
		{
			$filenames_helper =& $this->Application->recallObject('FilenamesHelper');
			/* @var $filenames_helper kFilenamesHelper */

			$string = $filenames_helper->replaceSequences($string);

			return $this->checkAutoFilename($string);
		}

		function checkFilename()
		{
			if ($this->GetDBField('AutomaticFilename')) {
				// filename will be generated from scratch, don't check anything here
				return ;
			}
			elseif ($this->GetDBField('IsSystem')) {
				// system page with AutomaticFilename checkbox unchecked -> compatibility with Proj-CMS <= 4.3.9 (when "/" were allowed in Filename)
				return ;
			}

			$filename = $this->GetDBField('Filename');
			$this->SetDBField('Filename', $this->stripDisallowed($filename));
		}

		function checkAutoFilename($filename)
		{
			if(!$filename) return $filename;

			$escape_char = $this->Application->ConfigValue('FilenameSpecialCharReplacement');

			$item_id = !$this->GetID() ? 0 : $this->GetID();
			$check_in_parent_cat_only = $item_id ? ' AND ParentId = '.$this->GetDBField('ParentId') : '';

			// check temp table
			$sql_temp = 'SELECT '.$this->IDField.' FROM '.$this->TableName.' WHERE Filename = '.$this->Conn->qstr($filename).$check_in_parent_cat_only;
			$found_temp_ids = $this->Conn->GetCol($sql_temp);

			// check live table
			$sql_live = 'SELECT '.$this->IDField.' FROM '.$this->Application->GetLiveName($this->TableName).' WHERE Filename = '.$this->Conn->qstr($filename).$check_in_parent_cat_only;
			$found_live_ids = $this->Conn->GetCol($sql_live);

			$found_item_ids = array_unique( array_merge($found_temp_ids, $found_live_ids) );

			$has_page = preg_match('/(.*)_([\d]+)([a-z]*)$/', $filename, $rets);

			$duplicates_found = (count($found_item_ids) > 1) || ($found_item_ids && $found_item_ids[0] != $item_id);
			if ($duplicates_found || $has_page) // other category has same filename as ours OR we have filename, that ends with _number
			{
				$append = $duplicates_found ? $escape_char . 'a' : '';
				if($has_page)
				{
					$filename = $rets[1].'_'.$rets[2];
					$append = $rets[3] ? $rets[3] : $escape_char . 'a';
				}

				// check live & temp table
				$sql_temp = 'SELECT '.$this->IDField.' FROM '.$this->TableName.' WHERE (Filename = %s) AND ('.$this->IDField.' != '.$item_id.')';
				$sql_live = 'SELECT '.$this->IDField.' FROM '.$this->Application->GetLiveName($this->TableName).' WHERE (Filename = %s) AND ('.$this->IDField.' != '.$item_id.')';
				while ( $this->Conn->GetOne( sprintf($sql_temp, $this->Conn->qstr($filename.$append)) ) > 0 ||
				$this->Conn->GetOne( sprintf($sql_live, $this->Conn->qstr($filename.$append)) ) > 0 )
				{
					if (mb_substr($append, -1) == 'z') $append .= 'a';
					$append = mb_substr($append, 0, mb_strlen($append) - 1) . chr( ord( mb_substr($append, -1) ) + 1 );
				}

				return $filename.$append;
			}

			return $filename;
		}

		/**
		 * Generate item's filename based on it's title field value
		 *
		 * @return string
		 */
		function generateFilename()
		{
			if ( !$this->GetDBField('AutomaticFilename') && $this->GetDBField('Filename') ) return false;

			$ml_formatter =& $this->Application->recallObject('kMultiLanguage');
			$name = $this->stripDisallowed( $this->GetDBField( $ml_formatter->LangFieldName('Name', true) ) );

			if ( $name != $this->GetDBField('Filename') ) $this->SetDBField('Filename', $name);
		}

		/**
		 * Allows to detect if root category being edited
		 *
		 * @param Array $params
		 */
		function IsRoot()
		{
			return $this->Application->RecallVar('IsRootCategory_'.$this->Application->GetVar('m_wid'));
		}

		/**
		 * Sets correct name to Home category while editing it
		 *
		 * @return bool
		 */
		function IsNewItem()
		{
			if ($this->IsRoot() && $this->Prefix == 'c') {
				$title_field = $this->Application->getUnitOption($this->Prefix, 'TitleField');
				$category_name = $this->Application->Phrase( $this->Application->ConfigValue('Root_Name') );
				$this->SetDBField($title_field, $category_name);
				return false;
			}
			return parent::IsNewItem();
		}

		/**
	 	* Sets new name for item in case if it is beeing copied
	 	* in same table
	 	*
	 	* @param array $master Table data from TempHandler
		 * @param int $foreign_key ForeignKey value to filter name check query by
		 * @access private
		 */
		function NameCopy($master=null, $foreign_key=null)
		{
			$title_field = $this->Application->getUnitOption($this->Prefix, 'TitleField');
			if (!$title_field || isset($this->CalculatedFields[$title_field]) ) return;

			$new_name = $this->GetDBField($title_field);
			$cat_id = $this->Application->GetVar('m_cat_id');
			$this->SetDBField('ParentId', $cat_id);
			$original_checked = false;
			do {
				if ( preg_match('/Copy ([0-9]*) *of (.*)/', $new_name, $regs) ) {
					$new_name = 'Copy '.($regs[1]+1).' of '.$regs[2];
				}
				elseif ($original_checked) {
					$new_name = 'Copy of '.$new_name;
				}

				// if we are cloning in temp table this will look for names in temp table,
				// since object' TableName contains correct TableName (for temp also!)
				// if we are cloning live - look in live
				$query = 'SELECT '.$title_field.' FROM '.$this->TableName.'
									WHERE ParentId = '.$cat_id.' AND '.$title_field.' = '.$this->Conn->qstr($new_name);

				$foreign_key_field = getArrayValue($master, 'ForeignKey');
				$foreign_key_field = is_array($foreign_key_field) ? $foreign_key_field[ $master['ParentPrefix'] ] : $foreign_key_field;

				if ($foreign_key_field && isset($foreign_key)) {
					$query .= ' AND '.$foreign_key_field.' = '.$foreign_key;
				}

				$res = $this->Conn->GetOne($query);

				/*// if not found in live table, check in temp table if applicable
				if ($res === false && $object->Special == 'temp') {
					$query = 'SELECT '.$name_field.' FROM '.$this->GetTempName($master['TableName']).'
										WHERE '.$name_field.' = '.$this->Conn->qstr($new_name);
					$res = $this->Conn->GetOne($query);
				}*/

				$original_checked = true;
			} while ($res !== false);
			$this->SetDBField($title_field, $new_name);
		}
	}

?>