<?php
/**
* @version	$Id: tags.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

define ('parse', 0);
define ('skip', 1);
define ('skip_tags', 2);

class MyTagHolder extends kBase {

	var $_Tag;

	function MyTagHolder()
	{

	}

	function &GetTag($tag_data, &$parser, $inp_tag = 0)
	{
		if (!isset($this->_Tag)) {
			$this->_Tag = new Tag($tag_data, $parser, $inp_tag);
		}
		else {
//				$this->_Tag->Parser =& $parser;
			$this->_Tag->TagData = $tag_data;
			if ($tag_data != '') $this->_Tag->ParseTagData($tag_data);
			$this->_Tag->NP =& $this->_Tag->NamedParams;
		}
		$this->_Tag->TemplateName = $parser->TemplateName;
		return $this->_Tag;
	}

}

class Tag extends kBase {
	var $Processor;
	var $Tag;
	var $Params = Array();
	var $NamedParams = Array();
	var $NP;
	var $TemplateName;
	/**
	 * Enter description here...
	 *
	 * @var TemplateParser
	 */
	var $Parser;
	var $TagData = '';

	function Tag($tag_data, &$parser, $inp_tag=0)
	{
		parent::kBase();
		$this->Parser =& $parser;
		$this->TagData = $tag_data;
		if ($tag_data != '') $this->ParseTagData($tag_data);
		$this->NP =& $this->NamedParams;
	}

	function CopyFrom(&$tag)
	{
		$this->Processor = $tag->Processor;
		$this->Tag = $tag->Tag;
		$this->TagData = $tag->TagData;
		$this->Params = $tag->Params;
		$this->NamedParams = $tag->NamedParams;
		$this->Parser =& $tag->Parser;
		$this->TemplateName = $tag->TemplateName;
	}

	function GetFullTag()
	{
		return '<%'.$this->TagData.'%>';
	}

	function RebuildTagData()
	{
		$res = $this->Processor.':'.$this->Tag.' ';
		foreach ($this->NamedParams as $name => $value) {
			$res .= "$name='$value' ";
		}
		return $res;
	}

	/**
	 * Escape chars in phrase translation, that could harm parser to process tag
	 *
	 * @param string $text
	 * @return string
	 * @access private
	 */
	function EscapeReservedChars($text)
	{
		$reserved = Array('"',"'"); // =
		$replacement = Array('\"',"\'"); // \=
		return str_replace($reserved,$replacement,$text);
	}


	function ReplaceParams($tag_data)
	{
		//print_pre($this->Parser->Pattern, $tag_data);
		$values = $this->Parser->Values;
		foreach($values as $param_name => $param_value)
		{
			$values[$param_name] = $this->EscapeReservedChars($param_value);
		}

		if (is_array($this->Parser->Params)) {
			$tag_data = preg_replace($this->Parser->Pattern, $values, $tag_data);
		}
		//echo "got: $tag_data<br>";
		return $tag_data;
	}

	function PreParseReplaceParams($tag_data)
	{
		//print_pre($this->Parser->Pattern, $tag_data);
		$values = $this->Parser->Values;
		foreach($values as $param_name => $param_value)
		{
			$values[$param_name] = $this->EscapeReservedChars($param_value);
		}

		/*$patterns = Array();
		if ( is_array($this->Parser->Args) ) {
			foreach ($this->Parser->Args as $arg) {

			}
		}*/

		if ($this->Parser->SkipMode == parse) {
			if (is_array($this->Parser->Params)) {
				$tag_data = preg_replace($this->Parser->Pattern, $values, $tag_data);
			}
		}
		//echo "got: $tag_data<br>";
		return $tag_data;
	}

	function CmpParams($a, $b)
	{
		$a_len = strlen($a);
		$b_len = strlen($b);
		if ($a_len == $b_len) return 0;
		return $a_len > $b_len ? -1 : 1;
	}

	/**
	 * Set's Prefix and Special for Tag object
	 * based on ones from tagname
	 *
	 * @param string $tag_data
	 * @access protected
	 */
	function ParseTagData($tag_data)
	{
		if (defined('EXPERIMENTAL_PRE_PARSE') ) {
			$this->OriginalTagData = $tag_data;
			$tag_data = $this->PreParseReplaceParams($tag_data) . ' ';
		}
		else {
			$tag_data = $this->ReplaceParams($tag_data) . ' ';
//			$tag_data = $this->Application->ReplaceLanguageTags($tag_data);
		}

		list ($key_data, $params) = split("[ \t\n]{1}", $tag_data, 2);
		$key_data = trim($key_data);

		$tmp=explode(':',$key_data);
		$this->Tag=$tmp[1];

		$tmp=$this->Application->processPrefix($tmp[0]);
		$this->Prefix=$tmp['prefix'];
		$this->Special=$tmp['special'];
		$this->Processor=$this->Prefix;

		if ($params != '') {
			$this->ParseNamedParams($params);
		}
		else {
			$this->NamedParams = array();
		}
	}

	function ParseNamedParams($params_str)
	{
		$params = new Params($params_str);
		$this->NamedParams = $params->_Params;
	}

	function GetParam($param)
	{
		if (isset($this->NP[$param]))
			return $this->NP[$param];
		else
			return false;
	}

	/**
	 * Process IF tags in specific way
	 *
	 */
	function Process()
	{
		$short_closing =  false;
		if (isset($this->NP['_short_closing_'])) {
			unset($this->NP['_short_closing_']);
			$this->TagData = str_replace(' _short_closing_="1"', '', $this->TagData);
			$short_closing = true;
		}
		if ($this->Processor == 'm' || $this->Processor == 'm_TagProcessor') { //if we are procssing Main tags
			if ($this->Tag == 'block' || $this->Tag == 'DefineElement' || ($this->Tag == 'RenderElement' && $short_closing)) {
				$tag = new BlockTag('', $this->Parser);
				$tag->CopyFrom($this);
				$tag->Process();
			}
			elseif($this->Tag == 'Capture') {
				$tag = new CaptureTag('', $this->Parser);
				$tag->CopyFrom($this);
				$tag->Process();
			}
			elseif ($this->Parser->SkipMode == skip_tags) {
				return;
			}
			elseif (
				$this->Tag == 'if' ||
				$this->Tag == 'ifnot' ||
				$this->Tag == 'else' ||
				$this->Tag == 'elseif'
				)
			{
				if ( defined('EXPERIMENTAL_PRE_PARSE') ) {
					$this->Parser->AppendCompiledCode( $this->GetCode() );
				}
				$tag = new ConstructTag('', $this->Parser);
				$tag->CopyFrom($this);
				$tag->Process();
			}
			else {
				if ($this->Parser->SkipMode == skip) {
					if ( defined('EXPERIMENTAL_PRE_PARSE') ) {
						$this->Parser->AppendCompiledCode( $this->GetCode() );
					}
					return;
				}
				$this->ProcessTag();
				if ( defined('EXPERIMENTAL_PRE_PARSE') ) {
					$this->Parser->AppendCompiledCode( $this->GetCode() );
				}
			}
		}
		else { //normal tags - processors other than main
			if ($this->Parser->SkipMode == skip) { // inside if - add statements inside if to compiled code
				if ( defined('EXPERIMENTAL_PRE_PARSE') ) {
					$this->Parser->AppendCompiledCode( $this->GetCode() );
				}
				return;
			}
			elseif ($this->Parser->SkipMode == skip_tags) return; //do not parse if we skipping tags
			$this->ProcessTag();
			if ( defined('EXPERIMENTAL_PRE_PARSE') ) {
				$this->Parser->AppendCompiledCode( $this->GetCode() );
			}
		}
	}

	/**
	 * Set's Prefix and Special for TagProcessor
	 * based on tag beeing processed
	 *
	 * @return string
	 * @access protected
	 */
	function DoProcessTag()
	{
		// $tag->Prefix - l_TagProcessor
		$tmp = $this->Application->processPrefix($this->Processor);

		if (isset($this->NamedParams['_ignore_missing_'])) {
			if (!$this->Application->prefixRegistred($tmp['prefix'])) return '';
		}

		$processor =& $this->Application->recallObject($tmp['prefix'].'_TagProcessor'); // $this->Processor

		$tmp=explode('_',$tmp['prefix'],2);
		$processor->Prefix=$tmp[0];
		$processor->Special=$this->Special;

		// pass_params for non ParseBlock tags :)
		$parser_params = $this->Application->Parser->Params;
		if( getArrayValue($this->NamedParams,'pass_params') )
		{
			unset( $this->NamedParams['pass_params'] );
			$this->NamedParams = array_merge_recursive2($parser_params, $this->NamedParams);
		}

		return $processor->ProcessTag($this);
	}

	function ProcessTag()
	{
		$o = $this->DoProcessTag();
		if ($o !== false)
		{
			$this->Parser->AppendOutput($o);
		}
		else
		{
			trigger_error('can\'t process tag '.$this->Tag.' in '.$this->Prefix,E_USER_WARNING);
		}
	}

	function GetCode($echo=false)
	{
		$tmp_params = $this->NamedParams;
		$splited = split("[ \t\n]{1}", $this->OriginalTagData, 2);
		if (isset($splited[1]) && $splited[1]) {
			$this->ParseNamedParams($splited[1]);
		}
		$pass_params = $this->NamedParams;
		$this->NamedParams = $tmp_params;

		$code = Array();

		$to_pass = 'Array(';
		foreach ($pass_params as $name => $val) {
			$to_pass .= '"'.$name.'" => "'.str_replace('"', '\"', $val).'",';
		}
		$to_pass .= ')';

		if ($echo) $code[] = '$o = '."'';\n";

		switch ( strtolower($this->Tag) ) {
			case 'defaultparam':
				foreach ($this->NP as $key => $val)	{
					$code[] = 'if (!isset($'.$key.')) $application->Parser->SetParam(\''.$key.'\', \''.$val.'\');';
					$code[] = '$'.$key.' = isset($'.$key.') ? $'.$key.' : \''.$val.'\';';
				}
				return $code;
			case 'param':
			case 'Param':
				$code[] = 'if (isset($application->LateParsed["'.$this->NP['name'].'"])) {';
					$code[] = '$__f = $application->PreParsedBlocks[\'capture_'.$this->NP['name'].'\'];';
					$code[] = '$application->Parser->SetParam(\''.$this->NP['name'].'\', $__f($params)'.');'; // array()
					$code[] = '$'.$this->NP['name'].' = $application->Parser->GetParam(\''.$this->NP['name'].'\');';
					$code[] = '$params[\''.$this->NP['name'].'\'] = $'.$this->NP['name'].';';
				$code[] = '}';
				$code[] = '$p =& $application->recallObject(\'m_TagProcessor\');';
				$code[] = '$tag_params = '.$to_pass.';';
				$param_code = '$o .= $p->PostProcess($params["'.$this->NP['name'].'"], $p->PreparePostProcess($tag_params))';
				if (isset($this->NP['plus'])) {
					$param_code .= ' + '.$this->NP['plus'];
				}
				$code[] = $param_code.';';
				return $code;
			case 'if':
				if (isset($this->NP['_closing_tag_'])) {
					$code[] = ' }';
				}
				else {
					$check = isset($pass_params['check']) && $pass_params['check'] ? $pass_params['check'] : false; // $this->GetParam('check');
					if ($check) {
						if (strpos($check, '_') !== false) {
							list($prefix, $function) = explode('_', $check, 2);
						}
						else {
							$function = $check;
							$prefix = '$PrefixSpecial'; // $this->Parser->GetParam('PrefixSpecial');
						}
					}
					else {
						$prefix = $pass_params['prefix']; // $this->GetParam('prefix');
						$function = $pass_params['function']; // $this->GetParam('function');
					}

					$code[] = '$tmp = $application->processPrefix("'.$prefix.'");'."\n";
					$code[] = '$__tp = $tmp[\'prefix\'].\'_TagProcessor\';'."\n";
					$code[] = '$p =& $application->recallObject($__tp);'."\n";
					$code[] = '$p->Prefix = $tmp[\'prefix\'];'."\n";
					$code[] = '$p->Special = $tmp[\'special\'];'."\n";
					$code[] = '$if_result = $p->ProcessParsedTag(\''.$function.'\', '.$to_pass.', "'.$prefix.'");'."\n";
					if (isset($pass_params['inverse'])) {
						$code[] = 'if (!$if_result) {';
					}
					else {
						$code[] = 'if ($if_result) {';
					}
				}
				return $code;

			case 'endif':
				$code[] = ' }';
				return $code;

			case 'else':
				$code[] = ' }';
				$code[] = ' else {';
				return $code;
		}

		/* $tmp_pref = $this->getPrefixSpecial();
		$tmp = $this->Application->processPrefix($tmp_pref);
		$tmp_processor = $tmp['prefix'].'_TagProcessor';
		if (strpos($tmp['prefix'], '$') !== false) {
			$processor_to_check = '{'.$tmp['prefix'].'}_TagProcessor';
		}
		else {
			$processor_to_check = $tmp_processor;
		}  */

		if (isset($this->NamedParams['_auto_prefix_'])) {
			$prefix = '$PrefixSpecial';
		}
		else {
			// use original prefix_special found in templates (parameter names in form $ParamName found in it will not be replaced with values)
			list ($prefix, $tag) = explode(':', $splited[0], 2); //$prefix = $this->getPrefixSpecial();

			if (isset($this->NamedParams['_ignore_missing_'])) {
				if (!$this->Application->prefixRegistred($prefix)) return array();
			}
		}

		$code[] = '$tmp = $application->processPrefix("'.$prefix.'");'."\n";

		/*if (!isset($this->Application->CompilationCache[$this->getPrefixSpecial()])) {
			$code[] = '$tmp = $application->processPrefix("'.$this->getPrefixSpecial().'");'."\n";
			$code[] = '$__tp = $tmp[\'prefix\'].\'_TagProcessor\';'."\n";
			$code[] = '$application->CachedProcessors["'.$this->getPrefixSpecial().'"] =& $application->recallObject($__tp);'."\n";
			$this->Application->CompilationCache[$this->getPrefixSpecial()] = true;

			if (strpos($tmp_pref, '$') === false) {
				$this->Application->CachedProcessors[$this->getPrefixSpecial()] =& $this->Application->recallObject($tmp_processor);
			}
		}

		$this->Parser->UsedProcessors[] = $tmp['prefix'];*/
		$code[] = '$__tp = $tmp[\'prefix\'].\'_TagProcessor\';'."\n";
		$code[] = '$p =& $application->recallObject($__tp);'."\n";
		$code[] = '$p->Prefix = $tmp[\'prefix\'];'."\n";
		$code[] = '$p->Special = $tmp[\'special\'];'."\n";

		$tag_func = $this->Tag;
		if ($tag_func == 'include') $tag_func = 'MyInclude';

//		$code[] = '$o .= $application->CachedProcessors["'.$this->getPrefixSpecial().'"]->ProcessParsedTag(\''.$tag_func.'\', '.$to_pass.', "'.$this->Processor.'");'."\n";

		$code[] = '$o .= $p->ProcessParsedTag(\''.$tag_func.'\', '.$to_pass.', "'.$prefix.'");'."\n"; // $this->Processor

		/*$code = '	$processor =& $application->recallObject(\''.$this->Processor.'_TagProcessor\');
				 	$o .= $processor->ProcessParsedTag(\''.$this->Tag.'\', unserialize(\''.serialize($this->NP).'\'));';*/

		if (isset($pass_params['result_to_var'])) {
			$code[] = '$'.$pass_params['result_to_var'].' = $application->Parser->GetParam(\''.$pass_params['result_to_var'].'\');';
			$code[] = '$params[\''.$pass_params['result_to_var'].'\'] = $'.$pass_params['result_to_var'].';';
			$echo = false;
		}

		if ($echo) $code[] = ' echo $o;'."\n";

		return $code;
		//return '$o .= \'tag:'. $this->Tag .'\'';
	}
}

?>