<?php
/**
* @version	$Id: selectors_config.php 11902 2009-07-15 01:07:23Z dmitrya $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

	$config	=	Array(
					'Prefix'			=>	'selectors',
					'ItemClass'			=>	Array('class'=>'SelectorsItem','file'=>'selectors_item.php','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'SelectorsEventHandler','file'=>'selectors_event_handler.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'SelectorsTagProcessor','file'=>'selectors_tag_processor.php','build_event'=>'OnBuild'),
					'AutoLoad'			=>	true,

					'Clones'		=>	Array(
												'selectorsbase'	=>	Array(
																			'Hooks'		=>	Array(),
																			'Constrain' => 'Type = 1',
																			'SubItems'	=>	Array('selectorsblock'),
																	),

												'selectorsblock'	=>	Array(
																				'Hooks'				=>	Array(),
																				'Constrain'			=>	'Type = 2',
																				'ForeignKey' 		=> 	Array('css' => 'StylesheetId', 'selectorsbase' => 'ParentId'),
																				'ParentTableKey' 	=> 	Array('css' => 'StylesheetId', 'selectorsbase' => 'SelectorId'),
																				'ParentPrefix'		=>	'selectorsbase',
																	),
											),

					'Hooks'	=>	Array(
												Array(
													'Mode' => hAFTER,
													'Conditional' => false,
													'HookToPrefix' => 'selectors',
													'HookToSpecial' => '',
													'HookToEvent' => Array('OnItemBuild'),
													'DoPrefix' => '',
													'DoSpecial' => '',
													'DoEvent' => 'OnPrepareBaseStyles',
												),

												Array(
													'Mode' => hAFTER,
													'Conditional' => false,
													'HookToPrefix' => 'selectors',
													'HookToSpecial' => 'block',
													'HookToEvent' => Array('OnListBuild'),
													'DoPrefix' => '',
													'DoSpecial' => 'block',
													'DoEvent' => 'OnPrepareBaseStyles',
												),
											),

					'MyHooks'	=>	Array(
											Array(
													'Mode'			=>	hAFTER,
													'Conditional'	=>	false,
													'HookToPrefix'	=>	Array('Prefix1.*', 'Prefix2.Special1'),
													'HookToEvents'	=>	Array('OnBeforeItemUpdate', 'OnBeforeItemCreate'),
													'DoPrefix'		=>	Array('Prefix1.*', 'Prefix2.Special1'),
													'DoEvent'		=>	'OnMyEvent',
											),
									),

					'QueryString'		=>	Array(
												1	=>	'id',
												2	=>	'page',
												3	=>	'event',
											),
					'IDField'			=>	'SelectorId',

					'TitleField'		=>	'Name',

					'TableName'			=>	TABLE_PREFIX.'StylesheetSelectors',

					'ForeignKey'		=>	'StylesheetId',
					'ParentTableKey' 	=> 	'StylesheetId',
					'ParentPrefix' 		=> 	'css',
					'AutoDelete'		=>	true,
					'AutoClone'			=>	true,

					'ListSQLs'			=>	Array(	''=>'	SELECT %1$s.*
															FROM %s',
																		), // key - special, value - list select sql
					'ItemSQLs'			=>	Array(	''=>'SELECT * FROM %s',
																		),
					'ListSortings'	=> 	Array(
																'' => Array(
																	'Sorting' => Array('Name' => 'asc'),
																)
															),
					'Fields' => Array(
										'SelectorId' => Array('type' => 'int', 'not_null' => 1, 'default' => 0),
										'StylesheetId' => Array('type' => 'int', 'unique'=>Array('SelectorName'), 'current_table_only' => 1, 'not_null' => 1, 'default' => 0),
										'Name' => Array('type' => 'string','not_null' => '1','default' => '','required'=>1),
										'SelectorName' => Array('type' => 'string', 'unique'=>Array('StylesheetId'), 'current_table_only' => 1, 'not_null' => '1','default' => '','required'=>1),
										'SelectorData' => Array('type' => 'string', 'not_null' => '1','default' => ''),
										'Description' => Array('type' => 'string', 'formatter' => 'kFormatter', 'not_null' => 1, 'using_fck' => 1, 'default' => ''),
										'Type' => Array('type' => 'int', 'formatter'=>'kOptionsFormatter', 'options'=>Array( 1 => 'la_BaseSelectors', 2 => 'la_BlockSelectors'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 0),
										'AdvancedCSS' => Array('type' => 'string', 'formatter' => 'kFormatter', 'not_null' => 1, 'using_fck' => 1, 'default' => ''),
										'ParentId' => Array('type' => 'int', 'formatter'=>'kOptionsFormatter', 'required' => 1, 'not_null' => 1, 'default' => 0),
								),

					'VirtualFields'	=> 	Array(
												'FontStyle' => Array('type'=>'string', 'formatter'=>'kOptionsFormatter', 'options'=>Array(''=>'','inherit'=>'inherit','normal'=>'normal','italic'=>'italic','oblique'=>'oblique'), 'default'=>'' ),
												'FontWeight' => Array('type'=>'string', 'formatter'=>'kOptionsFormatter', 'options'=>Array(''=>'','inherit'=>'inherit','100'=>'100','200'=>'200','300'=>'300','normal'=>'normal','500'=>'500','600'=>'600','bold'=>'bold','800'=>'800','900'=>'900','lighter'=>'lighter','bolder'=>'bolder') ),
												'StyleCursor' => Array('type'=>'string', 'formatter'=>'kOptionsFormatter', 'options'=>Array(''=>'','inherit'=>'inherit','default'=>'default','auto'=>'auto','n-resize'=>'n-resize','ne-resize'=>'ne-resize','e-resize'=>'e-resize','se-resize'=>'se-resize','s-resize'=>'s-resize','sw-resize'=>'sw-resize','w-resize'=>'w-resize','nw-resize'=>'nw-resize','crosshair'=>'crosshair','pointer'=>'pointer','move'=>'move','text'=>'text','wait'=>'wait','help'=>'help','hand'=>'hand','all-scroll'=>'all-scroll','col-resize'=>'col-resize','row-resize'=>'row-resize','no-drop'=>'no-drop','not-allowed'=>'not-allowed','progress'=>'progress','vertical-text'=>'vertical-text','alias'=>'alias','cell'=>'cell','copy'=>'copy','count-down'=>'count-down','count-up'=>'count-up','count-up-down'=>'count-up-down','grab'=>'grab','grabbing'=>'grabbing','spinning'=>'spinning') ),
												'StyleDisplay' => Array('type'=>'string', 'formatter'=>'kOptionsFormatter', 'options'=>Array(''=>'','inherit'=>'inherit','none'=>'none','inline'=>'inline','block'=>'block','inline-block'=>'inline-block','list-item'=>'list-item','marker'=>'marker','compact'=>'compact','run-in'=>'run-in','table-header-group'=>'table-header-group','table-footer-group'=>'table-footer-group','table'=>'table','inline-table'=>'inline-table','table-caption'=>'table-caption','table-row'=>'table-row','table-row-group'=>'table-row-group','table-column'=>'table-column','table-column-group'=>'table-column-group') ),
												'TextAlign' => Array('type'=>'string', 'formatter'=>'kOptionsFormatter', 'options'=>Array(''=>'','inherit'=>'inherit','left'=>'left','right'=>'right','center'=>'center','justify'=>'justify') ),
												'TextDecoration' => Array('type'=>'string', 'formatter'=>'kOptionsFormatter', 'options'=>Array(''=>'','inherit'=>'inherit','none'=>'none','underline'=>'underline','overline'=>'overline','line-through'=>'line-through','blink'=>'blink') ),
												'StyleVisibility' => Array('type'=>'string', 'formatter'=>'kOptionsFormatter', 'options'=>Array(''=>'','inherit'=>'inherit','visible'=>'visible','hidden'=>'hidden','collapse'=>'collapse') ),
												'StylePosition' => Array('type'=>'string', 'formatter'=>'kOptionsFormatter', 'options'=>Array(''=>'','inherit'=>'inherit','static'=>'static','relative'=>'relative','absolute'=>'absolute','fixed'=>'fixed') ),
										),

					'Grids'	=> Array(
						'Default' => Array(
							'Icons' => Array(
								'default'=>'icon16_selector.gif'),
								'Fields' => Array(
									'Name' => Array( 'title'=>'la_col_Name', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_like_filter'),
									'SelectorName' 	=> Array( 'title'=>'la_col_SelectorName', 'filter_block' => 'grid_like_filter'),
									'Description' => Array( 'title'=>'la_col_Description', 'data_block' => 'grid_description_td', 'filter_block' => 'grid_like_filter'),
									),
							),

						'BlockStyles' => Array(
							'Icons' => Array('default'=>'icon16_selector.gif'),
							'Fields' => Array(
								'Name' => Array( 'title'=>'la_col_Name', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_like_filter'),
								'SelectorName' 	=> Array( 'title'=>'la_col_SelectorName', 'filter_block' => 'grid_like_filter'),
								'Description' => Array( 'title'=>'la_col_Description', 'data_block' => 'grid_description_td', 'filter_block' => 'grid_like_filter'),
								'ParentId'		=>	Array('title'=>'la_col_Basedon', 'filter_block' => 'grid_options_filter'),
								),
							),
						),
	);

?>