<?php
/**
* @version	$Id: css_defaults.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

class kCSSDefaults {
	public static $DEFAULT_STYLE = 
	 'html, address,
		blockquote,
		body, dd, div,
		dl, dt, fieldset, form,
		frame, frameset,
		h1, h2, h3, h4,
		h5, h6, noframes,
		ol, p, ul, center,
		dir, hr, menu, pre, footer   { display: block }
		li              { display: list-item }
		head            { display: none }
		table           { display: table }
		tr              { display: table-row }
		thead           { display: table-header-group }
		tbody           { display: table-row-group }
		tfoot           { display: table-footer-group }
		col             { display: table-column }
		colgroup        { display: table-column-group }
		td, th          { display: table-cell }
		caption         { display: table-caption }
		th              { font-weight: bolder; text-align: center }
		caption         { text-align: center }
		body            { margin: 8px }
		
		h1              { font-size: 2em; margin: .67em 0 }
		h2              { font-size: 1.5em; margin: .75em 0 }
		h3              { font-size: 1.17em; margin: .83em 0 }
		h4, p,
		blockquote, ul,
		fieldset, form,
		ol, dl, dir,
		menu            { margin: 1.12em 0 }
		h5              { font-size: .83em; margin: 1.5em 0 }
		h6              { font-size: .75em; margin: 1.67em 0 }
		h1, h2, h3, h4,
		h5, h6, b,
		strong          { font-weight: bolder }
		blockquote      { margin-left: 40px; margin-right: 40px }
		i, cite, em,
		var, address    { font-style: italic }
		pre, tt, code,
		kbd, samp       { font-family: monospace }
		pre             { white-space: pre }
		button, textarea,
		input, select   { display: inline-block }
		big             { font-size: 1.17em }
		small, sub, sup { font-size: .83em }
		sub             { vertical-align: sub }
		sup             { vertical-align: super }
		table           { border-spacing: 2px; }
		thead, tbody,
		tfoot           { vertical-align: middle }
		td, th          { vertical-align: middle }
		s, strike, del  { text-decoration: line-through }
		hr              { border: 1px inset; }
		ol, ul, dir,
		menu, dd        { margin-left: 40px }
		ol              { list-style-type: decimal }
		ol ul, ul ol,
		ul ul, ol ol    { margin-top: 0; margin-bottom: 0 }
		u, ins          { text-decoration: underline }
		br:before       { content: "\A" }
		:before, :after { white-space: pre-line }
		center          { text-align: center }
		:link, :visited { text-decoration: underline }
		:focus          { outline: thin dotted invert }
		
		/* Begin bidirectionality settings (do not change) */
		BDO[DIR="ltr"]  { direction: ltr; unicode-bidi: bidi-override }
		BDO[DIR="rtl"]  { direction: rtl; unicode-bidi: bidi-override }
		
		*[DIR="ltr"]    { direction: ltr; unicode-bidi: embed }
		*[DIR="rtl"]    { direction: rtl; unicode-bidi: embed }
		
		/*@media print {
		  h1            { page-break-before: always }
		  h1, h2, h3,
		  h4, h5, h6    { page-break-after: avoid }
		  ul, ol, dl    { page-break-before: avoid }
		}*/';
	 
	public static $CSS_PROPERTIES = array(
		'BACKGROUND-ATTACHMENT' => array(
			'initial' =>'scroll',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'BACKGROUND-COLOR' => array(
			'initial' =>'transparent',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'BACKGROUND-IMAGE' => array(
			'initial' =>'none',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'BACKGROUND-POSITION' => array(
			'initial' =>'0% 0%',
			'applies' => '',
			'inherited' => false,
			'percentages' => 'refer to the size of the box itself'
		),
		'BACKGROUND-REPEAT' => array(
			'initial' =>'repeat',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'BACKGROUND' => array(
			'initial' =>'see individual properties',
			'applies' => '',
			'inherited' => false,
			'percentages' => 'allowed on background-position'
		),
		'BORDER-COLLAPSE' => array(
			'initial' =>'separate',
			'applies' => 'table and inline-table elements',
			'inherited' => true,
			'percentages' => ''
		),
		'BORDER-COLOR' => array(
			'initial' =>'see individual properties',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'BORDER-SPACING' => array(
			'initial' =>'0',
			'applies' => 'table and inline-table elements�',
			'inherited' => true,
			'percentages' => ''
		),
		'BORDER-STYLE' => array(
			'initial' =>'see individual properties',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'BORDER-TOP-COLOR' => array(
			'initial' =>'black',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'BORDER-RIGHT-COLOR' => array(
			'initial' =>'black',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'BORDER-BOTTOM-COLOR' => array(
			'initial' =>'black',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'BORDER-LEFT-COLOR' => array(
			'initial' =>'black',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'BORDER-TOP-STYLE' => array(
			'initial' =>'none',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'BORDER-RIGHT-STYLE' => array(
			'initial' =>'none',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'BORDER-BOTTOM-STYLE' => array(
			'initial' =>'none',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'BORDER-LEFT-STYLE' => array(
			'initial' =>'none',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'BORDER-TOP-WIDTH' => array(
			'initial' =>'medium',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'BORDER-RIGHT-WIDTH' => array(
			'initial' =>'medium',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'BORDER-BOTTOM-WIDTH' => array(
			'initial' =>'medium',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'BORDER-LEFT-WIDTH' => array(
			'initial' =>'medium',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'BORDER-WIDTH' => array(
			'initial' =>'see individual properties',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'BORDER' => array(
			'initial' =>'see individual properties',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'BOTTOM' => array(
			'initial' =>'auto',
			'applies' => 'positioned elements',
			'inherited' => false,
			'percentages' => 'refer to height of containing block'
		),
		'CAPTION-SIDE' => array(
			'initial' =>'top',
			'applies' => 'table-caption elements',
			'inherited' => true,
			'percentages' => ''
		),
		'CLEAR' => array(
			'initial' =>'none',
			'applies' => 'block-level elements',
			'inherited' => false,
			'percentages' => ''
		),
		'CLIP' => array(
			'initial' =>'auto',
			'applies' => 'absolutely positioned elements',
			'inherited' => false,
			'percentages' => ''
		),
		'COLOR' => array(
			'initial' =>'black',
			'applies' => '',
			'inherited' => true,
			'percentages' => ''
		),
		'CONTENT' => array(
			'initial' =>'normal',
			'applies' => ':before and :after pseudo-elements',
			'inherited' => false,
			'percentages' => ''
		),
		'COUNTER-INCREMENT' => array(
			'initial' =>'none',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'COUNTER-RESET' => array(
			'initial' =>'none',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'CURSOR' => array(
			'initial' =>'auto',
			'applies' => '',
			'inherited' => true,
			'percentages' => ''
		),
		'DIRECTION' => array(
			'initial' =>'ltr',
			'applies' => '"all elements, but see prose"',
			'inherited' => true,
			'percentages' => ''
		),
		'DISPLAY' => array(
			'initial' =>'inline',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'EMPTY-CELLS' => array(
			'initial' =>'show',
			'applies' => 'table-cell elements',
			'inherited' => true,
			'percentages' => ''
		),
		'FLOAT' => array(
			'initial' =>'none',
			'applies' => '"all, but see 9.7"',
			'inherited' => false,
			'percentages' => ''
		),
		'FONT-FAMILY' => array(
			'initial' =>'helvetica',
			'applies' => '',
			'inherited' => true,
			'percentages' => ''
		),
		'FONT-SIZE' => array(
			'initial' => '10', //'medium',
			'applies' => '',
			'inherited' => true,
			'percentages' => 'refer to parent element\'s font size'
		),
		'FONT-STYLE' => array(
			'initial' =>'normal',
			'applies' => '',
			'inherited' => true,
			'percentages' => ''
		),
		'FONT-VARIANT' => array(
			'initial' =>'normal',
			'applies' => '',
			'inherited' => true,
			'percentages' => ''
		),
		'FONT-WEIGHT' => array(
			'initial' =>'normal',
			'applies' => '',
			'inherited' => true,
			'percentages' => ''
		),
		'FONT' => array(
			'initial' =>'see individual properties',
			'applies' => '',
			'inherited' => true,
			'percentages' => 'see individual properties'
		),
		'HEIGHT' => array(
			'initial' =>'auto',
			'applies' => '"all elements but non-replaced inline elements, table columns, and column groups"',
			'inherited' => false,
			'percentages' => 'see prose'
		),
		'LEFT' => array(
			'initial' =>'auto',
			'applies' => 'positioned elements',
			'inherited' => false,
			'percentages' => 'refer to width of containing block'
		),
		'LETTER-SPACING' => array(
			'initial' =>'normal',
			'applies' => '',
			'inherited' => true,
			'percentages' => ''
		),
		'LINE-HEIGHT' => array(
			'initial' =>'normal',
			'applies' => '',
			'inherited' => true,
			'percentages' => 'refer to the font size of the element itself'
		),
		'LIST-STYLE-IMAGE' => array(
			'initial' =>'none',
			'applies' => 'elements with display: list-item',
			'inherited' => true,
			'percentages' => ''
		),
		'LIST-STYLE-POSITION' => array(
			'initial' =>'outside',
			'applies' => 'elements with display: list-item',
			'inherited' => true,
			'percentages' => ''
		),
		'LIST-STYLE-TYPE' => array(
			'initial' =>'disc',
			'applies' => 'elements with display: list-item',
			'inherited' => true,
			'percentages' => ''
		),
		'LIST-STYLE' => array(
			'initial' =>'see individual properties',
			'applies' => 'elements with display: list-item',
			'inherited' => true,
			'percentages' => ''
		),
		'MARGIN-RIGHT' => array(
			'initial' =>'0',
			'applies' => 'all elements except elements with table display types other than table and inline-table',
			'inherited' => false,
			'percentages' => 'refer to width of containing block'
		),
		'MARGIN-LEFT' => array(
			'initial' =>'0',
			'applies' => 'all elements except elements with table display types other than table and inline-table',
			'inherited' => false,
			'percentages' => 'refer to width of containing block'
		),
		'MARGIN-TOP' => array(
			'initial' =>'0',
			'applies' => 'all elements except elements with table display types other than table and inline-table',
			'inherited' => false,
			'percentages' => 'refer to width of containing block'
		),
		'MARGIN-BOTTOM' => array(
			'initial' =>'0',
			'applies' => 'all elements except elements with table display types other than table and inline-table',
			'inherited' => false,
			'percentages' => 'refer to width of containing block'
		),
		'MARGIN' => array(
			'initial' =>'see individual properties',
			'applies' => 'all elements except elements with table display types other than table and inline-table',
			'inherited' => false,
			'percentages' => 'refer to width of containing block'
		),
		'MAX-HEIGHT' => array(
			'initial' =>'none',
			'applies' => '"all elements but non-replaced inline elements, table columns, and column groups"',
			'inherited' => false,
			'percentages' => 'see prose'
		),
		'MAX-WIDTH' => array(
			'initial' =>'none',
			'applies' => '"all elements but non-replaced inline elements, table rows, and row groups"',
			'inherited' => false,
			'percentages' => 'refer to width of containing block'
		),
		'MIN-HEIGHT' => array(
			'initial' =>'0',
			'applies' => '"all elements but non-replaced inline elements, table columns, and column groups"',
			'inherited' => false,
			'percentages' => 'see prose'
		),
		'MIN-WIDTH' => array(
			'initial' =>'0',
			'applies' => '"all elements but non-replaced inline elements, table rows, and row groups"',
			'inherited' => false,
			'percentages' => 'refer to width of containing block'
		),
		'ORPHANS' => array(
			'initial' =>'2',
			'applies' => 'block-level elements',
			'inherited' => true,
			'percentages' => ''
		),
		'OUTLINE-COLOR' => array(
			'initial' =>'invert',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'OUTLINE-STYLE' => array(
			'initial' =>'none',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'OUTLINE-WIDTH' => array(
			'initial' =>'medium',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'OUTLINE' => array(
			'initial' =>'see individual properties',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'OVERFLOW' => array(
			'initial' =>'visible',
			'applies' => '"non-replaced block-level elements, table cells, and inline-block elements"',
			'inherited' => false,
			'percentages' => ''
		),
		'PADDING-TOP' => array(
			'initial' =>'0',
			'applies' => '"all elements except elements with table display types other than table, inline-table, and table-cell"',
			'inherited' => false,
			'percentages' => 'refer to width of containing block'
		),
		'PADDING-RIGHT' => array(
			'initial' =>'0',
			'applies' => '"all elements except elements with table display types other than table, inline-table, and table-cell"',
			'inherited' => false,
			'percentages' => 'refer to width of containing block'
		),
		'PADDING-BOTTOM' => array(
			'initial' =>'0',
			'applies' => '"all elements except elements with table display types other than table, inline-table, and table-cell"',
			'inherited' => false,
			'percentages' => 'refer to width of containing block'
		),
		'PADDING-LEFT' => array(
			'initial' =>'0',
			'applies' => '"all elements except elements with table display types other than table, inline-table, and table-cell"',
			'inherited' => false,
			'percentages' => 'refer to width of containing block'
		),
		'PADDING' => array(
			'initial' =>'see individual properties',
			'applies' => '"all elements except elements with table display types other than table, inline-table, and table-cell"',
			'inherited' => false,
			'percentages' => 'refer to width of containing block'
		),
		'PAGE-BREAK-AFTER' => array(
			'initial' =>'auto',
			'applies' => 'block-level elements',
			'inherited' => false,
			'percentages' => ''
		),
		'PAGE-BREAK-BEFORE' => array(
			'initial' =>'auto',
			'applies' => 'block-level elements',
			'inherited' => false,
			'percentages' => ''
		),
		'PAGE-BREAK-INSIDE' => array(
			'initial' =>'auto',
			'applies' => 'block-level elements',
			'inherited' => true,
			'percentages' => ''
		),
		'POSITION' => array(
			'initial' =>'static',
			'applies' => '',
			'inherited' => false,
			'percentages' => ''
		),
		'QUOTES' => array(
			'initial' =>'depends on user agent',
			'applies' => '',
			'inherited' => true,
			'percentages' => ''
		),
		'RIGHT' => array(
			'initial' =>'auto',
			'applies' => 'positioned elements',
			'inherited' => false,
			'percentages' => 'refer to width of containing block'
		),
		'TABLE-LAYOUT' => array(
			'initial' =>'auto',
			'applies' => 'table and inline-table elements',
			'inherited' => false,
			'percentages' => ''
		),
		'TEXT-ALIGN' => array(
			'initial' =>'left if direction is ltr; right if direction is rtl',
			'applies' => '"block-level elements, table cells and inline blocks"',
			'inherited' => true,
			'percentages' => ''
		),
		'TEXT-DECORATION' => array(
			'initial' =>'none',
			'applies' => '',
			'inherited' => 'no (see prose)',
			'percentages' => ''
		),
		'TEXT-INDENT' => array(
			'initial' =>'0',
			'applies' => '"block-level elements, table cells and inline blocks"',
			'inherited' => true,
			'percentages' => 'refer to width of containing block'
		),
		'TEXT-TRANSFORM' => array(
			'initial' =>'none',
			'applies' => '',
			'inherited' => true,
			'percentages' => ''
		),
		'TOP' => array(
			'initial' =>'auto',
			'applies' => 'positioned elements',
			'inherited' => false,
			'percentages' => 'refer to height of containing block'
		),
		'UNICODE-BIDI' => array(
			'initial' =>'normal',
			'applies' => '"all elements, but see prose"',
			'inherited' => false,
			'percentages' => ''
		),
		'VERTICAL-ALIGN' => array(
			'initial' =>'baseline',
			'applies' => 'inline-level and table-cell elements',
			'inherited' => false,
			'percentages' => 'refer to the line-height of the element itself'
		),
		'VISIBILITY' => array(
			'initial' =>'visible',
			'applies' => '',
			'inherited' => true,
			'percentages' => ''
		),
		'WHITE-SPACE' => array(
			'initial' =>'normal',
			'applies' => '',
			'inherited' => true,
			'percentages' => ''
		),
		'WIDOWS' => array(
			'initial' =>'2',
			'applies' => 'block-level elements',
			'inherited' => true,
			'percentages' => ''
		),
		'WIDTH' => array(
			'initial' =>'auto',
			'applies' => '"all elements but non-replaced inline elements, table rows, and row groups"',
			'inherited' => false,
			'percentages' => 'refer to width of containing block'
		),
		'WORD-SPACING' => array(
			'initial' =>'normal',
			'applies' => '',
			'inherited' => true,
			'percentages' => ''
		),
		'Z-INDEX' => array(
			'initial' =>'auto',
			'applies' => 'positioned elements',
			'inherited' => false,
			'percentages' => ''
		),
	);
	
	static function IsInherited($property)
	{
		return kCSSDefaults::$CSS_PROPERTIES[$property]['inherited'];
//		return isset(kCSSDefaults::$CSS_PROPERTIES[$property]) ?  : false;
	}
	
	static function IsValid($property)
	{
		return isset(kCSSDefaults::$CSS_PROPERTIES[$property]);
	}
	
	static function GetDefaultValue($property)
	{
		return kCSSDefaults::$CSS_PROPERTIES[$property]['initial'];
//		return isset(kCSSDefaults::$CSS_PROPERTIES[$property]) ? kCSSDefaults::$CSS_PROPERTIES[$property]['initial'] : false;
	}
	
}