<?php
/**
* @version	$Id: main_event_handler.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

	class MainEventHandler extends kEventHandler {


		/**
		* Description
		*
		* @var kDBConnection
		* @access public
		*/
		var $Conn;

		/**
		 * Adds ability to address db connection
		 *
		 * @return kDBEventHandler
		 * @access public
		 */
		function MainEventHandler()
		{
			parent::kBase();
			$this->Conn =& $this->Application->GetADODBConnection();
		}

		/**
		 * Created url part for this module
		 *
		 * @param kEvent $event
		 */
		function BuildEnv(&$event)
		{
			$prefix_special = $event->getPrefixSpecial();
			$url_params = $event->getEventParam('url_params');

			$query_vars = $this->Application->getUnitOption($event->Prefix, 'QueryString');

			//if pass events is off and event is not implicity passed
			if ( !$event->getEventParam('pass_events') && !isset($url_params[$prefix_special.'_event']) )
			{
				$url_params[$prefix_special.'_event'] = ''; // remove event from url if requested
				//otherwise it will use value from get_var
			}

			if(!$query_vars) return true;

			$processed_params = Array();
			foreach($query_vars as $index => $var_name)
			{
				//if value passed in params use it, otherwise use current from application
				$var_name = $prefix_special.'_'.$var_name;
				$processed_params[$var_name] =  isset( $url_params[$var_name] ) ? $url_params[$var_name] : $this->Application->GetVar($var_name);
				if ( isset($url_params[$var_name]) ) unset( $url_params[$var_name] );
			}

			$ret = '';
			$default_language_id = $this->Application->GetDefaultLanguageId();
			if( $processed_params['m_lang'] && ($processed_params['m_lang'] != $default_language_id) )
			{
				$language_name = $this->Application->getCache('language_names', $processed_params['m_lang']);
				if ($language_name === false) {
					$sql = 'SELECT PackName
							FROM '.TABLE_PREFIX.'Language
							WHERE LanguageId = '.$processed_params['m_lang'];
					$language_name = $this->Conn->GetOne($sql);
					$this->Application->setCache('language_names', $processed_params['m_lang'], $language_name);
				}
				$ret .= $language_name.'/';
			}

			$default_theme_id = $this->Application->GetDefaultThemeId();
			if( $processed_params['m_theme'] && ($processed_params['m_theme'] != $default_theme_id) )
			{
				$theme_name = $this->Application->getCache('theme_names', $processed_params['m_theme']);
				if ($theme_name === false) {
					$sql = 'SELECT Name
							FROM '.TABLE_PREFIX.'Theme
							WHERE ThemeId = '.$processed_params['m_theme'];
					$theme_name = $this->Conn->GetOne($sql);
					$this->Application->setCache('theme_names', $processed_params['m_theme'], $theme_name);

				}
				$ret .= $theme_name.'/';
			}

			if ($processed_params['m_cat_id'] > 0 && isset($url_params['pass_category']) && $url_params['pass_category']) {
				$category_filename = $this->Application->getFilename('c', $processed_params['m_cat_id']);
				$t = isset($url_params['t']) && $url_params['t'] ? $url_params['t'] : false;

				// we could have category path like "Content/<template_path>" in this case remove template (proj-cms trick)
				preg_match('/^Content\/(.*)/i', $category_filename, $regs);

				if ($regs) {
					if (strtolower($regs[1]) == strtolower($t)) {
						$url_params['t'] = '';
					}

					$ret .= $regs[1] . '/';
				}

				$url_params['category_processed'] = true;
			}
			else {
//				$url_params['no_category'] = 1; // for debugging
			}
			unset($url_params['pass_category']); // unset it just in case

			$force_page_adding = false;
			if (getArrayValue($url_params, 'reset'))
			{
				unset($url_params['reset']);
				if ($processed_params['m_cat_id'])
				{
					$processed_params['m_cat_page'] = 1;
					$force_page_adding = true;
				}
			}

			if( (array_key_exists('category_processed', $url_params) && $url_params['category_processed'] && ($processed_params['m_cat_page'] > 1)) || $force_page_adding ) {
				// category page number found & category name was added before
				$ret = preg_replace('/(.*)\//', '\\1', $ret).'_'.$processed_params['m_cat_page'].'/';
			}

			$template = getArrayValue($url_params, 't');
			$category_template = $processed_params['m_cat_id'] ? $this->Application->getCache('category_designs', $processed_params['m_cat_id']) : '';

			if ((strtolower($template) == '__default__') && ($processed_params['m_cat_id'] == 0)) {
				// for "Home" category set template to index when not set
				$template = 'index';
			}

			// remove template from url if it is category index cached template
			if ($template == $category_template || mb_strtolower($template) == '__default__') {
				$template = '';
			}

			if ($template) {
				$ret .= $template.'/';
			}
			unset($url_params['t']);

			$event->setEventParam('url_params', $url_params);
			$event->setEventParam('env_string', mb_strtolower($ret) );
		}
	}

?>