<?php
/**
* @version	$Id: favorites_eh.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

class FavoritesEventHandler extends kDBEventHandler {

	/**
	 * Allows to override standart permission mapping
	 *
	 */
	function mapPermissions()
	{
		parent::mapPermissions();
		$permissions = Array (
			'OnFavoriteToggle' => Array('subitem' => true),
		);
		$this->permMapping = array_merge($this->permMapping, $permissions);
	}

	/**
	 * Adds/removes item from favorites
	 *
	 * @param kEvent $event
	 */
	function OnFavoriteToggle(&$event)
	{
		$parent_prefix = $this->Application->getUnitOption($event->Prefix, 'ParentPrefix');
		$parent_object =& $this->Application->recallObject($parent_prefix);
		/* @var $parent_object kDBItem */

		if (!$parent_object->isLoaded() || !$this->Application->CheckPermission('FAVORITES', 0, $parent_object->GetDBField('ParentPath'))) {
			$event->status = erPERM_FAIL;
			return ;
		}

		$user_id = $this->Application->RecallVar('user_id');
		$sql = 'SELECT FavoriteId
				FROM '.$this->Application->getUnitOption($event->Prefix, 'TableName').'
				WHERE (PortalUserId = '.$user_id.') AND (ResourceId = '.$parent_object->GetDBField('ResourceId').')';
		$favorite_id = $this->Conn->GetOne($sql);

		$object =& $event->getObject(Array('skip_autoload' => true));
		/* @var $object kDBItem */

		if ($favorite_id) {
			$object->Delete($favorite_id);
		}
		else {
			$object->Create();
		}

		$event->SetRedirectParam('pass', 'm,'.$parent_prefix);
	}

	/**
	 * Prepares Favorite record fields
	 *
	 * @param kEvent $event
	 */
	function OnBeforeItemCreate(&$event)
	{
		$object =& $event->getObject();
		/* @var $object kDBItem */

		$user_id = $this->Application->RecallVar('user_id');
		$object->SetDBField('PortalUserId', $user_id);

		$parent_prefix = $this->Application->getUnitOption($event->Prefix, 'ParentPrefix');
		$parent_object =& $this->Application->recallObject($parent_prefix);
		/* @var $parent_object kDBItem */

		$object->SetDBField('ResourceId', $parent_object->GetDBField('ResourceId'));
		$object->SetDBField('ItemTypeId', $this->Application->getUnitOption($parent_prefix, 'ItemType'));
	}

	/**
	 * [HOOK] Deletes favorite record to item, that is beeing deleted
	 *
	 * @param kEvent $event
	 */
	function OnDeleteFavoriteItem(&$event)
	{
		$main_object =& $event->MasterEvent->getObject();

		$sql = 'DELETE FROM '.$this->Application->getUnitOption($event->Prefix, 'TableName').'
				WHERE ResourceId = '.$main_object->GetDBField('ResourceId');
		$this->Conn->Query($sql);
	}

}


?>