<?php
/**
* @version	$Id: configuration_event_handler.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

	class ConfigurationEventHandler extends kDBEventHandler  {


		/**
		 * Changes permission section to one from REQUEST, not from config
		 *
		 * @param kEvent $event
		 */
		function CheckPermission(&$event)
		{
			$event->setEventParam('PermSection', $this->Application->GetVar('section'));
			return parent::CheckPermission($event);
		}


		/**
		 * Apply any custom changes to list's sql query
		 *
		 * @param kEvent $event
		 * @access protected
		 * @see OnListBuild
		 */
		function SetCustomQuery(&$event)
		{
			$object =& $event->getObject();
			/* @var $object kDBList */

			$module = $this->Application->GetVar('module');
			$section = $this->Application->GetVar('section');

			$object->addFilter('module_filter', '%1$s.ModuleOwner = '.$this->Conn->qstr($module));
			$object->addFilter('section_filter', '%1$s.Section = '.$this->Conn->qstr($section));

			if (defined('IS_INSTALL') && IS_INSTALL) {
				$object->addFilter('install_filter', 'ca.Install = 1');
			}
		}

		/**
		 * Enter description here...
		 *
		 * @param kEvent $event
		 */
		function OnBeforeItemUpdate(&$event)
		{
			$object =& $event->getObject();

			// if password field is empty, then don't update
			if ($object->GetDBField('element_type') == 'password') {
				if (trim($object->GetDBField('VariableValue')) == '') {
					$field_options = $object->GetFieldOptions('VariableValue');
					$field_options['skip_empty'] = 1;
					$object->SetFieldOptions('VariableValue', $field_options);
				}else {
					$password_formatter =& $this->Application->recallObject('kPasswordFormatter');
					$object->SetDBField('VariableValue', $password_formatter->EncryptPassword($object->GetDBField('VariableValue'), 'b38'));
				}
			}

			$field_values = $this->Application->GetVar($event->getPrefixSpecial(true));

			$state_country_hash = Array(
											'Comm_State'			=>	'Comm_Country',
											'Comm_Shipping_State'	=>	'Comm_Shipping_Country'
									);

			$field_name = $object->GetDBField('VariableName');
			if (isset($state_country_hash[$field_name])) {
				// if this is state field
				$check_state = $object->GetDBField('VariableValue');
				$check_country = $field_values[ $state_country_hash[$field_name] ]['VariableValue'];

				if (!($check_country && $check_state)) {
					return true;
				}

				$cs_helper =& $this->Application->recallObject('CountryStatesHelper');
				$state_iso = $cs_helper->CheckState($check_state, $check_country);
				if ($state_iso !== false) {
					$object->SetDBField('VariableValue', $state_iso);
				}
				else
				{
					$errormsgs = $this->Application->GetVar('errormsgs');
					$errors = !$errormsgs || !isset($errormsgs[$event->Prefix_Special]) ?  Array() : $errormsgs[$event->Prefix_Special];

					$errors[$field_name] = 'la_InvalidState';
					$errormsgs[$event->Prefix_Special] = $errors;

					$this->Application->SetVar('errormsgs', $errormsgs);
					$event->status = erFAIL;
				}
			}

		}

		/**
		 * Enter description here...
		 *
		 * @param kEvent $event
		 */
		function OnAfterItemUpdate(&$event)
		{
			$object =& $event->getObject();
			if ($object->GetDBField('element_type') == 'password') {
				if (trim($object->GetDBField('VariableValue')) == '') {
					$field_options = $object->GetFieldOptions('VariableValue');
					unset($field_options['skip_empty']);
					$object->SetFieldOptions('VariableValue', $field_options);
				}
			}
		}

		/**
		 * Enter description here...
		 *
		 * @param kEvent $event
		 */
		function OnUpdate(&$event)
		{
			if (!$this->Application->CheckPermission('SYSTEM_ACCESS.READONLY', 1)) {

				// 1. save user selected module root category
				$items_info = $this->Application->GetVar($event->getPrefixSpecial(true));
				$new_category_id = getArrayValue($items_info, 'ModuleRootCategory', 'VariableValue');
				if ($new_category_id !== false) {
					unset($items_info['ModuleRootCategory']);
					$this->Application->SetVar($event->getPrefixSpecial(true), $items_info);
				}

				parent::OnUpdate($event);

				if ($event->status == erSUCCESS && $new_category_id !== false) {
					// root category was submitted
					$module = $this->Application->GetVar('module');
					$root_category_id = $this->Application->findModule('Name', $module, 'RootCat');

					if ($root_category_id != $new_category_id) {
						// root category differs from one in db
						$fields_hash = Array('RootCat' => $new_category_id);
						$this->Conn->doUpdate($fields_hash, TABLE_PREFIX.'Modules', 'Name = '.$this->Conn->qstr($module));
					}
				}

				if ($event->status == erSUCCESS) { // reset cache
					$refresh_sections = false;
					if ($items_info) {
						$id_field = $this->Application->getUnitOption($event->Prefix, 'IDField');
						$table_name = $this->Application->getUnitOption($event->Prefix, 'TableName');

						$sql = 'SELECT ' . $id_field . '
								FROM ' . $table_name . '
								WHERE ' . $id_field . ' IN (' . implode(',', array_keys($items_info)) . ') AND (VariableName = "AdvancedUserManagement")';
						$refresh_sections = $this->Conn->GetCol($sql);
					}

					if ($refresh_sections) {
						// reset sections too, because of AdvancedUserManagement
						$event->SetRedirectParam('refresh_tree', 1);
					}

					$this->Application->UnitConfigReader->ResetParsedData($refresh_sections ? true : false);
				}
			}

			if ($this->Application->GetVar('errormsgs')) {
				// because we have list out there, and this is item
				$this->Application->removeObject($event->getPrefixSpecial());
				$event->redirect = false;
			}

			// keeps module and section in REQUEST to ensure, that last admin template will work
			$event->SetRedirectParam('module', $this->Application->GetVar('module'));
			$event->SetRedirectParam('section', $this->Application->GetVar('section'));
		}

		/**
		 * Enter description here...
		 *
		 * @param kEvent $event
		 */
		/*function OnChangeCountry(&$event)
		{
			$event->setPseudoClass('_List');
			$object = &$event->getObject( Array('per_page'=>-1) );
			$object->Query();
			$array_records =& $object->Records;
			foreach($array_records as $i=>$record){
				if ($record['VariableName']=='Comm_Country'){
					$values = $this->Application->GetVar('conf');
					$array_records[$i]['VariableValue'] = $values['Comm_Country']['VariableValue'];
				}
			}

			$event->redirect_params = Array('opener' => 's', 'pass'=>'all,conf'); //stay!
			$event->redirect = false;
		}*/

		/**
		 * Process items from selector (selected_ids var, key - prefix, value - comma separated ids)
		 *
		 * @param kEvent $event
		 */
		function OnProcessSelected(&$event)
		{
			$selected_ids = $this->Application->GetVar('selected_ids');
			$this->Application->StoreVar('ModuleRootCategory', $selected_ids['c']);

			$event->SetRedirectParam('opener', 'u');
		}

	}



?>