<?php
/**
* @version	$Id: item_filter_eh.php 16513 2017-01-20 14:10:53Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2011 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class ItemFilterEventHandler extends kDBEventHandler {

	/**
	 * Allows to override standard permission mapping
	 *
	 * @return void
	 * @access protected
	 * @see kEventHandler::$permMapping
	 */
	protected function mapPermissions()
	{
		parent::mapPermissions();

		$permissions = Array (
			'OnItemBuild' => Array ('self' => true),
		);

		$this->permMapping = array_merge($this->permMapping, $permissions);
	}

	/**
	 * Apply any custom changes to list's sql query
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 * @see kDBEventHandler::OnListBuild()
	 */
	protected function SetCustomQuery(kEvent $event)
	{
		parent::SetCustomQuery($event);

		if ( !$this->Application->isAdmin ) {
			/** @var kDBList $object */
			$object = $event->getObject();

			$prefix_info = $this->Application->processPrefix($event->getEventParam('prefix'));

			$object->addFilter('prefix_filter', '%1$s.ItemPrefix = ' . $this->Conn->qstr($prefix_info['prefix']));
			$object->addFilter('status_filter', '%1$s.Enabled = 1');

			if ( $event->Special == 'used' ) {
				$filters = array_keys($this->Application->GetVar('filters', Array ()));

				if ( $filters ) {
					$filters = $this->Conn->qstrArray($filters);
					$object->addFilter('field_filter', '%1$s.FilterField IN (' . implode(',', $filters) . ')');
				}
				else {
					$object->addFilter('field_filter', 'FALSE');
				}
			}

			$exclude_filters = $this->Application->GetVar('exclude_filters');

			if ( $exclude_filters ) {
				$exclude_filters = $this->Conn->qstrArray(explode(',', $exclude_filters));
				$object->addFilter('field_filter', '%1$s.FilterField NOT IN (' . implode(',', $exclude_filters) . ')');
			}

			if ( $event->getEventParam('per_page') === false ) {
				$event->setEventParam('per_page', -1);
			}
		}
	}

	/**
	 * Validates filter settings
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnBeforeItemValidate(kEvent $event)
	{
		parent::OnBeforeItemValidate($event);

		/** @var kDBItem $object */
		$object = $event->getObject();

		$prefix = $object->GetDBField('ItemPrefix');

		if ( $prefix ) {
			if ( !$this->Application->prefixRegistred($prefix) ) {
				$object->SetError('ItemPrefix', 'not_registered');
			}

			$field = $object->GetDBField('FilterField');

			if ( $field ) {
				$fields = $this->Application->getUnitOption($prefix, 'Fields');
				$virtual_fields = $this->Application->getUnitOption($prefix, 'VirtualFields');

				if ( !isset($fields[$field]) && !isset($virtual_fields[$field]) ) {
					$object->SetError('FilterField', 'non_existing', null, Array ($prefix));
				}
			}
		}

		$object->setRequired('RangeCount', $object->GetDBField('FilterType') == 'range');
	}

	/**
	 * Load item if id is available
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function LoadItem(kEvent $event)
	{
		static $cache = null;

		if ( $this->Application->isAdmin ) {
			parent::LoadItem($event);

			return;
		}

		/** @var kDBItem $object */
		$object = $event->getObject();

		if ( !isset($cache) ) {
			$cache = $this->Conn->Query($object->GetSelectSQL(), 'FilterKey');
		}

		$filter_key = $event->getEventParam('prefix') . '_' . $event->getEventParam('field');

		if ( isset($cache[$filter_key]) ) {
			$object->LoadFromHash($cache[$filter_key]);
		}

		if ( $object->isLoaded() ) {
			/** @var Params $actions */
			$actions = $this->Application->recallObject('kActions');

			$actions->Set($event->getPrefixSpecial() . '_id', $object->GetID());
		}
		else {
			$object->setID(false);
		}
	}
}
