<?php
defined('FULL_PATH') or die('restricted access!');

$config = Array (
	'Prefix' => 'spam-report',
	'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
	'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
	'EventHandlerClass' => Array ('class' => 'SpamReportEventHandler', 'file' => 'spam_report_eh.php', 'build_event' => 'OnBuild'),
	'TagProcessorClass' => Array ('class' => 'SpamReportTagProcessor', 'file' => 'spam_report_tp.php', 'build_event' => 'OnBuild'),

	'AutoLoad' => true,

	'QueryString' => Array (
		1 => 'id',
		2 => 'Page',
		3 => 'PerPage',
		4 => 'event',
		5 => 'mode',
	),

	'IDField' => 'ReportId',

	'TableName' => TABLE_PREFIX . 'SpamReports',

	'TitleField' => 'MessageText',

	'TitlePresets' => Array (
		'default' => Array (
			'edit_status_labels' => Array ('spam-report' => '!la_title_EditingSpamReport!'),
		),

		'spam_report_list' => Array (
			'prefixes' => Array ('spam-report_List'), 'format' => "!la_title_SpamReports!",
			'toolbar_buttons' => Array ('edit', 'delete', 'view'),
		),

		'spam_report_edit' => Array (
			'prefixes' => Array ('spam-report'), 'format' => "#spam-report_status# '#spam-report_titlefield#'",
			'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'delete'),
		),
	),

	'PermSection' => Array ('main' => 'in-portal:spam_reports'),

	'Sections' => Array (
		'in-portal:spam_reports' => Array (
			'parent' => 'in-portal:reports',
			'icon' => 'spam_reports',
			'label' => 'la_title_SpamReports',
			'url' => Array ('t' => 'spam_reports/spam_report_list', 'pass' => 'm'),
			'permissions' => Array ('view', 'edit', 'delete'),
			'priority' => 8,
			'type' => stTREE,
		),
	),

	'ListSQLs' => Array (
		'' => '	SELECT %1$s.* %2$s
				FROM %1$s
				LEFT JOIN ' . TABLE_PREFIX . 'Users reported_by ON reported_by.PortalUserId = %1$s.ReportedById
				LEFT JOIN ' . TABLE_PREFIX . 'CatalogReviews review ON review.ReviewId = %1$s.ItemId AND %1$s.ItemPrefix LIKE "%rev"',
	),

	'CalculatedFields' => Array (
		'' => Array (
			'ItemName' => 'IF(%1$s.ItemPrefix LIKE "%rev", review.ReviewText, "")',
			'ReportedBy' => 'IF(reported_by.Username = "", reported_by.Email, reported_by.Username)',
		),
	),

	'ListSortings' => Array (
		'' => Array (
			'Sorting' => Array ('ReportId' => 'desc'),
		)
	),

	'Fields' => Array (
		'ReportId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'ItemPrefix' => Array (
			'type' => 'string', 'max_len' => 255,
			'formatter' => 'kOptionsFormatter', 'options' => Array ('p-rev' => 'la_opt_ProductReview'), 'use_phrases' => 1,
			'not_null' => 1, 'default' => ''
		),
		'ItemId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'MessageText' => Array ('type' => 'string', 'required' => 1, 'default' => NULL),
		'ReportedOn' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
		'ReportedById' => Array (
			'type' => 'int',
			'formatter' => 'kLEFTFormatter', 'options' => Array (USER_ROOT => 'root', USER_GUEST => 'Guest'), 'left_sql' => 'SELECT %s  FROM ' . TABLE_PREFIX . 'Users WHERE %s', 'left_key_field' => 'PortalUserId', 'left_title_field' => USER_TITLE_FIELD, 'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'), 'sample_value' => 'Guest',
			'default' => NULL
		)
	),

	'VirtualFields' => Array (
		'ItemName' => Array ('type' => 'string', 'default' => ''),
		'ReportedBy' => Array ('type' => 'string', 'default' => ''),
	),

	'Grids' => Array (
		'Default' => Array (
			'Fields' => Array (
				'ReportId' => Array ('title' => 'column:la_fld_Id', 'filter_block' => 'grid_range_filter'),
				'ItemPrefix' => Array ('data_block' => 'grid_item_prefix_td', 'filter_block' => 'grid_options_filter', 'width' => 150),
				'ItemId' => Array ('filter_block' => 'grid_range_filter'),
				'ItemName' => Array ('data_block' => 'grid_edit_item_td', 'filter_block' => 'grid_like_filter'),
				'MessageText' => Array ('filter_block' => 'grid_like_filter'),
				'ReportedOn' => Array ('filter_block' => 'grid_date_range_filter'),
				'ReportedBy' => Array ('filter_block' => 'grid_like_filter'),
			),
		),
	),
);