<?php
/**
* @version	$Id: selectors_tag_processor.php 16513 2017-01-20 14:10:53Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class SelectorsTagProcessor extends kDBTagProcessor {

		function PrintStyle($params)
		{
			/** @var SelectorsItem $object */
			$object = $this->getObject($params);

			$style_data = $object->GetDBField( $params['field'] );

			$ret = $object->CompileStyleBody( getArrayValue($params,'inline') ? STYLE_INLINE : STYLE_PREVIEW );

			return $ret;
		}

		/**
		 * Returns input field name to
		 * be placed on form (for correct
		 * event processing)
		 *
		 * @param Array $params
		 * @return string
		 * @access public
		 */
		function InputName($params)
		{
			$ret = parent::InputName($params);
			$subfield = getArrayValue($params,'subfield');
			if($subfield && $subfield != '$subfield')
			{
				$ret .= '['.$subfield.']';
			}
			return $ret;
		}

		function Field($params)
		{
			$subfield = getArrayValue($params,'subfield');
			if($subfield && $subfield != '$subfield')
			{
				$params['no_special'] = 'no_special';
			}
			$ret = parent::Field($params);
			if($subfield && $subfield != '$subfield')
			{
				$ret = getArrayValue($ret,$subfield);
				return $ret !== false ? $ret : '';
			}
			return $ret;
		}

		/**
		 * Prints list a all possible field options
		 *
		 * @param Array $params
		 * @return string
		 * @access protected
		 */
		protected function PredefinedOptions($params)
		{
			$field = $params['field'];

			/** @var kDBItem $object */
			$object = $this->getObject($params);

			$value = $object->GetDBField($field);
			$subfield = getArrayValue($params, 'subfield');

			if ( $subfield && $subfield != '$subfield' ) {
				$value = $value[$subfield];
			}

			$value_field = getArrayValue($params, 'value_field');
			if ( !$value_field ) {
				$value_field = $field;
			}

			$block_params['name'] = $params['block'];
			$block_params['field'] = $params['field'];
			$block_params['pass_params'] = 'true';

			$selected_param_name = getArrayValue($params, 'selected_param');
			if ( !$selected_param_name ) {
				$selected_param_name = $params['selected'];
			}
			$selected = $params['selected'];

			$o = '';
			$options = $object->GetFieldOption($value_field, 'options');

			foreach ($options as $key => $val) {
				$block_params['key'] = $key;
				$block_params['option'] = $val;
				$block_params['field_name'] = $this->InputName($params);
				$block_params[$selected_param_name] = ($key == $value ? ' ' . $selected : '');
				$block_params['PrefixSpecial'] = $this->getPrefixSpecial();
				$o .= $this->Application->ParseBlock($block_params, 1);
			}

			return $o;
		}

	}