<?php
/**
* @version	$Id: system_logs_config.php 16388 2016-08-11 08:16:43Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2012 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

$config = Array (
	'Prefix' => 'system-log',
	'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
	'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
	'EventHandlerClass' => Array ('class' => 'SystemLogEventHandler', 'file' => 'system_log_eh.php', 'build_event' => 'OnBuild'),
	'TagProcessorClass' => Array ('class' => 'SystemLogTagProcessor', 'file' => 'system_log_tp.php', 'build_event' => 'OnBuild'),

	'AutoLoad' => true,

	'QueryString' => Array (
		1 => 'id',
		2 => 'Page',
		3 => 'PerPage',
		4 => 'event',
		5 => 'mode',
	),

	'ScheduledTasks' => Array (
		'system_log_notifications' => Array ('EventName' => 'OnSendNotifications', 'RunSchedule' => '0 * * * *'),
		'rotate_system_logs' => Array ('EventName' => 'OnRotate', 'RunSchedule' => '0 0 * * *'),
	),

	'IDField' => 'LogId',
//	'StatusField' => Array ('Status'),
	'TableName' => TABLE_PREFIX . 'SystemLog',

	'TitlePresets' => Array (
		'default' => Array (
			'edit_status_labels' => Array ('system-log' => '!la_title_ViewingSystemLog!'),
		),

		'system_log_list' => Array (
			'prefixes' => Array ('system-log_List'), 'format' => '!la_tab_SystemLog!',
			'toolbar_buttons' => Array ('edit', 'delete', 'reset', 'view', 'dbl-click'),
		),

		'system_log_edit' => Array (
			'prefixes' => Array ('system-log'), 'format' => '#system-log_status# "#system-log_titlefield#"',
			'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
		),
	),

	'PermSection' => Array ('main' => 'in-portal:system_logs'),

	'Sections' => Array (
		'in-portal:system_logs' => Array (
			'parent' => 'in-portal:reports',
			'icon' => 'system_log',
			'label' => 'la_tab_SystemLog',
			'url' => Array ('t' => 'logs/system_logs/system_log_list', 'pass' => 'm'),
			'permissions' => Array ('view', 'edit', 'delete'),
			'priority' => 6.1,
			'type' => stTREE,
		),
	),

	'TitleField' => 'LogMessage',

	'ListSQLs' => Array (
		'' => '	SELECT %1$s.* %2$s
				FROM %1$s
				LEFT JOIN '.TABLE_PREFIX.'Users AS u ON u.PortalUserId = %1$s.LogUserId',
	),

	'ListSortings' => Array (
		'' => Array (
			'Sorting' => Array ('LogId' => 'desc'),
		)
	),

	'CalculatedFields' => Array (
		'' => Array (
			'Username' => 'CASE %1$s.LogUserId WHEN ' . USER_ROOT . ' THEN "root" WHEN ' . USER_GUEST . ' THEN "Guest" ELSE IF(CONCAT(u.FirstName, u.LastName) <> "", CONCAT(u.FirstName, " ", u.LastName), IF(u.Username = "", u.Email, u.Username)) END',
		),
	),

	'ForceDontLogChanges' => true,

	'Fields' => Array (
		'LogId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'LogUniqueId' => Array ('type' => 'int', 'default' => NULL),
		'LogLevel' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (
				kLogger::LL_EMERGENCY => 'emergency',
				kLogger::LL_ALERT => 'alert',
				kLogger::LL_CRITICAL => 'critical',
				kLogger::LL_ERROR => 'error',
				kLogger::LL_WARNING => 'warning',
				kLogger::LL_NOTICE => 'notice',
				kLogger::LL_INFO => 'info',
				kLogger::LL_DEBUG => 'debug'
			),
			'not_null' => 1, 'default' => kLogger::LL_INFO
		),
		'LogType' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (
				kLogger::LT_PHP => 'la_opt_LogTypePhp',
				kLogger::LT_DATABASE => 'la_opt_LogTypeDatabase',
				kLogger::LT_OTHER => 'la_opt_LogTypeOther',
			), 'use_phrases' => 1,
			'not_null', 'default' => kLogger::LT_OTHER
		),
		'LogCode' => Array ('type' => 'int', 'default' => NULL),
		'LogMessage' => Array ('type' => 'string', 'default' => NULL),
		'LogTimestamp' => Array (
			'type' => 'int',
			'formatter' => 'kDateFormatter',
			'default' => NULL
		),
		'LogDate' => Array ('type' => 'string', 'default' => NULL),
		'LogEventName' => Array ('type' => 'string', 'max_len' => 100, 'not_null' => 1, 'default' => ''),
		'LogHostname' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
		'LogRequestSource' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'Web', 2 => 'CLI'),
			'default' => NULL
		),
		'LogRequestURI' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
		'LogRequestData' => Array ('type' => 'string', 'default' => NULL),
		'LogUserId' => Array (
			'type' => 'int',
			'default' => NULL
		),
		'LogInterface' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (
				kLogger::LI_FRONT => 'Front',
				kLogger::LI_ADMIN => 'Admin',
				kLogger::LI_CRON_FRONT => 'Cron (Front)',
				kLogger::LI_CRON_ADMIN => 'Cron (Admin)',
				kLogger::LI_API => 'API',
			),
			'not_null' => 1, 'default' => 0
		),
		'IpAddress' => Array ('type' => 'string', 'max_len' => 15, 'not_null' => 1, 'default' => ''),
		'LogSessionKey' => Array ('type' => 'int', 'default' => NULL),
		'LogSessionData' => Array ('type' => 'string', 'default' => NULL),
		'LogBacktrace' => Array ('type' => 'string', 'default' => NULL),
		'LogSourceFilename' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
		'LogSourceFileLine' => Array ('type' => 'int', 'default' => NULL),
		'LogProcessId' => Array ('type' => 'int', 'default' => NULL),
		'LogMemoryUsed' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'LogUserData' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
		'LogNotificationStatus' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (
				kLogger::LNS_DISABLED => 'la_opt_LogNotificationDisabled',
				kLogger::LNS_PENDING => 'la_opt_LogNotificationPending',
				kLogger::LNS_SENT => 'la_opt_LogNotificationSent'
			), 'use_phrases' => 1,
			'not_null' => 1, 'default' => kLogger::LNS_DISABLED
		)
	),

	'VirtualFields' => Array (
		'Username' => Array ('type' => 'string', 'default' => ''),
	),

	'Grids' => Array (
		'Default' => Array (
//			'Icons' => Array ('default' => 'icon16_item.png'),
			'Fields' => Array (
				'LogId' => Array ('title' => 'column:la_fld_Id', 'filter_block' => 'grid_range_filter', 'width' => 80),
				'LogLevel' => Array ('filter_block' => 'grid_options_filter', 'width' => 100),
				'LogType' => Array ('filter_block' => 'grid_options_filter', 'width' => 80),
				'LogCode' => Array ('filter_block' => 'grid_range_filter', 'width' => 80),
				'LogMessage' => Array ('filter_block' => 'grid_like_filter', 'width' => 250),
				'LogTimestamp' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 170),
				'LogEventName' => Array ('filter_block' => 'grid_like_filter'),
				'LogHostname' => Array ('filter_block' => 'grid_like_filter'),
				'LogRequestSource' => Array ('filter_block' => 'grid_options_filter'),
				'LogRequestURI' => Array ('data_block' => 'grid_uri_td', 'filter_block' => 'grid_like_filter'),
				'Username' => Array ('filter_block' => 'grid_range_filter', 'width' => 80),
				'LogInterface' => Array ('filter_block' => 'grid_options_filter'),
				'IpAddress' => Array ('filter_block' => 'grid_like_filter'),
				'LogSessionKey' => Array ('filter_block' => 'grid_range_filter', 'width' => 80),
				'LogSourceFilename' => Array ('data_block' => 'grid_filename_td', 'filter_block' => 'grid_like_filter', 'width' => 200),
				'LogSourceFileLine' => Array ('filter_block' => 'grid_range_filter', 'width' => 80),
				'LogProcessId' => Array ('filter_block' => 'grid_range_filter', 'width' => 80),
				'LogMemoryUsed' => Array ('data_block' => 'grid_memory_td', 'filter_block' => 'grid_range_filter'),
				'LogUserData' => Array ('filter_block' => 'grid_like_filter', 'nl2br' => 1),
				'LogNotificationStatus' => Array ('filter_block' => 'grid_options_filter'),
				'LogBacktrace' => Array ('data_block' => 'grid_backtrace_td', 'filter_block' => 'grid_empty_filter', 'width' => 500, 'hidden' => 1),
			),
		),
	),
);