<?php
/**
 * @version	$Id: system_event_subscription_eh.php 16513 2017-01-20 14:10:53Z alex $
 * @package	In-Portal
 * @copyright	Copyright (C) 1997 - 2012 Intechnic. All rights reserved.
 * @license	  GNU/GPL
 * In-Portal is Open Source software.
 * This means that this software may have been modified pursuant
 * the GNU General Public License, and as distributed it includes
 * or is derivative of works licensed under the GNU General Public License
 * or other free or open source software licenses.
 * See http://www.in-portal.org/license for copyright notices and details.
 */

defined('FULL_PATH') or die('restricted access!');

class SystemEventSubscriptionEventHandler extends kDBEventHandler {

	/**
	 * Makes either user or e-mail required
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnAfterItemLoad(kEvent $event)
	{
		parent::OnAfterItemLoad($event);

		$this->_setRequired($event);
	}

	/**
	 * Makes either user or e-mail required
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnPreCreate(kEvent $event)
	{
		parent::OnPreCreate($event);

		$this->_setRequired($event);
	}

	/**
	 * Makes either user or e-mail required
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnBeforeItemCreate(kEvent $event)
	{
		parent::OnBeforeItemCreate($event);

		$this->_itemChanged($event);
	}

	/**
	 * Makes either user or e-mail required
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnBeforeItemUpdate(kEvent $event)
	{
		parent::OnBeforeItemUpdate($event);

		$this->_itemChanged($event);
	}

	/**
	 * Makes either user or e-mail required
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function _itemChanged(kEvent $event)
	{
		$this->_setRequired($event);
	}

	/**
	 * Makes either user or e-mail required
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function _setRequired(kEvent $event)
	{
		/** @var kDBItem $object */
		$object = $event->getObject();

		$object->setRequired('UserId', !$object->GetDBField('SubscriberEmail'));
		$object->setRequired('SubscriberEmail', !$object->GetDBField('UserId'));
	}
}