<?php
/**
 * @version	$Id: email_log_tp.php 16513 2017-01-20 14:10:53Z alex $
 * @package	In-Portal
 * @copyright	Copyright (C) 1997 - 2012 Intechnic. All rights reserved.
 * @license	  GNU/GPL
 * In-Portal is Open Source software.
 * This means that this software may have been modified pursuant
 * the GNU General Public License, and as distributed it includes
 * or is derivative of works licensed under the GNU General Public License
 * or other free or open source software licenses.
 * See http://www.in-portal.org/license for copyright notices and details.
 */

defined('FULL_PATH') or die('restricted access!');

class EmailLogTagProcessor extends kDBTagProcessor {

	/**
	 * Prints other e-mail recipients
	 *
	 * @param Array $params
	 * @return string
	 * @access protected
	 */
	protected function PrintOtherRecipients($params)
	{
		/** @var kDBItem $object */
		$object = $this->getObject($params);

		$other_recipients = $object->GetDBField('OtherRecipients');
		$other_recipients = $other_recipients ? unserialize($other_recipients) : Array ();

		$ret = '';
		$block_params = $this->prepareTagParams($params);
		$block_params['name'] = $params['render_as'];

		foreach ($other_recipients as $recipient_type => $recipients) {
			if ( $recipient_type == EmailTemplate::RECIPIENT_TYPE_TO ) {
				array_shift($recipients);
			}

			if ( $recipients ) {
				$block_params['recipient_type'] = $recipient_type;
				$block_params['recipients'] = $recipients;

				$ret .= $this->Application->ParseBlock($block_params);
			}
		}

		return $ret;
	}

	/**
	 * Returns recipient type
	 *
	 * @param Array $params
	 * @return string
	 * @access protected
	 */
	protected function RecipientType($params)
	{
		$heading_mapping = Array (
			EmailTemplate::RECIPIENT_TYPE_TO => 'To',
			EmailTemplate::RECIPIENT_TYPE_CC => 'Cc',
			EmailTemplate::RECIPIENT_TYPE_BCC => 'Bcc',
		);

		$recipient_type = $this->Application->Parser->GetParam('recipient_type');

		return $heading_mapping[$recipient_type];
	}

	/**
	 * Prints recipients
	 *
	 * @param Array $params
	 * @return string
	 * @access protected
	 */
	protected function RecipientsByType($params)
	{
		/** @var Array $recipients */
		$recipients = $this->Application->Parser->GetParam('recipients');

		$ret = '';
		$block_params = $this->prepareTagParams($params);
		$block_params['name'] = $params['render_as'];

		$recipient_count = count($recipients);

		foreach ($recipients as $index => $recipient) {
			$block_params['recipient_name'] = $recipient['name'] ? $recipient['name'] : $recipient['email'];
			$block_params['recipient_email'] = $recipient['email'];
			$block_params['is_last'] = $index == $recipient_count - 1;

			$ret .= $this->Application->ParseBlock($block_params);
		}

		return $ret;
	}

	/**
	 * Creates link to an item including only it's id
	 *
	 * @param Array $params
	 * @return string
	 * @access protected
	 */
	protected function ItemLink($params)
	{
		$access_key = $this->Application->Parser->GetParam('email_access_key');

		if ( !$access_key ) {
			return parent::ItemLink($params);
		}

		$params['authkey'] = $access_key;

		if ( $this->Application->isAdmin ) {
//			$params['index_file'] = 'index.php';
			$params['prefix'] = '_FRONT_END_';

			if ( $this->Application->ConfigValue('UseModRewrite') ) {
				$params['__MOD_REWRITE__'] = 1;
			}
		}

		return $this->Application->ProcessParsedTag('m', 't', $params);
	}
}