<?php
/**
 * @version	$Id: email_log_eh.php 16513 2017-01-20 14:10:53Z alex $
 * @package	In-Portal
 * @copyright	Copyright (C) 1997 - 2012 Intechnic. All rights reserved.
 * @license	  GNU/GPL
 * In-Portal is Open Source software.
 * This means that this software may have been modified pursuant
 * the GNU General Public License, and as distributed it includes
 * or is derivative of works licensed under the GNU General Public License
 * or other free or open source software licenses.
 * See http://www.in-portal.org/license for copyright notices and details.
 */

defined('FULL_PATH') or die('restricted access!');

class EmailLogEventHandler extends kDBEventHandler {

	/**
	 * Allows to override standard permission mapping
	 *
	 * @return void
	 * @access protected
	 * @see kEventHandler::$permMapping
	 */
	protected function mapPermissions()
	{
		parent::mapPermissions();

		$permissions = Array (
			'OnItemBuild' => Array ('self' => true),
			'OnGetHtmlBody' => Array ('self' => 'edit'),
		);

		$this->permMapping = array_merge($this->permMapping, $permissions);
	}

	/**
	 * Returns ID of current item to be edited
	 * by checking ID passed in get/post as prefix_id
	 * or by looking at first from selected ids, stored.
	 * Returned id is also stored in Session in case
	 * it was explicitly passed as get/post
	 *
	 * @param kEvent $event
	 * @return int
	 * @access public
	 */
	public function getPassedID(kEvent $event)
	{
		if ( $this->Application->isAdmin ) {
			return parent::getPassedID($event);
		}

		$authkey = $this->Application->GetVar('authkey');

		return $authkey ? Array ('AccessKey' => $authkey) : false;
	}

	/**
	 * [SCHEDULED TASK] Will remove old e-mail logs
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnRotate(kEvent $event)
	{
		$rotation_interval = (int)$this->Application->ConfigValue('EmailLogRotationInterval');

		if ( $rotation_interval === -1 ) {
			// forever
			return;
		}

		$sql = 'SELECT ' . $this->Application->getUnitOption($event->Prefix, 'IDField') . '
				FROM ' . $this->Application->getUnitOption($event->Prefix, 'TableName') . '
				WHERE ' . TIMENOW . ' - SentOn > ' . $rotation_interval;
		$ids = $this->Conn->GetCol($sql);

		if ( $ids ) {
			/** @var kTempTablesHandler $temp_handler */
			$temp_handler = $this->Application->recallObject($event->getPrefixSpecial() . '_TempHandler', 'kTempTablesHandler', Array ('parent_event' => $event));

			$temp_handler->DeleteItems($event->Prefix, $event->Special, $ids);
		}
	}

	/**
	 * Returns HTML of sent e-mail for iframe
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnGetHtmlBody(kEvent $event)
	{
		$event->status = kEvent::erSTOP;

		/** @var kDBItem $object */
		$object = $event->getObject();

		echo $object->GetDBField('HtmlBody');
	}

	/**
	 * Checks, that currently loaded item is allowed for viewing (non permission-based)
	 *
	 * @param kEvent $event
	 * @return bool
	 * @access protected
	 */
	protected function checkItemStatus(kEvent $event)
	{
		/** @var kDBItem $object */
		$object = $event->getObject();

		if ( !$object->isLoaded() ) {
			return true;
		}

		$access_key = $object->GetDBField('AccessKey');

		return $access_key && $this->Application->GetVar('authkey') == $access_key;
	}
}