<?php
/**
* @version	$Id: form_field_eh.php 16513 2017-01-20 14:10:53Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2010 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class FormFieldEventHandler extends kDBEventHandler {

		/**
		 * Returns form field visibility filter
		 *
		 * @return string
		 */
		function getVisiblilityFilter()
		{
			if ($this->Application->LoggedIn() && !$this->Application->isAdminUser) {
				return '%1$s.Visibility = ' . SubmissionFormField::VISIBILITY_EVERYONE;
			}

			return '';
		}

		/**
		 * Shows fields based on user logged-in status
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 * @see kDBEventHandler::OnListBuild()
		 */
		protected function SetCustomQuery(kEvent $event)
		{
			parent::SetCustomQuery($event);

			/** @var kDBList $object */
			$object = $event->getObject();

			$visibility_filter = $this->getVisiblilityFilter();

			$object->addFilter('visibility_filter', $visibility_filter);
		}
	}
