<?php
/**
* @version	$Id: fck_tp.php 16513 2017-01-20 14:10:53Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class FckTagProcessor extends kDBTagProcessor {

		protected function CheckCreateDefaultFolders(Array $params)
		{
			/** @var fckFCKHelper $fck_helper */
			$fck_helper = $this->Application->recallObject('FCKHelper');

			$default_folders = defined('FCK_DEFAULT_FOLDERS') ? FCK_DEFAULT_FOLDERS : Array ('Files', 'Images', 'Flash', 'Media', 'Documents');

			foreach ($default_folders as $index => $folder) {
				if ( !$fck_helper->CreateFolder($folder) ) {
					unset($default_folders[$index]);
				}
			}

			if ( !$default_folders ) {
				return '';
			}

			$ret = '';
			foreach ($default_folders as $folder) {
				$selected = ($this->Application->GetVar('type') == $folder) ? 'selected' : '';
				$ret .= '<option value="' . $folder . '" ' . $selected . ' />' . $folder;
			}

			return $ret;
		}
	}