<?php
/**
* @version	$Id: translator_event_handler.php 16513 2017-01-20 14:10:53Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class TranslatorEventHandler extends kDBEventHandler
	{
		/**
		 * Allows to override standard permission mapping
		 *
		 * @return void
		 * @access protected
		 * @see kEventHandler::$permMapping
		 */
		protected function mapPermissions()
		{
			parent::mapPermissions();

			$permissions = Array(
				'OnChangeLanguage'	=>	Array('subitem' => 'add|edit'),
				'OnSaveAndClose'	=>	Array('subitem' => 'add|edit'),
			);

			$this->permMapping = array_merge($this->permMapping, $permissions);
		}

		/**
		 * Check permission of item, that being translated
		 *
		 * @param kEvent $event
		 * @return bool
		 * @access public
		 */
		public function CheckPermission(kEvent $event)
		{
			list($prefix, ) = $this->getPrefixAndField($event);

			$top_prefix = $this->Application->GetTopmostPrefix($prefix, true);
			$event->setEventParam('top_prefix', $top_prefix);

			return parent::CheckPermission($event);
		}


		/**
		 * Returns prefix and field being translated
		 *
		 * @param kEvent $event
		 */
		function getPrefixAndField($event)
		{
			$field = $this->Application->GetVar($event->getPrefixSpecial(true).'_field');

			if (strpos($field,':') !== false) {
				list($prefix, $field) = explode(':', $field);
			}
			else {
				$prefix = $this->Application->GetVar($event->getPrefixSpecial(true).'_prefix');
			}
			return Array($prefix, $field);
		}

		/**
		 * Loads record to be translated
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnLoad($event)
		{
			list($obj_prefix, $field) = $this->getPrefixAndField($event);

			/** @var kDBItem $object */
			$object = $this->Application->recallObject($obj_prefix);

			/** @var kDBItem $translator */
			$translator = $event->getObject();

			$def_lang = $this->Application->GetDefaultLanguageId();

			$current_lang = $translator->GetDBField('Language');
			if (!$current_lang) $current_lang = $this->Application->RecallVar('trans_lang');
			if (!$current_lang) $current_lang = $this->Application->GetVar('m_lang');
			/*if ($current_lang == $def_lang) {
				$current_lang = $def_lang + 1;
			}*/
			$this->Application->StoreVar('trans_lang', $current_lang); //remember translation language for user friendlyness

			$translator->SetID(1);
			$translator->SetDBField('Original', $object->GetDBField('l'.$this->Application->GetVar('m_lang').'_'.$field));
			$translator->SetDBField('Language', $current_lang);
			$translator->SetDBField('SwitchLanguage', $current_lang);

			$translator->SetDBField('Translation', $object->GetDBField('l'.$current_lang.'_'.$field));

			/** @var LanguagesItem $cur_lang */
			$cur_lang = $this->Application->recallObject('lang.current');

			$cur_lang->Load($current_lang);

			$translator->SetDBField('Charset', CHARSET);

			$event->redirect = false;
		}

		/**
		 * Saves changes into temporary table and closes editing window
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnSaveAndClose($event)
		{
			$event->CallSubEvent('OnPreSave');

			$event->SetRedirectParam('opener', 'u');
		}

		/**
		 * Saves edited item into temp table
		 * If there is no id, new item is created in temp table
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnPreSave(kEvent $event)
		{
			/** @var kDBItem $translator */
			$translator = $event->getObject();

			$field_values = $this->getSubmittedFields($event);
			$translator->SetFieldsFromHash($field_values);
			$event->setEventParam('form_data', $field_values);

			list($obj_prefix, $field) = $this->getPrefixAndField($event);

			/** @var kDBItem $object */
			$object = $this->Application->recallObject($obj_prefix);

			$lang = $translator->GetDBField('Language');

			$object->SetFieldOptions('l' . $lang . '_' . $field, Array ());
			$object->SetDBField('l' . $lang . '_' . $field, $translator->GetDBField('Translation'));
			$this->RemoveRequiredFields($object);
			$object->Update();
		}

		/**
		 * Changes current language in translation popup
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnChangeLanguage($event)
		{
			$event->CallSubEvent('OnPreSave');

			/** @var kDBItem $object */
			$object = $event->getObject();

			$object->SetDBField('Language', $object->GetDBField('SwitchLanguage'));

			$event->CallSubEvent('OnLoad');
			$event->redirect = false;
		}

	}
