<?php
/**
* @version	$Id: submission_log_tp.php 16513 2017-01-20 14:10:53Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class SubmissionLogTagProcessor extends kDBTagProcessor {

		/**
		 * Checks, that current log record is mail from client to admin and it's not replied
		 *
		 * @param Array $params
		 * @return bool
		 */
		function IsNewUserReply($params)
		{
			/** @var kDBItem $object */
			$object = $this->getObject($params);

			$user_reply = $this->IsUserReply($params);

			return $user_reply && ($object->GetDBField('ReplyStatus') != SUBMISSION_LOG_REPLIED);
		}

		/**
		 * Checks, that current log record is mail from client to admin
		 *
		 * @param Array $params
		 * @return bool
		 */
		function IsUserReply($params)
		{
			/** @var kDBItem $object */
			$object = $this->getObject($params);

			/** @var FormSubmissionHelper $form_submission_helper */
			$form_submission_helper = $this->Application->recallObject('FormSubmissionHelper');

			$form_submission = $form_submission_helper->getSubmissionFromLog($object);
			$form =& $form_submission_helper->getForm($form_submission);

			return $object->GetDBField('ToEmail') == $form->GetDBField('ReplyFromEmail');
		}

		/**
		 * Checks if there is draft for given article
		 *
		 * @param Array $params
		 * @return bool
		 */
		function HasDraft($params)
		{
			if (!$this->IsNewItem($params)) {
				// use drafts only for unsent (new) messages
				return false;
			}

			/** @var kDBItem $object */
			$object = $this->getObject($params);

			/** @var kDBItem $draft */
			$draft = $this->Application->recallObject('draft', null, Array('skip_autoload' => true));

			$load_keys = Array (
				'FormSubmissionId' => $object->GetDBField('FormSubmissionId'),
				'CreatedById' => $this->Application->RecallVar('user_id'),
			);

			// get existing draft for given submission and user
			$draft->Load($load_keys);

			return $draft->isLoaded();
		}

		/**
		 * Lists all files, uploadeded to given field
		 *
		 * @param Array $params
		 * @return string
		 */
		function IterateFiles($params)
		{
			/** @var kDBItem $object */
			$object = $this->getObject($params);

			$field = $this->SelectParam($params, 'name,field');
			$value = $object->GetDBField($field);

			if (!$value) {
				return '';
			}

			$ret = '';
			$files = explode('|', $value);
			$block_params = $this->prepareTagParams($params);
			$block_params['name'] = $params['render_as'];

			foreach ($files as $file) {
				$object->SetDBField($field, $file);
				$ret .= $this->Application->ParseBlock($block_params);
			}

			$object->SetDBField($field, $value);

			return $ret;
		}
	}