<?php
/**
* @version	$Id: user_profile_tp.php 16350 2016-07-10 19:51:15Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class UserProfileTagProcessor extends kDBTagProcessor {

		/**
		 * Get's requested field value.
		 *
		 * @param array $params Tag params.
		 *
		 * @return string
		 */
		public function Field($params)
		{
			$field = $this->SelectParam($params, 'name,field');
			$profile_mapping = $this->Application->getUnitOption('u', 'UserProfileMapping');
			$user_field = array_key_exists($field, $profile_mapping) ? $profile_mapping[$field] : false;

			// Get field value to show on "Public Profile" page.
			if ( array_key_exists('profile_field', $params) && $params['profile_field'] ) {
				if ( $user_field ) {
					$params['name'] = $user_field;
				}

				return $this->Application->ProcessParsedTag('u.profile', 'Field', $params);
			}

			if ( $user_field ) {
				// Determine if field should be shown on "Public Profile" page (always checkbox).
				$block_params = array('name' => 'DisplayToPublic', 'value' => $user_field);
				$selected = $this->Application->ProcessParsedTag(
					$this->getUserPrefixSpecial(),
					'Selected',
					$block_params
				);
				$value = $selected ? 1 : 0;
			}
			else {
				// Custom user preference (can by field of any type) - fallback to persistent session storage.
				$value = $this->recallUserProfileVar($field);
				$selected = $value == 1;
			}

			if ( isset($params['checked']) && $params['checked'] ) {
				return $selected ? 'checked' : '';
			}

			return $value;
		}

		/**
		 * Returns prefix and special of user to operate with
		 *
		 * @return string
		 */
		function getUserPrefixSpecial()
		{
			return $this->Application->GetVar('user_id') ? 'u.profile' : 'u.current';
		}

		/**
		 * Allows to get persistent var from other user
		 *
		 * @param string $var_name
		 * @return mixed
		 */
		function recallUserProfileVar($var_name)
		{
			static $cache = null;

			if (!isset($cache)) {
				$user = $this->Application->recallObject( $this->getUserPrefixSpecial() );
				/* @var $user kDBItem */

				$sql = 'SELECT VariableValue, VariableName
						FROM ' . TABLE_PREFIX . 'UserPersistentSessionData
						WHERE (PortalUserId = ' . $user->GetID() . ')';
				$cache = $this->Conn->GetCol($sql, 'VariableName');
			}

			if (array_key_exists($var_name, $cache)) {
				// get variable value from persistent session
				return $cache[$var_name];
			}
			else {
				// not found in persistent session -> get default value from config variable with same name
				$config_value = $this->Application->ConfigValue($var_name);

				if ($config_value !== false) {
					return $config_value;
				}
			}

			return false;
		}



		/**
		 * Returns visible field count in user profile
		 *
		 * @param Array $params
		 * @return int
		 */
		function ProfileFieldCount($params)
		{
			static $field_count = null;

			if (!isset($field_count)) {
				$user = $this->Application->recallObject( $this->getUserPrefixSpecial() );
				/* @var $user kDBItem */

				$display_to_public = $user->GetDBField('DisplayToPublic');
				$field_count = $display_to_public ? substr_count($display_to_public, '|') - 1 : 0;
			}

			return $field_count;
		}

		/**
		 * Allows to detect that not all fields were shown
		 *
		 * @param Array $params
		 * @return bool
		 * @access protected
		 */
		protected function NotLastField($params)
		{
			$counter = (int)$this->Application->GetVar( $params['counter'] );

			return $counter < $this->ProfileFieldCount($params);
		}

		/**
		 * Because of persistent session table doesn't have ids, we use user id as id for each record
		 *
		 * @param Array $params
		 * @return Array (id,field)
		 * @access private
		 */
		function prepareInputName($params)
		{
			$params['force_id'] = $this->Application->RecallVar('user_id');

			return parent::prepareInputName($params);
		}

	}
