<?php
/**
* @version	$Id: email_queue_config.php 16388 2016-08-11 08:16:43Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

$config = Array (
	'Prefix' => 'email-queue',
	'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
	'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
	'EventHandlerClass' => Array ('class' => 'kDBEventHandler', 'file' => '', 'build_event' => 'OnBuild'),
	'TagProcessorClass' => Array ('class' => 'EmailQueueTagProcessor', 'file' => 'email_queue_tp.php', 'build_event' => 'OnBuild'),

	'AutoLoad' => true,

	'QueryString' => Array (
		1 => 'id',
		2 => 'Page',
		3 => 'PerPage',
		4 => 'event',
		5 => 'mode',
	),

	'IDField' => 'EmailQueueId',

	'TableName' => TABLE_PREFIX . 'EmailQueue',

	'TitlePresets' => Array (
		'email_queue_list' => Array ('prefixes' => Array ('email-queue_List'), 'format' => '!la_tab_EmailQueue!',),
	),

	'PermSection' => Array ('main' => 'in-portal:email_queue'),

	'Sections' => Array (
		'in-portal:email_queue' => Array (
			'parent' => 'in-portal:mailing_folder',
			'icon' => 'mailing_list',
			'label' => 'la_tab_EmailQueue',
			'url' => Array ('t' => 'logs/email_logs/email_queue_list', 'pass' => 'm'),
			'permissions' => Array ('view', 'delete'),
			'priority' => 5.2, // <parent_priority>.<own_priority>, because this section replaces parent in tree
			'type' => stTAB,
		),
	),

	'ListSQLs' => Array (
		'' => '	SELECT %1$s.* %2$s
				FROM %1$s',
	),

	'ListSortings' => Array (
		'' => Array (
			'Sorting' => Array ('Queued' => 'desc'),
		)
	),

	'Fields' => Array (
		'EmailQueueId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'ToEmail' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
		'Subject' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
		'MessageHeaders' => Array ('type' => 'string', 'default' => NULL),
		'MessageBody' => Array ('type' => 'string', 'default' => NULL),
		'Queued' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => NULL),
		'SendRetries' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'LastSendRetry' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => NULL),
		'MailingId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
	),

	'Grids' => Array (
		'Default' => Array (
			'Icons' => Array ('default' => 'icon16_item.png'),
			'Fields' => Array (
				'EmailQueueId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 70, ),
				'MailingId' => Array ('title' => 'la_col_MailingList', 'filter_block' => 'grid_range_filter', 'width' => 70, ),
				'ToEmail' => Array ('title' => 'la_prompt_AddressTo', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
				'Subject' => Array ('filter_block' => 'grid_like_filter', 'width' => 200, ),
				'MessageHeaders' => Array ('title' => 'la_col_MessageHeaders', 'data_block' => 'grid_headers_td', 'filter_block' => 'grid_like_filter', 'width' => 130, ),
				'Queued' => Array ('title' => 'la_col_Queued', 'filter_block' => 'grid_date_range_filter', 'width' => 80, ),
				'SendRetries' => Array ('title' => 'la_col_SendRetries', 'filter_block' => 'grid_range_filter', 'width' => 100, ),
				'LastSendRetry' => Array ('title' => 'la_col_LastSendRetry', 'filter_block' => 'grid_date_range_filter', 'width' => 150, ),
			),
		),
	),
);