<?php

$config = Array (
	'Prefix' => 'promo-block-group',
	'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
	'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
	'EventHandlerClass' => Array ('class' => 'PromoBlockGroupEventHandler', 'file' => 'promo_block_group_eh.php', 'build_event' => 'OnBuild'),
	'TagProcessorClass' => Array ('class' => 'PromoBlockGroupTagProcessor', 'file' => 'promo_block_group_tp.php', 'build_event' => 'OnBuild'),

	'AutoLoad' => true,

	'QueryString' => Array (
		1 => 'id',
		2 => 'Page',
		3 => 'PerPage',
		4 => 'event',
		5 => 'mode',
	),

	'IDField' => 'PromoBlockGroupId',

	'TableName' => TABLE_PREFIX . 'PromoBlockGroups',

	'TitleField' => 'Title',

	'StatusField' => Array ('Status'),

	'TitlePresets' => Array (
		'default' => Array (
			'new_status_labels' => Array ('promo-block-group' => '!la_title_AddingPromoBlockGroup!'),
			'edit_status_labels' => Array ('promo-block-group' => '!la_title_EditingPromoBlockGroup!'),
		),

		'promo_block_group_list' => Array ('prefixes' => Array ('promo-block-group_List'), 'format' => "!la_title_PromoBlockGroups! (#promo-block-group_recordcount#)"),
		'promo_block_group_edit' => Array ('prefixes' => Array ('promo-block-group'), 'format' => "#promo-block-group_status# '#promo-block-group_titlefield#'"),
	),

	'PermSection' => Array ('main' => 'in-portal:promo_block_groups'),

	'Sections' => Array (
		'in-portal:promo_block_groups' => Array (
			'parent' => 'in-portal:site',
			'icon' => 'promo_block_groups',
			'label' => 'la_tab_PromoBlocks',
			'url' => Array ('t' => 'promo_block_groups/promo_block_group_list', 'pass' => 'm'),
			'late_load' => Array ('t' => 'promo_block_groups/tree_section_xml', 'pass' => 'm'),
			'permissions' => Array ('view', 'add', 'edit', 'delete'),
			'priority' => 7,
			'type' => stTREE,
		),
	),

	'CalculatedFields' => Array (
		'' => Array (
			'AssignedToSections' => '(SELECT GROUP_CONCAT(CategoryId SEPARATOR ";") FROM '.TABLE_PREFIX.'Categories WHERE PromoBlockGroupId = %1$s.PromoBlockGroupId)',
		),
	),


	'ListSQLs' => Array (
		'' => '	SELECT %1$s.* %2$s
				FROM %1$s',
	),

	'ListSortings' => Array (
		'' => Array (
			'Sorting' => Array ('Title' => 'asc'),
		)
	),

	'Fields' => Array (
		'PromoBlockGroupId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'Title' => Array (
			'type' => 'string', 'max_len' => 255,
			'not_null' => 1, 'required' => 1, 'default' => '',
		),
		'CreatedOn' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
		'Status' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Enabled',  0 => 'la_Disabled'), 'use_phrases' => 1,
			'not_null' => 1, 'required' => 1, 'default' => 1,
		),
		'RotationDelay' => Array ('type' => 'float', 'formatter' => 'kFormatter', 'format' => '%01.2f', 'required' => 1, 'default' => NULL),
		'TransitionTime' => Array ('type' => 'float', 'formatter' => 'kFormatter', 'format' => '%01.2f', 'required' => 1, 'default' => NULL),
		'TransitionControls' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Enabled',  0 => 'la_Disabled'), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 1,
		),
		'TransitionEffect' => Array (
			'type' => 'string',
			'formatter' => 'kOptionsFormatter', 'options' => Array ('fade' => 'la_opt_AnimationFade',  'slide' => 'la_opt_AnimationSlide',  '-1' => 'la_opt_AnimationCustom'), 'use_phrases' => 1,
			'not_null' => 1, 'required' => 1, 'default' => '',
		),
		'TransitionEffectCustom' => Array (
			'type' => 'string',
			'error_field' => 'TransitionEffect',
			'formatter' => 'kFormatter',
			'not_null' => 1, 'default' => '',
		),
	),

	'VirtualFields' => Array (
		'AssignedToSections' => Array ('type' => 'string', 'default' => ''),
	),

	'Grids' => Array (
		'Default' => Array (
			'Icons' => Array ('default' => 'icon16_item.png', 0 => 'icon16_disabled.png', 1 => 'icon16_item.png'),
			'Fields' => Array (
				'PromoBlockGroupId' => Array ('title' => 'column:la_fld_Id', 'filter_block' => 'grid_range_filter', 'width' => 80),
				'Title' => Array ('filter_block' => 'grid_like_filter', 'width' => 150),
				'RotationDelay' => Array ('filter_block' => 'grid_range_filter'),
				'TransitionTime' => Array ('filter_block' => 'grid_range_filter'),
				'TransitionControls' => Array ('filter_block' => 'grid_options_filter'),
				'TransitionEffect' => Array ('filter_block' => 'grid_options_filter'),
				'TransitionEffectCustom' => Array ('filter_block' => 'grid_like_filter'),
			),
		),
	),
);