<?php
/**
* @version	$Id: languages_config.php 16388 2016-08-11 08:16:43Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

$config = Array (
	'Prefix' => 'lang',
	'ItemClass' => Array ('class' => 'LanguagesItem', 'file' => 'languages_item.php', 'build_event' => 'OnItemBuild'),
	'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
	'EventHandlerClass' => Array ('class' => 'LanguagesEventHandler', 'file' => 'languages_event_handler.php', 'build_event' => 'OnBuild'),
	'TagProcessorClass' => Array ('class' => 'LanguagesTagProcessor', 'file' => 'languages_tag_processor.php', 'build_event' => 'OnBuild'),

	'AutoLoad' => true,

	'Hooks' => Array (
		Array (
			'Mode' => hAFTER,
			'Conditional' => false,
			'HookToPrefix' => 'lang',
			'HookToSpecial' => '*',
			'HookToEvent' => Array ('OnSave', 'OnMassDelete'),
			'DoPrefix' => '',
			'DoSpecial' => '',
			'DoEvent' => 'OnScheduleTopFrameReload',
		),
	),

	'QueryString' => Array (
		1 => 'id',
		2 => 'Page',
		3 => 'PerPage',
		4 => 'event',
		5 => 'mode',
	),

	'IDField' => 'LanguageId',

	'StatusField' => Array ('Enabled', 'PrimaryLang'), // field, that is affected by Approve/Decline events

	'TitleField' => 'PackName', // field, used in bluebar when editing existing item

	'TitlePresets' => Array (
		'default' => Array (
			'new_status_labels' => Array ('lang' => '!la_title_Adding_Language!'),
			'edit_status_labels' => Array ('lang' => '!la_title_Editing_Language!'),
		),
		'languages_list' => Array (
			'prefixes' => Array ('lang_List'), 'format' => "!la_title_Configuration! - !la_title_LanguagePacks!",
			'toolbar_buttons' => Array (
				'new_item', 'edit', 'delete', 'export', 'import', 'setprimary', 'refresh', 'view', 'dbl-click'
			),
		),
		'languages_edit_general' => Array ('prefixes' => Array ('lang'), 'format' => "#lang_status# '#lang_titlefield#' - !la_title_General!"),
		'phrases_list' => Array (
			'prefixes' => Array ('lang', 'phrases_List'), 'format' => "#lang_status# '#lang_titlefield#' - !la_title_Labels!"
		),
		'phrase_edit' => Array (
			'prefixes' => Array ('phrases'),
			'new_status_labels' => Array ('phrases' => '!la_title_Adding_Phrase!'),
			'edit_status_labels' => Array ('phrases' => '!la_title_Editing_Phrase!'),
			'format' => "#phrases_status# '#phrases_titlefield#'",
		),
		'import_language' => Array (
			'prefixes' => Array ('phrases.import'), 'format' => "!la_title_InstallLanguagePackStep1!",
		),
		'import_language_step2' => Array (
			'prefixes' => Array ('phrases.import'), 'format' => "!la_title_InstallLanguagePackStep2!",
		),
		'export_language' => Array (
			'prefixes' => Array ('phrases.export'), 'format' => "!la_title_ExportLanguagePackStep1!",
		),
		'export_language_results' => Array (
			'prefixes' => Array (), 'format' => "!la_title_ExportLanguagePackResults!",
		),
		'events_list' => Array (
			'prefixes' => Array ('lang', 'email-template_List'), 'format' => "#lang_status# '#lang_titlefield#' - !la_title_EmailTemplates!",
		),
		'email_template_edit' => Array (
			'prefixes' => Array ('lang', 'email-template'),
			'format' => "#lang_status# '#lang_titlefield#' - !la_title_EditingEmailTemplate! '#email-template_titlefield#'",
			'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next'),
		),
		// for separate language list
		'languages_list_st' => Array (
			'prefixes' => Array ('lang_List'), 'format' => "!la_title_LanguagesManagement!",
		),
	),

	'EditTabPresets' => Array (
		'Default' => Array (
			'general' => Array ('title' => 'la_tab_General', 't' => 'regional/languages_edit', 'priority' => 1),
			'labels' => Array ('title' => 'la_tab_Labels', 't' => 'regional/languages_edit_phrases', 'priority' => 2),
			'email_events' => Array ('title' => 'la_tab_EmailTemplates', 't' => 'regional/languages_edit_email_events', 'priority' => 3),
		),
	),

	'PermSection' => Array ('main' => 'in-portal:configure_lang'),

	'Sections' => Array (
		'in-portal:configure_lang' => Array (
			'parent' => 'in-portal:website_setting_folder',
			'icon' => 'conf_regional',
			'label' => 'la_tab_Regional',
			'url' => Array ('t' => 'regional/languages_list', 'pass' => 'm'),
			'permissions' => Array ('view', 'add', 'edit', 'delete', 'advanced:set_primary', 'advanced:import', 'advanced:export'),
			'priority' => 4,
			'type' => stTREE,
		),

		// "Lang. Management"
		/*'in-portal:lang_management' => Array (
			'parent' => 'in-portal:system',
			'icon' => 'core:settings_general',
			'label' => 'la_title_LangManagement',
			'url' => Array ('t' => 'languages/language_list', 'pass' => 'm'),
			'permissions' => Array ('view', 'add', 'edit', 'delete'),
			'perm_prefix' => 'lang',
			'priority' => 10.03,
			'show_mode' => smSUPER_ADMIN,
			'type' => stTREE,
		),*/
	),

	'TableName' => TABLE_PREFIX . 'Languages',

	'AutoDelete' => true,
	'AutoClone' => true,

	'ListSQLs' => Array (
		'' => '	SELECT *
				FROM %s'
	),

	'ListSortings' => Array (
		'' => Array (
			'Sorting' => Array ('Priority' => 'desc', 'PackName' => 'asc'),
		),
	),

	'Fields' => Array (
		'LanguageId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'PackName' => Array (
			'type' => 'string',
			'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Languages ORDER BY PackName', 'option_title_field' => 'PackName', 'option_key_field' => 'PackName',
			'not_null' => 1, 'required' => 1, 'default' => ''
		),
		'LocalName' => Array (
			'type' => 'string',
			'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Languages ORDER BY PackName', 'option_title_field' => 'LocalName', 'option_key_field' => 'LocalName',
			'not_null' => 1, 'required' => 1, 'default' => ''
		),
		'Enabled' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_Disabled', 1 => 'la_Active'), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 1
		),
		'PrimaryLang' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 0
		),
		'AdminInterfaceLang' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 0
		),
		'Priority' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'IconURL' => Array ('type' => 'string', 'max_len' => 255, 'default' => NULL),
		'IconDisabledURL' => Array ('type' => 'string', 'max_len' => 255, 'default' => NULL),
		'InputDateFormat' => Array (
			'type' => 'string',
			'formatter' => 'kOptionsFormatter',
			'options' => Array ('m/d/Y' => 'mm/dd/yyyy', 'd/m/Y' => 'dd/mm/yyyy', 'm.d.Y' => 'mm.dd.yyyy', 'd.m.Y' => 'dd.mm.yyyy'),
			'not_null' => 1, 'required' => 1, 'default' => 'm/d/Y'
		),
		'InputTimeFormat' => Array (
			'type' => 'string',
			'formatter' => 'kOptionsFormatter',
			'options' => Array ('g:i:s A' => 'g:i:s A', 'g:i A' => 'g:i A', 'H:i:s' => 'H:i:s', 'H:i' => 'H:i'),
			'not_null' => '1', 'required' => 1, 'default' => 'g:i:s A',
		),
		'DateFormat' => Array ('type' => 'string', 'not_null' => 1, 'required' => 1, 'default' => 'm/d/Y'),
		'ShortDateFormat' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => 'm/d'),
		'TimeFormat' => Array ('type' => 'string', 'not_null' => 1, 'required' => 1, 'default' => 'g:i:s A'),
		'ShortTimeFormat' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => 'g:i A'),
		'DecimalPoint' => Array ('type' => 'string', 'not_null' => 1, 'required' => 1, 'default' => '.'),
		'ThousandSep' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
		'UnitSystem' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Metric', 2 => 'la_US_UK'), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 1
		),
		'FilenameReplacements' => Array ('type' => 'string', 'default' => NULL),
		'Locale' => Array (
			'type' => 'string',
			'formatter' => 'kOptionsFormatter',
			'options_sql' => "	SELECT CONCAT(LocaleName, ' ' ,'\/',Locale,'\/') AS Name, Locale
								FROM " . TABLE_PREFIX . 'LocalesList
								ORDER BY LocaleId',
			'option_title_field' => 'Name', 'option_key_field' => 'Locale',
		 	'not_null' => 1, 'default' => 'en-US',
		),
		'UserDocsUrl' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
		'SynchronizationModes' => Array (
			'type' => 'string', 'max_len' => 255,
			'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_opt_SynchronizeToOthers', 2 => 'la_opt_SynchronizeFromOthers'), 'use_phrases' => 1, 'multiple' => 1,
			'not_null' => 1, 'default' => ''
		),
		'HtmlEmailTemplate' => Array (
			'type' => 'string',
			'error_msgs' => Array ('parsing_error' => '!la_error_ParsingError!', 'body_missing' => '!la_error_EmailTemplateBodyMissing!'),
			'default' => '$body'
		),
		'TextEmailTemplate' => Array (
			'type' => 'string',
			'error_msgs' => Array ('parsing_error' => '!la_error_ParsingError!', 'body_missing' => '!la_error_EmailTemplateBodyMissing!'),
			'default' => NULL
		),
	),

	'VirtualFields' => Array (
		'Charset' => Array ('type' => 'string', 'default' => CHARSET), // for backwards compatibility
		'CopyLabels' => Array ('type' => 'int', 'default' => 0),
		'CopyFromLanguage' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Languages ORDER BY PackName', 'option_title_field' => 'PackName', 'option_key_field' => 'LanguageId',
			'default' => '',
		),
	),

	'Grids' => Array (
		'Default' => Array (
			'Icons' => Array (
				'default' => 'icon16_item.png',
				'0_0' => 'icon16_disabled.png',
				'0_1' => 'icon16_disabled.png',
				'1_0' => 'icon16_item.png',
				'1_1' => 'icon16_primary.png',
			),
			'Fields' => Array (
				'LanguageId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 50, ),
				'PackName' => Array ('filter_block' => 'grid_options_filter', 'width' => 150, ),//
				'PrimaryLang' => Array ('title' => 'la_col_IsPrimaryLanguage', 'filter_block' => 'grid_options_filter', 'width' => 150, ),
				'AdminInterfaceLang' => Array ('filter_block' => 'grid_options_filter', 'width' => 150, ),
				'Priority' => Array ('filter_block' => 'grid_like_filter', 'width' => 60, ),
				'Enabled' => Array ('filter_block' => 'grid_options_filter', 'width' => 80, ),
				'SynchronizationModes' => Array ('filter_block' => 'grid_picker_filter', 'width' => 120, 'format' => ', ', 'hidden' => 1),
			),
		),

		/*'LangManagement' => Array (
			'Icons' => Array (
				'default' => 'icon16_item.png',
				'0_0' => 'icon16_disabled.png',
				'0_1' => 'icon16_disabled.png',
				'1_0' => 'icon16_item.png',
				'1_1' => 'icon16_primary.png',
			),
			'Fields' => Array (
				'LanguageId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60),
				'PackName' => Array ('title' => 'column:la_fld_Language', 'filter_block' => 'grid_options_filter', 'width' => 120),
				'LocalName' => Array ('title' => 'column:la_fld_Prefix', 'filter_block' => 'grid_options_filter', 'width' => 120),
				'IconURL' => Array ('title' => 'column:la_fld_Image', 'filter_block' => 'grid_empty_filter', 'width' => 80),
			),
		),*/
	),
);