
(function()
{
	CKEDITOR.plugins.add( 'my_maximize',
	{
		init : function( editor )
		{
			var lang = editor.lang.maximize;
			var mainDocument = CKEDITOR.document,
				mainWindow = mainDocument.getWindow();

			// Retain state after mode switches.
			var savedState = CKEDITOR.TRISTATE_OFF;

			editor.addCommand( 'maximize',
				{
					modes : { wysiwyg : 1, source : 1 },
					editorFocus : false,
					exec : function()
					{
						var $parent_window = window.parent;

						if ( $use_popups ) {
							if ( $modal_windows ) {
								$parent_window.$('#' + $parent_window.TB.getId('TB_title')).dblclick();
							}
							else {
								var $window = $(window);

								if ( this.state == CKEDITOR.TRISTATE_OFF ) {		// Go fullscreen if the state is off.
									$window.data('window_size', $window.width() + 'x' + $window.height());

									window.moveTo(0, 0);
									window.resizeTo(screen.width, screen.height);
								}
								else if ( this.state == CKEDITOR.TRISTATE_ON ) {	// Restore from fullscreen if the state is on.
									var $window_size = $window.data('window_size').split('x');
									var $left = Math.round((screen.width - $window_size[0]) / 2);
									var $top = Math.round((screen.height - $window_size[1]) / 2);

									window.resizeTo($window_size[0], $window_size[1]);
									window.moveTo($left, $top);
								}
							}
						}

						this.toggleState();

						// Toggle button label.
						var button = this.uiItems[ 0 ];
						// Only try to change the button if it exists (#6166)
						if( button )
						{
							var label = ( this.state == CKEDITOR.TRISTATE_OFF )
								? lang.maximize : lang.minimize;
							var buttonNode = editor.element.getDocument().getById( button._.id );
							buttonNode.getChild( 1 ).setHtml( label );
							buttonNode.setAttribute( 'title', label );
							buttonNode.setAttribute( 'href', 'javascript:void("' + label + '");' );
						}
					},
					canUndo : false
				} );

			editor.ui.addButton( 'Maximize',
				{
					label : lang.maximize,
					command : 'maximize'
				} );

			// Restore the command state after mode change, unless it has been changed to disabled (#6467)
			editor.on( 'mode', function()
				{
					var command = editor.getCommand( 'maximize' );
					command.setState( command.state == CKEDITOR.TRISTATE_DISABLED ? CKEDITOR.TRISTATE_DISABLED : savedState );
				}, null, null, 100 );
		}
	} );
})();
