<?php
/**
* @version	$Id: system_log_eh.php 15608 2012-11-06 17:21:28Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2012 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class SystemLogEventHandler extends kDBEventHandler {

	/**
	 * Filters messages, that require e-mail notification to be sent
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function SetCustomQuery(kEvent $event)
	{
		parent::SetCustomQuery($event);

		$object = $event->getObject();
		/* @var $object kDBList */

		if ( $event->Special == 'email' ) {
			$unique_id = $event->getEventParam('unique_id');

			if ( $unique_id !== false ) {
				$object->addFilter('notification_filter', '%1$s.LogNotificationStatus = ' . kLogger::LNS_SENT);
				$object->addFilter('unique_filter', '%1$s.LogUniqueId = ' . $unique_id);
			}
			else {
				$object->addFilter('notification_filter', '%1$s.LogNotificationStatus = ' . kLogger::LNS_PENDING);
			}
		}
	}

	/**
	 * [SCHEDULED TASK] Sends delayed notification of system log messages
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnSendNotifications(kEvent $event)
	{
		// initialize list outside of e-mail event with right settings
		$list = $this->Application->recallObject($event->Prefix . '.email', $event->Prefix . '_List', Array ('per_page' => 20));
		/* @var $list kDBList */

		if ( !$list->GetRecordsCount() ) {
			// no messages, that needs to be sent
			return;
		}

		$notification_email = $this->Application->ConfigValue('SystemLogNotificationEmail');

		if ( !$notification_email ) {
			$this->Application->removeObject($event->Prefix . '.email');
			trigger_error('System Log notification E-mail not specified', E_USER_NOTICE);

			return;
		}

		$send_params = Array (
			'to_name' => $notification_email,
			'to_email' => $notification_email,
		);

		$this->Application->emailAdmin('SYSTEM.LOG.NOTIFY', null, $send_params);
		$this->Application->removeObject($event->Prefix . '.email');

		$object = $event->getObject(Array ('skip_autoload' => true));
		/* @var $object kDBItem */

		foreach ($list as $fields_hash) {
			$object->LoadFromHash($fields_hash);
			$object->SetDBField('LogNotificationStatus', kLogger::LNS_SENT);
			$object->Update();
		}
	}

	/**
	 * [SCHEDULED TASK] Will remove old system logs
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnRotate(kEvent $event)
	{
		$rotation_interval = (int)$this->Application->ConfigValue('SystemLogRotationInterval');

		if ( $rotation_interval === -1 ) {
			// forever
			return;
		}

		$sql = 'SELECT ' . $this->Application->getUnitOption($event->Prefix, 'IDField') . '
				FROM ' . $this->Application->getUnitOption($event->Prefix, 'TableName') . '
				WHERE ' . TIMENOW . ' - LogTimestamp > ' . $rotation_interval . '
				LIMIT 0,50';
		$ids = $this->Conn->GetCol($sql);

		if ( $ids ) {
			$temp_handler = $this->Application->recallObject($event->getPrefixSpecial() . '_TempHandler', 'kTempTablesHandler', Array ('parent_event' => $event));
			/* @var $temp_handler kTempTablesHandler */

			$temp_handler->DeleteItems($event->Prefix, $event->Special, $ids);
		}
	}
}
