<?php
/**
* @version	$Id: configuration_config.php 15471 2012-07-23 17:10:50Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'conf',
		'ItemClass' => Array ('class' => 'ConfigurationItem', 'file' => 'configuration.php', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'ConfigurationEventHandler', 'file' => 'configuration_event_handler.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'ConfigurationTagProcessor', 'file' => 'configuration_tag_processor.php', 'build_event' => 'OnBuild'),
		'ValidatorClass' => 'ConfigurationValidator',

		'AutoLoad' => true,

		'RegisterClasses' => Array (
			Array ('pseudo' => 'ConfigurationValidator', 'class' => 'ConfigurationValidator', 'file' => 'configuration_validator.php', 'build_event' => ''),
		),

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'PerPage',
			4 => 'event',
			5 => 'mode',
		),

		'IDField' => 'VariableId',
		'TitleField' => 'VariableName',

		'TitlePresets' => Array (
			'default' => Array ('tag_params' => Array ('conf' => Array ('per_page' => -1))),

			'config_list_general' => Array ('prefixes' => Array ('conf_List'), 'format' => "!la_updating_config!"),
			'config_list_output' => Array ('prefixes' => Array ('conf_List'), 'format' => "!la_updating_config!"),
			'config_list_contacts' => Array ('prefixes' => Array ('conf_List'), 'format' => "!la_updating_config!"),

			'config_list_categories' => Array ('prefixes' => Array ('conf_List'), 'format' => "!la_updating_config!"),
			'config_list_users' => Array ('prefixes' => Array ('conf_List'), 'format' => "!la_updating_config!"),

			'section_label' => Array ('prefixes' => Array ('conf_List'), 'format' => "#section_label#"),

			'config_edit' => Array (
				'new_status_labels' => Array ('conf' => '!la_title_AddingSystemSetting!'),
				'edit_status_labels' => Array ('conf' => '!la_title_EditingSystemSetting!'),
				'prefixes' => Array ('conf'), 'format' => "#conf_status# '#conf_titlefield#'",
			),
		),

		'TableName' => TABLE_PREFIX . 'SystemSettings',

		'ListSQLs' => Array (
			'' => 'SELECT %1$s.* %2$s FROM %1$s'
		),

		'ListSortings' => Array (
			'' => Array (
				'Sorting' => Array ('DisplayOrder' => 'asc', 'GroupDisplayOrder' => 'asc'),
			)
		),

  		'Fields' => Array (
			'VariableId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'VariableName' => Array (
				'type' => 'string',
				'formatter' => 'kFormatter', 'regexp' => '/^[a-z0-9_]+$/i',
				'not_null' => 1, 'required' => 1, 'default' => ''
			),
			'VariableValue' => Array ('type' => 'string', 'default' => NULL),
			'ModuleOwner' => Array (
				'type' => 'string',
				'formatter' => 'kOptionsFormatter', 'options' => Array (),
				'required' => 1, 'default' => 'In-Portal'
			),
			'Section' => Array (
				'type' => 'string',
				'error_msgs' => Array ('unknown_section' => '!la_error_UnknownSection!'),
				'not_null' => 1, 'required' => 1, 'default' => ''
			),
			'Heading' => Array (
				'type' => 'string',
				'formatter' => 'kFormatter', 'regexp' => '/^la_section_[A-Z\d:_\-\.]+$/i',
				'not_null' => 1, 'required' => 1, 'default' => ''
			),
	        'Prompt' => Array (
				'type' => 'string',
				'formatter' => 'kFormatter', 'regexp' => '/^la_config_[A-Z\d:_\-\.]+$/i',
				'not_null' => 1, 'required' => 1, 'default' => ''
			),
	        'ElementType' => Array (
				'type' => 'string',
				'formatter' => 'kOptionsFormatter', 'options' => Array ('text' => 'la_type_text', 'select' => 'la_type_select', 'multiselect' => 'la_type_multiselect', 'radio' => 'la_type_radio', 'checkbox' => 'la_type_checkbox', 'password' => 'la_type_password', 'textarea' => 'la_type_textarea'), 'use_phrases' => 1,
				'not_null' => 1, 'required' => 1, 'default' => ''
			),
	        'Validation' => Array ('type' => 'string', 'default' => NULL),
	        'ValueList' => Array ('type' => 'string', 'default' => NULL),
	        'DisplayOrder' => Array (
				'type' => 'float',
				'unique' => Array ('ModuleOwner', 'Section', 'GroupDisplayOrder'),
				'not_null' => 1, 'required' => 1, 'default' => 0
			),
	        'GroupDisplayOrder' => Array (
				'type' => 'float',
				'unique' => Array ('ModuleOwner', 'Section', 'DisplayOrder'),
				'not_null' => 1, 'required' => 1, 'default' => 0
			),
	        'Install' => Array ('type' => 'int', 'not_null' => 1, 'default' => 1),
	        'HintLabel' => Array ('type' => 'string', 'max_len' => 255, 'default' => NULL),
		),

		'VirtualFields' => Array (
	        'DirectOptions'		=>	Array ('type' => 'string', 'default' => ''),
		),
	);