<?php

/**
* @version	$Id: inp_session_storage.php 15569 2012-10-10 13:29:39Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class InpSessionStorage extends SessionStorage {

	public function Init($prefix, $special)
	{
		parent::Init($prefix, $special);

		$this->TableName = TABLE_PREFIX.'UserSessions';
		$this->SessionDataTable = TABLE_PREFIX.'UserSessionData';
		$this->IDField = 'SessionKey';
		$this->TimestampField = 'LastAccessed';
		$this->DataValueField = 'VariableValue';
		$this->DataVarField = 'VariableName';
	}

	function LocateSession($sid)
	{
		$res = parent::LocateSession($sid);
		if ($res) {
			$this->Expiration +=  $this->SessionTimeout;
		}
		return $res;
	}

	function UpdateSession($timeout = 0)
	{
		$time = adodb_mktime();
		// Update LastAccessed only if it's newer than 1/10 of session timeout - perfomance optimization to eliminate needless updates on every click
//		if ($time - $this->DirectVars['LastAccessed'] > $this->SessionTimeout/10) {
			$this->SetField($this->TimestampField, $time + $this->SessionTimeout);
//		}
	}

	function GetSessionDefaults()
	{
		$fields_hash = Array (
			'PortalUserId'	=>	$this->Application->isAdmin ? 0 : USER_GUEST,
			'Language'		=>	$this->Application->GetDefaultLanguageId(true),
			'Theme'			=>	$this->Application->GetDefaultThemeId(),
			'GroupId'		=>	$this->Application->ConfigValue('User_GuestGroup'),
			'GroupList'		=>	$this->Application->ConfigValue('User_GuestGroup'),
			'IpAddress'		=>	$this->Application->getClientIp(),
		);

		if ( !$this->Application->isAdmin ) {
			// Guest users on Front-End belongs to Everyone group too
			$fields_hash['GroupList'] .= ',' . $this->Application->ConfigValue('User_LoggedInGroup');
		}

		return array_merge($fields_hash, parent::GetSessionDefaults());
	}

	function GetExpiredSIDs()
	{
		$query = ' SELECT '.$this->IDField.' FROM '.$this->TableName.' WHERE  '.$this->TimestampField.' < '.(adodb_mktime());
		$ret = $this->Conn->GetCol($query);
		if($ret) {
			$this->DeleteEditTables();
		}
		return $ret;

	}

	function DeleteEditTables()
	{
		$tables = $this->Conn->GetCol('SHOW TABLES');
		$mask_edit_table = '/'.TABLE_PREFIX.'ses_(.*)_edit_(.*)/';
		$mask_search_table = '/'.TABLE_PREFIX.'ses_(.*?)_(.*)/';

		$sql='SELECT COUNT(*) FROM '.$this->TableName.' WHERE '.$this->IDField.' = \'%s\'';
		foreach($tables as $table)
		{
			if( preg_match($mask_edit_table,$table,$rets) || preg_match($mask_search_table,$table,$rets) )
			{
				$sid = preg_replace('/(.*)_(.*)/', '\\1', $rets[1]); // remove popup's wid from sid
				$is_alive = $this->Conn->GetOne( sprintf($sql,$sid) );
				if(!$is_alive) $this->Conn->Query('DROP TABLE IF EXISTS '.$table);
			}
		}
	}
}