<?php
/**
* @version	$Id: brackets_tag_processor.php 15540 2012-09-14 15:37:53Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class BracketsTagProcessor extends kDBTagProcessor {

	function Field($params)
	{
		$value = parent::Field($params);
		$field = $this->SelectParam($params, 'name,field');

		if ( ($field == 'Start' || $field == 'End') && $value == -1 ) {
			$value = '&#8734;';
		}

		return $value;
	}

	function ShowBracketsForm($params)
	{
		$shipping_object = $this->Application->recallObject('s');
		/* @var $shipping_object kDBItem */

		$default_start = ($shipping_object->GetDBField('Type') == 1) ? 0 : 1;

		$brackets_helper = $this->Application->recallObject('BracketsHelper');
		/* @var $brackets_helper kBracketsHelper */

		$brackets_helper->InitHelper('Start', 'End', Array(), $default_start );

		$br_object = $this->Application->recallObject( $this->getPrefixSpecial() );

		$event = new kEvent($this->getPrefixSpecial(true) . ':OnArrange');
		$br_data = $brackets_helper->getBrackets($event);
		$linked_info = $br_object->getLinkedInfo($this->Special);

		if (!$br_data) {
			$sql = 	'SELECT * FROM '.$br_object->TableName.' WHERE '.$linked_info['ForeignKey'].' = '.$linked_info['ParentId'];
			$brackets = $this->Conn->Query($sql, $br_object->IDField);

			usort($brackets, Array(&$brackets_helper, 'compareBrackets'));

			$dummy = $this->Application->recallObject($this->Prefix.'.-dummy', null, array('skip_autoload' => true));
			/* @var $dummy kDBItem */

			// performs number formatting
			foreach($brackets as $id => $values)
			{
				foreach($values as $value_key=>$value_val){
					$dummy->SetDBField($value_key, $value_val);
					$brackets[$id][$value_key] = $dummy->GetField($value_key);
				}
			}

			$br_data = $brackets;
			$brackets_helper->setBrackets($event, $brackets);
		}
		else {
			usort($br_data, Array(&$brackets_helper, 'compareBrackets'));
			$br_data = $brackets_helper->formatBrackets($br_data);
		}

		$ret = '';
		if ( is_array($br_data) ) {
			$block_params = $this->prepareTagParams($params);
			$block_params['IdField'] = $br_object->IDField;
			$block_params['name'] = $params['block'];
			$first = true;

			$main_object = $this->Application->recallObject($linked_info['ParentPrefix'].'.'.$this->Special);
//			$plan_type = $main_object->GetDBField('PlanType');
//			$limits_format = ($plan_type == 2) ? '%d' : $br_object->getFieldOption('Start', 'format');

			// this is needed to find next id
			$br_data_copy = $br_data;
			foreach($br_data as $id => $values)
			{

				foreach($values as $value_key => $value_val)
				{
					$block_params[$value_key] = $value_val;
				}
				reset($values);

				next($br_data_copy);
				$next_bracket = current($br_data_copy);

//				$values['Start'] = sprintf($limits_format, $values['Start']);
//				$values['End'] = sprintf($limits_format, $values['End']);

				$block_params['id']	= $values[$br_object->IDField];
				$block_params['min'] = ($id == -1) ? ($values['Start'] ? $values['Start'] : 0) : $values['Start'];
				$block_params['max'] = ($values['End'] == -1) ? '&#8734;' : $values['End'];
				$block_params['next_min_id'] = $next_bracket[$br_object->IDField];

				$lang_object = $this->Application->recallObject('lang.current');
				if($lang_object->GetDBField('UnitSystem') == 2 && $main_object->GetDBField('Type') == 1)
				{
					if($block_params['min'] === '')
					{
						$block_params['min_a'] = '';
						$block_params['min_b'] = '';
					}
					else
					{
						list($block_params['min_a'], $block_params['min_b']) = kUtil::Kg2Pounds($block_params['min']);
					}

					if($block_params['max'] == '&#8734;')
					{
						$block_params['max_a'] = '&#8734;';
						$block_params['max_b'] = '';
					}
					else
					{
						list($block_params['max_a'], $block_params['max_b']) = kUtil::Kg2Pounds($block_params['max']);
					}
				}

				if($first)
				{
					$block_params['first'] = 1;
					$first = false;
				}
				else
				{
					$block_params['first'] = 0;
				}
				$ret .= $this->Application->ParseBlock($block_params, 1);
			}
		}
		return $ret;
	}


	/*
	function ShowBracketsForm($params)
	{
		$br_object = $this->Application->recallObject( $this->getPrefixSpecial() );

		$br_data = $this->Application->GetVar('br');

		if(!$br_data)
		{
			$sql = 	'SELECT * FROM '.$br_object->TableName.
					' WHERE ShippingTypeID = '.$this->Application->GetVar('s_id');
			$brackets = $this->Conn->Query($sql, 'BracketId');
			usort($brackets, 'bracket_comp');

			$br_data = array_reverse($brackets);
			$this->Application->SetVar('br', $br_data);
		}
		else
		{
			$br_data = array_reverse($br_data);
		}

		$ret = '';
		if( is_array($br_data) )
		{
			$i = -count($br_data);
			ksort($br_data);
			foreach($br_data as $record)
			{
				$temp_sorted[$i] = $record;
				$i++;
			}
			$br_data = array_reverse($temp_sorted, true);

			$block_params['name'] = $params['block'];
			$first = true;
			foreach($br_data as $id => $values)
			{
				$block_params['id']	= $id;
				$block_params['start']	= ($id == -1) ? ($values['Start'] ? $values['Start'] : 0) : $values['Start'];
				$block_params['end'] = ($values['End'] == -1) ? '&infin;' : $values['End'];
				if ($first)
				{
					$block_params['first'] = 1;
					$first = false;
				}
				else
				{
					$block_params['first'] = 0;
				}
				$ret .= $this->Application->ParseBlock($block_params);
			}
		}
		return $ret;
	}*/
}