<?php
/**
* @version	$Id: upgrades.php 15198 2012-03-15 09:01:54Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/
	defined('FULL_PATH') or die('restricted access!');

	$upgrade_class = 'InCommerceUpgrades';

	/**
	 * Class, that holds all upgrade scripts for "In-Commerce" module
	 *
	 */
	class InCommerceUpgrades extends kUpgradeHelper {

		public function __construct()
		{
			parent::__construct();

			$this->dependencies = Array (
				'4.3.9' => Array ('Core' => '4.3.9'),
				'5.0.0' => Array ('Core' => '5.0.0'),
				'5.0.1' => Array ('Core' => '5.0.1'),
				'5.0.2-B1' => Array ('Core' => '5.0.2-B1'),
				'5.0.2-B2' => Array ('Core' => '5.0.2-B2'),
				'5.0.2-RC1' => Array ('Core' => '5.0.2-RC1'),
				'5.0.2' => Array ('Core' => '5.0.2'),
				'5.0.3-B1' => Array ('Core' => '5.0.3-B1'),
				'5.0.3-B2' => Array ('Core' => '5.0.3-B2'),
				'5.0.3-RC1' => Array ('Core' => '5.0.3-RC1'),
				'5.0.3' => Array ('Core' => '5.0.3'),
				'5.0.4-B1' => Array ('Core' => '5.0.4-B1'),
				'5.0.4-B2' => Array ('Core' => '5.0.4-B2'),
				'5.0.4' => Array ('Core' => '5.0.4'),
				'5.1.0-B1' => Array ('Core' => '5.1.0-B1'),
				'5.1.0-B2' => Array ('Core' => '5.1.0-B2'),
				'5.1.0-RC1' => Array ('Core' => '5.1.0-RC1'),
				'5.1.0' => Array ('Core' => '5.1.0'),
				'5.1.1-B1' => Array ('Core' => '5.1.1-B1'),
				'5.1.1-B2' => Array ('Core' => '5.1.1-B2'),
				'5.1.1-RC1' => Array ('Core' => '5.1.1-RC1'),
				'5.1.1' => Array ('Core' => '5.1.1'),
				'5.1.2-B1' => Array ('Core' => '5.1.2-B1'),
				'5.1.2-B2' => Array ('Core' => '5.1.2-B2'),
				'5.1.2-RC1' => Array ('Core' => '5.1.2-RC1'),
				'5.1.2' => Array ('Core' => '5.1.2'),
				'5.1.3-B1' => Array ('Core' => '5.1.3-B1'),
				'5.1.3-B2' => Array ('Core' => '5.1.3-B2'),
				'5.1.3-RC1' => Array ('Core' => '5.1.3-RC1'),
				'5.1.3-RC2' => Array ('Core' => '5.1.3-RC2'),
				'5.1.3' => Array ('Core' => '5.1.3'),
				'5.2.0-B1' => Array ('Core' => '5.2.0-B1'),
				'5.2.0-B2' => Array ('Core' => '5.2.0-B2'),
			);
		}

		/**
		 * Changes table structure, where multilingual fields of TEXT type are present
		 *
		 * @param string $mode when called mode {before, after)
		 */
		function Upgrade_5_0_0($mode)
		{
			if ($mode == 'after') {
				// update icon
				$root_category = $this->Application->findModule('Name', 'In-Commerce', 'RootCat');

				$sql = 'UPDATE ' . $this->Application->getUnitOption('c', 'TableName') . '
						SET UseMenuIconUrl = 1, MenuIconUrl = "in-commerce/img/menu_products.gif"
						WHERE ' . $this->Application->getUnitOption('c', 'IDField') . ' = ' . $root_category;
				$this->Conn->Query($sql);

				$this->_updateDetailTemplate('p', 'in-commerce/product/details', 'in-commerce/designs/detail');

				// copy store name to company name
				$store_name = $this->Application->ConfigValue('Comm_StoreName');

				$sql = 'UPDATE ' . TABLE_PREFIX . 'ConfigurationValues
						SET VariableValue = ' . $this->Conn->qstr($store_name) . '
						WHERE VariableName = "Comm_CompanyName"';
				$this->Conn->Query($sql);
			}
		}

		/**
		 * Update to 5.0.1, update details template
		 *
		 * @param string $mode when called mode {before, after)
		 */
		function Upgrade_5_0_1($mode)
		{
			if ($mode == 'after') {
				$this->_updateDetailTemplate('p', 'in-commerce/designs/detail', 'in-commerce/products/product_detail');

				// clean incomplete orders 5+ hours old
				// don't use ORDER_STATUS_INCOMPLETE constant, since it's not available upgrade
				$delete_timestamp = mktime() - (3600 * 5);
				$sql = 'SELECT OrderId FROM ' . TABLE_PREFIX . 'Orders
							WHERE Status = ' . 0 . '
							AND OrderDate < ' . $delete_timestamp;

				$orders_to_delete = $this->Conn->GetCol($sql);

				if ( $orders_to_delete && is_array($orders_to_delete) ) {

					$this->Conn->Query( 'DELETE FROM ' . TABLE_PREFIX . 'OrderItems
											WHERE OrderId IN ( ' . implode(',', $orders_to_delete) . ' )' );

					$this->Conn->Query( 'DELETE FROM ' . TABLE_PREFIX . 'Orders
											WHERE Status = ' . 0 . '
											AND OrderDate < ' . $delete_timestamp );
				}

				// delete old events
				$events_to_delete = Array ( 'SITE.SUGGEST' );

				$sql = 'SELECT EventId FROM ' . TABLE_PREFIX . 'Events
							WHERE Event IN ("' . implode('","', $events_to_delete) . '")';
				$event_ids = $this->Conn->GetCol($sql);

				if ($event_ids) {
					$sql = 'DELETE FROM ' . TABLE_PREFIX . 'EmailMessage
								WHERE EventId IN (' . implode(',', $event_ids) . ')';
					$this->Conn->Query($sql);

					$sql = 'DELETE FROM ' . TABLE_PREFIX . 'Events
								WHERE EventId IN (' . implode(',', $event_ids) . ')';
					$this->Conn->Query($sql);

					$sql = 'DELETE FROM ' . TABLE_PREFIX . 'Phrase
								WHERE Phrase IN ("la_event_user.suggest_site")';
					$this->Conn->Query($sql);
				}
			}
		}

	}