<?php
/**
* @version	$Id: currency_rates.php 14258 2011-03-16 21:43:52Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class ECBCurrencyRates extends CurrencyRates {

	public function __construct()
	{
		$this->RateSource = 'http://www.ecb.int/stats/eurofxref/eurofxref-daily.xml';

		parent::__construct();
	}

	function GetRatesData()
	{
		$xml_parser = xml_parser_create();

		$curl_helper =& $this->Application->recallObject('CurlHelper');
		/* @var $curl_helper kCurlHelper */

		$xml = $curl_helper->Send($this->RateSource);

		xml_parse_into_struct($xml_parser, $xml, $struct, $index);
		$data_res = Array();
		foreach($struct as $element)
		{
			if(isset($element['attributes']) && isset($element['attributes']['CURRENCY']))
			{
				$currency = $element['attributes']['CURRENCY'];
				$data_res[$currency]['ID'] = $currency;
				$data_res[$currency]['TARGET'] = 'EUR';
				$data_res[$currency]['UNITS'] = 1;
				$data_res[$currency]['RATE'] = ($element['attributes']['RATE'] == 0) ? 0 : 1 / $element['attributes']['RATE'];
			}
		}
		if(!$data_res['EUR'])
		{
			$data_res['EUR']['ID'] = 'EUR';
			$data_res['EUR']['UNITS'] = 1;
			$data_res['EUR']['TARGET'] = 'EUR';
			$data_res['EUR']['RATE'] = 1;
		}
		$this->ExchangeRates = $data_res;
	}
}
